/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.arcbin;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import junit.framework.Assert;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.dataio.arcbin.ArcBinGridReader;
import org.esa.snap.dataio.arcbin.ArcBinGridReaderPlugIn;
import org.junit.Test;

public class ArcBinGridTest {
    @Test
    public void testProductIO() throws URISyntaxException, IOException {
        File file = new File(this.getClass().getResource("elevation/hdr.adf").toURI());
        Product product = ProductIO.readProduct((File)file);
        Assert.assertNotNull((Object)product);
        assert (product.getProductReader() instanceof ArcBinGridReader);
    }

    @Test
    public void testReader() throws URISyntaxException, IOException {
        File file = new File(this.getClass().getResource("elevation/hdr.adf").toURI());
        ArcBinGridReaderPlugIn plugin = new ArcBinGridReaderPlugIn();
        assert (plugin.getDecodeQualification((Object)file) == DecodeQualification.INTENDED);
        ProductReader reader = plugin.createReaderInstance();
        Assert.assertNotNull((Object)reader);
        reader.readProductNodes((Object)file, null);
    }
}

