/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.arcbin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import org.esa.beam.util.StringUtils;
import org.geotools.data.shapefile.dbf.DbaseFileReader;

public class LegendFile {
    private LegendFile() {
    }

    static Map<Integer, String> createDescriptionMap(File dir) throws IOException {
        File file = LegendFile.findDbfLegendFile(dir);
        if (file != null) {
            return LegendFile.createDbfDescriptionMap(file);
        }
        file = LegendFile.findXlsLegendFile(dir);
        if (file != null) {
            return LegendFile.createXlsDescriptionMap(file);
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<Integer, String> createXlsDescriptionMap(File file) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        try (Workbook workbook = null;){
            workbook = Workbook.getWorkbook((File)file);
            Sheet sheet = workbook.getSheet(0);
            int descColIndex = LegendFile.getSheetColIndex(sheet);
            if (descColIndex == -1) {
                Map<Integer, String> map2 = Collections.emptyMap();
                return map2;
            }
            Cell[] valueCol = sheet.getColumn(0);
            Cell[] descCol = sheet.getColumn(descColIndex);
            for (int i = 1; i < valueCol.length; ++i) {
                Cell valueCell = valueCol[i];
                String value = valueCell.getContents();
                if (StringUtils.isNullOrEmpty((String)value)) continue;
                Cell descCell = descCol[i];
                int intValue = Integer.parseInt(value.trim());
                map.put(intValue, descCell.getContents().trim());
            }
        }
        return map;
    }

    private static int getSheetColIndex(Sheet sheet) {
        Cell[] firstRow = sheet.getRow(0);
        int descColIndex = -1;
        for (int i = 0; i < firstRow.length; ++i) {
            Cell cell = firstRow[i];
            String columnName = cell.getContents().toLowerCase();
            if (!columnName.contains("class") || !columnName.contains("name")) continue;
            descColIndex = i;
        }
        return descColIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<Integer, String> createDbfDescriptionMap(File file) throws IOException {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        try (DbaseFileReader reader = new DbaseFileReader(LegendFile.createChannel(file), true, Charset.defaultCharset());){
            while (reader.hasNext()) {
                DbaseFileReader.Row row = reader.readRow();
                map.put((Integer)row.read(0), row.read(1).toString());
            }
        }
        return map;
    }

    static File findXlsLegendFile(File dir) {
        File parentDir = dir.getParentFile();
        File[] legendFiles = parentDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.startsWith(".") && name.toLowerCase().endsWith("_legend.xls");
            }
        });
        if (legendFiles.length > 0) {
            return legendFiles[0];
        }
        return null;
    }

    static File findDbfLegendFile(File dir) {
        File parentDir = dir.getParentFile();
        File[] legendFiles = parentDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.startsWith(".") && name.toLowerCase().endsWith("_legend.dbf");
            }
        });
        if (legendFiles.length > 0) {
            return legendFiles[0];
        }
        return null;
    }

    static ReadableByteChannel createChannel(File legendFile) throws FileNotFoundException {
        return new FileInputStream(legendFile).getChannel();
    }
}

