/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.arcbin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Map;
import junit.framework.Assert;
import jxl.read.biff.BiffException;
import org.esa.beam.dataio.arcbin.LegendFile;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.junit.Test;

public class DbfReadingTest {
    @Test
    public void testFirstCreateDbfDescriptionMap() throws URISyntaxException, IOException {
        File file = new File(this.getClass().getResource("test_legend_1.dbf").toURI());
        Map map = LegendFile.createDbfDescriptionMap((File)file);
        Assert.assertEquals((String)"Tropical Broadleaved Forest", (String)((String)map.get(1)));
        Assert.assertEquals((String)"Fragmented Tropical Broadleav", (String)((String)map.get(2)));
        Assert.assertEquals((String)"Mangroves", (String)((String)map.get(5)));
    }

    @Test
    public void testSecondCreateDbfDescriptionMap() throws URISyntaxException, IOException {
        File file = new File(this.getClass().getResource("test_legend_2.dbf").toURI());
        Map map = LegendFile.createDbfDescriptionMap((File)file);
        Assert.assertEquals((String)"Unclassified", (String)((String)map.get(0)));
        Assert.assertEquals((String)"Mosaic Forest / shrub cover", (String)((String)map.get(9)));
        Assert.assertEquals((String)"", (String)((String)map.get(11)));
        Assert.assertEquals((String)"Artificial surfaces", (String)((String)map.get(22)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLegend1() throws BiffException, IOException, URISyntaxException {
        FileChannel channel = new FileInputStream(new File(DbfReadingTest.class.getResource("test_legend_1.dbf").toURI())).getChannel();
        DbaseFileReader reader = new DbaseFileReader((ReadableByteChannel)channel, true, Charset.defaultCharset());
        DbaseFileHeader dbfHeader = reader.getHeader();
        int fieldCount = dbfHeader.getNumFields();
        Assert.assertEquals((int)5, (int)fieldCount);
        Assert.assertEquals(Integer.class, (Object)dbfHeader.getFieldClass(0));
        Assert.assertEquals(String.class, (Object)dbfHeader.getFieldClass(1));
        try {
            this.testRow(reader, 0, "No Data");
            this.testRow(reader, 1, "Tropical Broadleaved Forest");
            this.testRow(reader, 2, "Fragmented Tropical Broadleav");
            this.testRow(reader, 3, "Cultivated and Managed");
            this.testRow(reader, 4, "Water");
            this.testRow(reader, 5, "Mangroves");
        }
        finally {
            reader.close();
            channel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLegend2() throws BiffException, IOException, URISyntaxException {
        FileChannel channel = new FileInputStream(new File(DbfReadingTest.class.getResource("test_legend_2.dbf").toURI())).getChannel();
        DbaseFileReader reader = new DbaseFileReader((ReadableByteChannel)channel, true, Charset.defaultCharset());
        DbaseFileHeader dbfHeader = reader.getHeader();
        int fieldCount = dbfHeader.getNumFields();
        Assert.assertEquals((int)5, (int)fieldCount);
        Assert.assertEquals(Integer.class, (Object)dbfHeader.getFieldClass(0));
        Assert.assertEquals(String.class, (Object)dbfHeader.getFieldClass(1));
        try {
            this.testRow(reader, 0, "Unclassified");
            this.testRow(reader, 1, "Evergreen forest");
            this.testRow(reader, 2, "");
            this.testRow(reader, 3, "");
            this.testRow(reader, 4, "");
            this.testRow(reader, 5, "");
        }
        finally {
            reader.close();
            channel.close();
        }
    }

    private void testRow(DbaseFileReader reader, int value, String name) throws IOException {
        DbaseFileReader.Row row = reader.readRow();
        Object actual = row.read(0);
        Assert.assertEquals(Integer.class, actual.getClass());
        Assert.assertEquals((int)value, (int)((Integer)actual));
        Assert.assertEquals((String)name, (String)((String)row.read(1)));
    }
}

