/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.operators.tooladapter;

import com.bc.ceres.core.ProgressMonitor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.descriptor.SystemVariable;
import org.esa.snap.core.gpf.descriptor.TemplateParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolParameterDescriptor;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterConstants;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterOp;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterOpSpi;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterRegistry;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.runtime.Config;

public class ToolAdapterIO {
    private static final String[] userSubfolders;
    private static final Logger logger;
    private static final Map<String, String> shellExtensions;
    private static final String osFamily;
    private static final Attributes.Name typeKey;
    private static final String[] excludedClusters;

    public static void setAdaptersPath(Path path) {
        Preferences preferences = ToolAdapterIO.getPreferences();
        preferences.put("user.module.path", path.toFile().getAbsolutePath());
        try {
            preferences.sync();
        }
        catch (BackingStoreException e) {
            logger.severe("Cannot set adapters path in preferences: " + e.getMessage());
        }
    }

    public static void saveVariable(String name, String value) {
        if (value != null && value.length() > 0) {
            Preferences preferences = ToolAdapterIO.getPreferences();
            preferences.put(name, value);
            try {
                preferences.sync();
            }
            catch (BackingStoreException e) {
                logger.severe(String.format("Cannot set %s value in preferences: %s", name, e.getMessage()));
            }
        }
    }

    public static String getVariableValue(String name, String defaultValue, boolean isShared) {
        Preferences preferences = ToolAdapterIO.getPreferences();
        String retVal = preferences.get(name, null);
        if ((retVal == null || retVal.isEmpty()) && defaultValue != null) {
            if (isShared) {
                ToolAdapterIO.saveVariable(name, defaultValue);
            }
            retVal = defaultValue;
        }
        return retVal;
    }

    public static Collection<ToolAdapterOpSpi> searchAndRegisterAdapters() {
        Logger logger = Logger.getLogger(ToolAdapterOpSpi.class.getName());
        List<File> moduleFolders = null;
        try {
            ToolAdapterRegistry.INSTANCE.clear();
            moduleFolders = ToolAdapterIO.scanForAdapters();
        }
        catch (IOException e) {
            logger.severe("Failed scan for Tools descriptors: I/O problem: " + e.getMessage());
        }
        if (moduleFolders != null) {
            for (File moduleFolder : moduleFolders) {
                try {
                    ToolAdapterIO.registerAdapter(moduleFolder.toPath());
                }
                catch (Exception ex) {
                    logger.severe(String.format("Failed to register module %s. Problem: %s", moduleFolder.getName(), ex.getMessage()));
                }
            }
        }
        return Collections.unmodifiableCollection(ToolAdapterRegistry.INSTANCE.getOperatorMap().values());
    }

    public static ToolAdapterOpSpi createOperatorSpi(final Path operatorFolder) throws OperatorException {
        Path descriptorFile = operatorFolder.resolve(ToolAdapterConstants.DESCRIPTOR_FILE);
        if (Files.exists(descriptorFile, new LinkOption[0])) {
            ToolAdapterOperatorDescriptor operatorDescriptor = ToolAdapterOperatorDescriptor.fromXml(descriptorFile.toFile(), ToolAdapterIO.class.getClassLoader());
            return new ToolAdapterOpSpi(operatorDescriptor){

                public Operator createOperator() throws OperatorException {
                    ToolAdapterOp toolOperator = (ToolAdapterOp)super.createOperator();
                    toolOperator.setAdapterFolder(operatorFolder.toFile());
                    toolOperator.setParameterDefaultValues();
                    return toolOperator;
                }
            };
        }
        throw new OperatorException(String.format("Missing operator metadata file '%s'", descriptorFile));
    }

    public static void removeOperator(ToolAdapterOperatorDescriptor operator) {
        ToolAdapterIO.removeOperator(operator, true);
    }

    public static Path backupOperator(ToolAdapterOperatorDescriptor operatorDescriptor) throws IOException {
        Path root = ToolAdapterIO.getAdaptersPath();
        String alias = operatorDescriptor.getAlias();
        Path modulePath = root.resolve(alias);
        Path backupRoot = SystemUtils.getAuxDataPath();
        Path backupPath = backupRoot.resolve(alias + "_" + String.valueOf(System.currentTimeMillis()));
        ToolAdapterIO.copy(modulePath, backupPath);
        return backupPath;
    }

    public static Path restoreOperator(ToolAdapterOperatorDescriptor operatorDescriptor, Path backupPath) throws IOException {
        Path root = ToolAdapterIO.getAdaptersPath();
        String alias = operatorDescriptor.getAlias();
        Path modulePath = root.resolve(alias);
        ToolAdapterIO.copy(backupPath, modulePath);
        return modulePath;
    }

    public static void saveAndRegisterOperator(ToolAdapterOperatorDescriptor operator) throws IOException, URISyntaxException {
        Path rootFolder = ToolAdapterIO.getAdaptersPath();
        final Path moduleFolder = rootFolder.resolve(operator.getAlias());
        ToolAdapterIO.removeOperator(operator, true);
        Files.createDirectories(moduleFolder, new FileAttribute[0]);
        ToolAdapterOpSpi operatorSpi = new ToolAdapterOpSpi(operator){

            public Operator createOperator() throws OperatorException {
                ToolAdapterOp toolOperator = (ToolAdapterOp)super.createOperator();
                toolOperator.setAdapterFolder(moduleFolder.toFile());
                toolOperator.setParameterDefaultValues();
                return toolOperator;
            }
        };
        Path descriptorFile = moduleFolder.resolve(ToolAdapterConstants.DESCRIPTOR_FILE);
        Files.createDirectories(descriptorFile.getParent(), new FileAttribute[0]);
        String xmlContent = operator.toXml(ToolAdapterIO.class.getClassLoader());
        Files.write(descriptorFile, xmlContent.getBytes(), StandardOpenOption.CREATE);
        operator.getTemplate().save();
        operator.getToolParameterDescriptors().stream().filter(ToolParameterDescriptor::isTemplateParameter).map(p -> (TemplateParameterDescriptor)((Object)p)).forEach(p -> {
            try {
                p.getTemplate().save();
            }
            catch (IOException e) {
                logger.severe(String.format("Failed to save template for parameter %s [%s]", p.getName(), e.getMessage()));
            }
        });
        ToolAdapterRegistry.INSTANCE.registerOperator(operatorSpi);
    }

    public static ToolAdapterOpSpi registerAdapter(Path adapterFolder) throws OperatorException {
        ToolAdapterOpSpi operatorSpi = ToolAdapterIO.createOperatorSpi(adapterFolder);
        ToolAdapterRegistry.INSTANCE.registerOperator(operatorSpi);
        return operatorSpi;
    }

    public static ToolAdapterOpSpi registerAdapter(File adapterFolder) throws OperatorException {
        return ToolAdapterIO.registerAdapter(adapterFolder.toPath());
    }

    public static List<File> scanForAdapters() throws IOException {
        logger.info("Initializing external tool adapters");
        ArrayList<File> modules = new ArrayList<File>();
        Set<Path> modulesPath = ToolAdapterIO.getClusterModulesPaths();
        for (Path clusterPath : modulesPath) {
            Preferences preferences = Config.instance((String)clusterPath.getFileName().toString()).preferences();
            SystemVariable.addLookupReference(preferences::get);
        }
        modulesPath.add(ToolAdapterIO.getAdaptersPath());
        for (Path path : modulesPath) {
            logger.fine("Scanning for external tools adapters: " + path.toAbsolutePath().toString());
            try {
                modules.addAll(ToolAdapterIO.scanForAdapters(path));
            }
            catch (IOException ex) {
                logger.severe(String.format("Failed to scan %s [reason: %s]", path, ex.getMessage()));
            }
        }
        return modules;
    }

    public static Path getAdaptersPath() {
        Path userModulePath;
        String userPath = Config.instance().load().preferences().get("user.module.path", null);
        if (userPath == null) {
            userModulePath = SystemUtils.getAuxDataPath();
            for (String subFolder : userSubfolders) {
                userModulePath = userModulePath.resolve(subFolder);
            }
        } else {
            userModulePath = Paths.get(userPath, new String[0]);
        }
        try {
            Files.createDirectories(userModulePath, new FileAttribute[0]);
        }
        catch (IOException ex) {
            logger.severe(ex.getMessage());
        }
        if (!Files.exists(userModulePath, new LinkOption[0])) {
            logger.severe("Cannot create user folder for external tool adapter extensions");
        }
        return userModulePath;
    }

    public static File getUserAdapterPath() {
        return ToolAdapterIO.getAdaptersPath().toFile();
    }

    public static void saveFileContent(File file, String content) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            writer.write(content);
            writer.flush();
            writer.close();
        }
    }

    public static void removeOperator(ToolAdapterOperatorDescriptor operator, boolean removeOperatorFolder) {
        Path rootFolder;
        Path moduleFolder;
        ToolAdapterRegistry.INSTANCE.removeOperator(operator);
        if (removeOperatorFolder && Files.exists(moduleFolder = (rootFolder = ToolAdapterIO.getAdaptersPath()).resolve(operator.getAlias()), new LinkOption[0])) {
            try {
                ToolAdapterIO.deleteFolder(moduleFolder);
            }
            catch (IOException e) {
                logger.warning(String.format("Folder %s cannot be deleted [%s]", moduleFolder.toAbsolutePath(), e.getMessage()));
            }
        }
    }

    public static String getShellExtension() {
        return shellExtensions.get(osFamily);
    }

    public static String getOsFamily() {
        return osFamily;
    }

    public static void convertAdapter(Path modulePath) throws IOException {
        Path descriptorPath = Files.isRegularFile(modulePath, new LinkOption[0]) ? modulePath : modulePath.resolve("META-INF").resolve("descriptor.xml");
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("indent-number", 2);
            StreamSource xslStream = new StreamSource(ToolAdapterIO.class.getResourceAsStream("transform.xsl"));
            Transformer transformer = factory.newTransformer(xslStream);
            transformer.setOutputProperty("indent", "yes");
            StreamSource input = new StreamSource(new StringReader(new String(Files.readAllBytes(descriptorPath))));
            StringWriter writer = new StringWriter();
            StreamResult output = new StreamResult(writer);
            transformer.transform(input, output);
            Files.write(descriptorPath, writer.toString().getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static void deleteFolder(Path location) throws IOException {
        if (Files.exists(location, new LinkOption[0])) {
            Files.walkFileTree(location, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.deleteIfExists(dir);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.deleteIfExists(file);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static void fixPermissions(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            Stream<Path> files = Files.list(path);
            files.forEach(p -> {
                try {
                    ToolAdapterIO.fixPermissions(p);
                }
                catch (IOException e) {
                    SystemUtils.LOG.severe("OpenJPEG configuration error: failed to fix permissions on " + path);
                }
            });
        } else if (org.apache.commons.lang.SystemUtils.IS_OS_UNIX) {
            HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_EXECUTE));
            try {
                Files.setPosixFilePermissions(path, permissions);
            }
            catch (IOException e) {
                SystemUtils.LOG.severe("Can't set execution permissions for executable " + path.toString() + ". If required, please ask an authorised user to make the file executable.");
            }
        }
    }

    private static List<File> scanForAdapters(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
            throw new FileNotFoundException(path.toAbsolutePath().toString());
        }
        File[] jarFiles = path.toFile().listFiles(f -> f.getName().endsWith(".jar"));
        if (jarFiles != null) {
            for (File jarFile : jarFiles) {
                try {
                    ToolAdapterIO.unpackAdapterJar(jarFile, null);
                }
                catch (IOException ioEx) {
                    logger.warning(ioEx.getMessage());
                }
            }
        }
        File[] moduleFolders = path.toFile().listFiles();
        ArrayList<File> modules = new ArrayList<File>();
        if (moduleFolders != null) {
            for (File moduleFolder : moduleFolders) {
                File descriptorFile = new File(moduleFolder, ToolAdapterConstants.DESCRIPTOR_FILE);
                if (!descriptorFile.exists()) continue;
                modules.add(moduleFolder);
            }
        }
        return modules;
    }

    private static void unpackAdapterJar(File jarFile, File unpackFolder) throws IOException {
        JarFile jar = new JarFile(jarFile);
        Manifest manifest = jar.getManifest();
        Attributes manifestEntries = manifest.getMainAttributes();
        if (manifestEntries.containsKey(typeKey) && "STA".equals(manifestEntries.getValue(typeKey.toString()))) {
            Enumeration<JarEntry> enumEntries = jar.entries();
            if (unpackFolder == null) {
                unpackFolder = ToolAdapterIO.getAdaptersPath().resolve(jarFile.getName().replace(".jar", "")).toFile();
            }
            if (!unpackFolder.exists() && !unpackFolder.mkdir()) {
                logger.warning(String.format("Cannot create folder %s", unpackFolder.getAbsolutePath()));
            }
            while (enumEntries.hasMoreElements()) {
                JarEntry file = enumEntries.nextElement();
                File f = new File(unpackFolder, file.getName());
                if (file.isDirectory()) {
                    if (f.mkdir()) continue;
                    logger.warning(String.format("Cannot create folder %s", f.getAbsolutePath()));
                    continue;
                }
                if (!f.getParentFile().mkdirs()) {
                    logger.warning(String.format("Cannot create folder %s", f.getParentFile().getAbsolutePath()));
                }
                InputStream is = jar.getInputStream(file);
                Throwable throwable = null;
                try {
                    try (FileOutputStream fos = new FileOutputStream(f);){
                        while (is.available() > 0) {
                            fos.write(is.read());
                        }
                        fos.close();
                    }
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
    }

    private static Preferences getPreferences() {
        Config instance = Config.instance();
        Path storagePath = instance.storagePath();
        File file = storagePath.toFile();
        if (!file.exists()) {
            try {
                if (!file.getParentFile().mkdirs() || !file.createNewFile()) {
                    logger.warning("Cannot create module preferences");
                }
            }
            catch (IOException e) {
                logger.severe("Error while creating module preferences: " + e.getMessage());
            }
        }
        try {
            instance = Config.instance().load();
        }
        catch (Exception e) {
            logger.severe("Cannot read preferences: " + e.getMessage());
        }
        return instance.preferences();
    }

    public static void copy(final Path source, final Path destination) throws IOException {
        EnumSet<FileVisitOption> options = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        final CopyOption[] copyOptions = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING};
        Files.walkFileTree(source, options, 3, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path newDirectory = destination.resolve(source.relativize(dir));
                try {
                    Files.copy(dir, newDirectory, copyOptions);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                }
                catch (IOException x) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, destination.resolve(source.relativize(file)), copyOptions);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static Path zip(Path source, Path zipFile) throws IOException {
        if (source == null || zipFile == null) {
            throw new IllegalArgumentException("One of the arguments is null");
        }
        Files.deleteIfExists(zipFile);
        zipFile = Files.createFile(zipFile, new FileAttribute[0]);
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(zipFile, new OpenOption[0]));){
            if (Files.isRegularFile(source, new LinkOption[0])) {
                ZipEntry zipEntry = new ZipEntry(source.getFileName().toString());
                zos.putNextEntry(zipEntry);
                zos.write(Files.readAllBytes(source));
                zos.closeEntry();
            } else {
                Files.walk(source, 3, new FileVisitOption[0]).forEach(path -> {
                    try {
                        if (Files.isDirectory(path, new LinkOption[0])) {
                            ToolAdapterIO.zipFolder(source, path, zos);
                        } else {
                            ZipEntry zipEntry = new ZipEntry(source.relativize((Path)path).toString());
                            zos.putNextEntry(zipEntry);
                            zos.write(Files.readAllBytes(path));
                            zos.closeEntry();
                        }
                    }
                    catch (Exception ex) {
                        SystemUtils.LOG.warning(ex.getMessage());
                    }
                });
            }
        }
        return zipFile;
    }

    private static void zipFolder(Path root, Path folder, ZipOutputStream zipStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry(root.relativize(folder).toString() + "/");
        zipStream.putNextEntry(zipEntry);
        zipStream.closeEntry();
    }

    public static void unzip(Path sourceFile, Path destination, ProgressMonitor progressMonitor, int totalTasks) throws IOException {
        if (sourceFile == null || destination == null) {
            throw new IllegalArgumentException("One of the arguments is null");
        }
        if (!Files.exists(destination, new LinkOption[0])) {
            Files.createDirectory(destination, new FileAttribute[0]);
        }
        try (ZipFile zipFile = new ZipFile(sourceFile.toFile());){
            ZipEntry entry;
            progressMonitor.setSubTaskName(String.format("Extracting %s...", zipFile.getName()));
            int size = zipFile.size();
            int workUnits = 100 / totalTasks;
            int count = 0;
            LinkedHashMap<String, String> fileNames = new LinkedHashMap<String, String>();
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                fileNames.put(entry.getName(), entry.getName());
            }
            String firstEntry = (String)fileNames.values().iterator().next();
            String token = firstEntry.substring(0, firstEntry.indexOf("/"));
            if (fileNames.values().stream().allMatch(n -> n.startsWith(token))) {
                fileNames.values().forEach(n -> {
                    n = n.substring(n.indexOf("/") + 1);
                });
            }
            entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                Path filePath = destination.resolve((String)fileNames.get(entry.getName()));
                if (!Files.exists(filePath, new LinkOption[0])) {
                    if (entry.isDirectory()) {
                        Files.createDirectories(filePath, new FileAttribute[0]);
                    } else {
                        try (InputStream inputStream = zipFile.getInputStream(entry);
                             BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath.toFile()));){
                            int read;
                            byte[] buffer = new byte[4096];
                            while ((read = inputStream.read(buffer)) > 0) {
                                bos.write(buffer, 0, read);
                            }
                        }
                    }
                }
                int progress = 100 - workUnits + (int)((double)count++ / (double)size * (double)workUnits);
                progressMonitor.worked(progress);
            }
        }
    }

    static List<ProductReaderPlugIn> getReaderPlugInsByExtension(String extension) {
        ArrayList<ProductReaderPlugIn> plugIns = new ArrayList<ProductReaderPlugIn>();
        Iterator readerPlugIns = ProductIOPlugInManager.getInstance().getAllReaderPlugIns();
        while (readerPlugIns.hasNext()) {
            ProductReaderPlugIn plugIn = (ProductReaderPlugIn)readerPlugIns.next();
            if (Arrays.stream(plugIn.getDefaultFileExtensions()).filter(e -> e.equalsIgnoreCase(extension)).count() <= 0L) continue;
            plugIns.add(plugIn);
        }
        return plugIns;
    }

    private static Set<Path> getClusterModulesPaths() {
        HashSet<Path> clusterNames = new HashSet();
        Path installDir = Config.instance().installDir();
        Path clustersFile = installDir.resolve("etc").resolve("snap.clusters");
        if (Files.isRegularFile(clustersFile, new LinkOption[0])) {
            try {
                clusterNames = Files.readAllLines(clustersFile).stream().filter(name -> !name.trim().isEmpty()).map(installDir::resolve).collect(Collectors.toSet());
            }
            catch (IOException e) {
                logger.severe(String.format("Failed to load clusters file from '%s'", clustersFile));
            }
        }
        for (String clusterName : excludedClusters) {
            clusterNames.remove(installDir.resolve(clusterName));
        }
        clusterNames.remove(installDir.resolve("snap"));
        return clusterNames;
    }

    static {
        logger = Logger.getLogger(ToolAdapterIO.class.getName());
        userSubfolders = new String[]{"tool-adapters"};
        shellExtensions = new HashMap<String, String>();
        shellExtensions.put("windows", ".bat");
        shellExtensions.put("linux", ".sh");
        shellExtensions.put("macosx", ".sh");
        shellExtensions.put("unsupported", "");
        String sysName = System.getProperty("os.name").toLowerCase();
        osFamily = sysName.contains("windows") ? "windows" : (sysName.contains("linux") ? "linux" : (sysName.contains("mac") ? "macosx" : "unsupported"));
        typeKey = new Attributes.Name("OpenIDE-Module-Type");
        excludedClusters = new String[]{"bin", "etc", "platform", "ide", "java"};
    }
}

