/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.operators.tooladapter;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.esa.snap.core.gpf.operators.tooladapter.ProcessOutputConsumer;

public class ProcessExecutor {
    private volatile boolean isStopped;
    private List<String>[] arguments;
    private File workingDirectory;
    private ProcessOutputConsumer consumer;
    private Logger logger = Logger.getLogger(ProcessExecutor.class.getName());

    public void setConsumer(ProcessOutputConsumer consumer) {
        this.consumer = consumer;
        if (consumer != null) {
            this.consumer.setLogger(this.logger);
        }
    }

    public void setWorkingDirectory(File directory) {
        this.workingDirectory = directory;
    }

    public int execute(List<String> arguments) throws IOException {
        return this.execute(arguments, System.getenv());
    }

    public int execute(List<String> arguments, Map<String, String> envVars) throws IOException {
        return this.execute(arguments, envVars, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(List<String> arguments, Map<String, String> envVars, File workingDirectory) throws IOException {
        int ret;
        block14: {
            BufferedReader outReader;
            Process process;
            block15: {
                process = null;
                outReader = null;
                ret = -1;
                try {
                    ProcessBuilder pb = new ProcessBuilder(arguments);
                    pb.redirectErrorStream(true);
                    if (workingDirectory != null) {
                        pb.directory(workingDirectory);
                    }
                    if (envVars != null) {
                        pb.environment().putAll(envVars);
                    }
                    process = pb.start();
                    outReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while (!this.isStopped()) {
                        while (!this.isStopped && outReader.ready()) {
                            String line = outReader.readLine();
                            if (line == null || "".equals(line.trim())) continue;
                            this.consumer.consumeOutput(line);
                        }
                        if (!process.isAlive()) {
                            this.stop();
                            continue;
                        }
                        Thread.yield();
                    }
                    while (process.isAlive()) {
                        Thread.yield();
                    }
                    ret = process.exitValue();
                    if (process == null) break block14;
                    if (!process.isAlive()) break block15;
                    process.destroyForcibly();
                }
                catch (Throwable throwable) {
                    if (process != null) {
                        if (process.isAlive()) {
                            process.destroyForcibly();
                        }
                        try {
                            ret = process.waitFor();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.closeStream(outReader);
                        this.closeStream(process.getErrorStream());
                        this.closeStream(process.getInputStream());
                        this.closeStream(process.getOutputStream());
                    }
                    throw throwable;
                }
            }
            try {
                ret = process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.closeStream(outReader);
            this.closeStream(process.getErrorStream());
            this.closeStream(process.getInputStream());
            this.closeStream(process.getOutputStream());
        }
        return ret;
    }

    public void stop() {
        this.isStopped = true;
    }

    private void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean isStopped() {
        return this.isStopped;
    }
}

