/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.descriptor;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.gpf.descriptor.OSFamily;
import org.esa.snap.core.gpf.descriptor.SystemVariable;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterIO;

@XStreamAlias(value="osvariable")
public class SystemDependentVariable
extends SystemVariable {
    @XStreamOmitField
    private volatile Map<OSFamily, String> values;
    @XStreamOmitField
    private OSFamily currentOS;
    private String windows;
    private String linux;
    private String macosx;
    private boolean isTransient;

    private SystemDependentVariable(String key, String value, Map<OSFamily, String> values, OSFamily currentOS, String windows, String linux, String macosx, boolean isTransient) {
        super(key, value);
        this.currentOS = currentOS;
        this.windows = windows;
        this.linux = linux;
        this.macosx = macosx;
        this.isTransient = isTransient;
        if (values == null) {
            this.initialize();
        } else {
            this.values = new HashMap<OSFamily, String>();
            this.values.putAll(values);
        }
    }

    public SystemDependentVariable(String key, String value) {
        super(key, value);
        this.initialize();
        this.setValue(value);
        this.isTransient = false;
    }

    @Override
    public String getValue() {
        if (this.values == null) {
            this.initialize();
        }
        this.value = this.getCurrentOSValue();
        String retVal = this.resolve();
        return retVal != null && !retVal.isEmpty() ? retVal : (String)this.values.getOrDefault((Object)this.currentOS, null);
    }

    @Override
    public void setValue(String value) {
        this.values.put(this.currentOS, value);
        this.value = value;
        if (!this.isTransient && value != null && !value.isEmpty() && this.isShared) {
            ToolAdapterIO.saveVariable(this.key, value);
        }
    }

    @Override
    public SystemVariable createCopy() {
        return new SystemDependentVariable(this.key, this.value, this.values, this.currentOS, this.windows, this.linux, this.macosx, this.isTransient);
    }

    public String getWindows() {
        return this.windows == null ? this.values.get((Object)OSFamily.windows) : this.windows;
    }

    public void setWindows(String value) {
        this.windows = value;
        if (this.currentOS == OSFamily.windows) {
            this.setValue(value);
        }
    }

    public String getLinux() {
        return this.linux == null ? this.values.get((Object)OSFamily.linux) : this.linux;
    }

    public void setLinux(String value) {
        this.linux = value;
        if (this.currentOS == OSFamily.linux) {
            this.setValue(value);
        }
    }

    public String getMacosx() {
        return this.macosx == null ? this.values.get((Object)OSFamily.macosx) : this.macosx;
    }

    public void setMacosx(String value) {
        this.macosx = value;
        if (this.currentOS == OSFamily.macosx) {
            this.setValue(value);
        }
    }

    public void setTransient(boolean value) {
        this.isTransient = value;
    }

    public String getCurrentOSValue() {
        return this.values.get((Object)this.currentOS);
    }

    private void initialize() {
        this.values = new HashMap<OSFamily, String>();
        this.values.put(OSFamily.windows, this.windows == null ? "" : this.windows);
        this.values.put(OSFamily.linux, this.linux == null ? "" : this.linux);
        this.values.put(OSFamily.macosx, this.macosx == null ? "" : this.macosx);
        this.values.put(OSFamily.unsupported, "");
        try {
            this.currentOS = Enum.valueOf(OSFamily.class, ToolAdapterIO.getOsFamily());
        }
        catch (IllegalArgumentException ignored) {
            this.currentOS = OSFamily.unsupported;
        }
    }
}

