/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.extensions;

import com.bc.ceres.core.ProgressMonitor;
import java.util.Calendar;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.esa.snap.engine_utilities.db.DBQuery;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.engine_utilities.download.opensearch.CopernicusProductQuery;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.productlibrary.rcp.dialogs.JointSearchDialog;
import org.esa.snap.productlibrary.rcp.toolviews.ProductLibraryActions;
import org.esa.snap.productlibrary.rcp.toolviews.ProductLibraryToolView;
import org.esa.snap.productlibrary.rcp.toolviews.extensions.ProductLibraryActionExt;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.UIUtils;

public class JointSearchActionExt
implements ProductLibraryActionExt {
    private static final ImageIcon jointSearchIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/productlibrary/icons/joint_search.png", ProductLibraryToolView.class);
    private JButton button = null;
    private ProductLibraryActions actionHandler;

    @Override
    public void setActionHandler(ProductLibraryActions actionHandler) {
        this.actionHandler = actionHandler;
    }

    @Override
    public JButton getButton(JPanel panel) {
        if (this.button == null) {
            this.button = DialogUtils.createButton((String)"jointSearchButton", (String)"Joint Search", (ImageIcon)jointSearchIcon, (JPanel)panel, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        }
        return this.button;
    }

    @Override
    public void selectionChanged(ProductEntry[] selections) {
        this.button.setEnabled(selections.length == 1 && ProductLibraryActions.allProductsExist(selections));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performAction(ProgressMonitor pm) {
        ProductEntry[] selections = this.actionHandler.getSelectedProductEntries();
        JointSearchDialog dlg = new JointSearchDialog("Joint Search Criteria", selections[0].getMission());
        dlg.show();
        if (!dlg.IsOK()) {
            return;
        }
        DBQuery dbQuery = new DBQuery();
        dbQuery.setSelectionRect(selections[0].getGeoBoundary());
        dbQuery.setSelectedMissions(dlg.getMissions());
        int daysMinus = dlg.getDaysMinus();
        int daysPlus = dlg.getDaysPlus();
        if (daysMinus < 0 || daysPlus < 0) {
            Dialogs.showError((String)"Joint search: invalid number of days\n (must be 0 or +ve integer)");
            return;
        }
        Calendar startDate = selections[0].getFirstLineTime().getAsCalendar();
        startDate.add(5, -daysMinus);
        Calendar endDate = selections[0].getFirstLineTime().getAsCalendar();
        endDate.add(5, daysPlus);
        dbQuery.setStartEndDate(startDate, endDate);
        dbQuery.setSelectedCloudCover(dlg.getCloudCover());
        dbQuery.setSelectedAcquisitionMode(dlg.getAcquisitionMode());
        dbQuery.setSelectedProductTypes(dlg.getProductTypes());
        CopernicusProductQuery productQueryInterface = CopernicusProductQuery.instance();
        try {
            productQueryInterface.fullQuery(dbQuery, pm);
            if (!pm.isCanceled()) {
                this.actionHandler.getToolView().setSelectedRepositoryToSciHub();
            }
        }
        catch (Exception e) {
            Dialogs.showError((String)("unable to do joint search: " + e.getMessage()));
        }
        finally {
            pm.done();
        }
    }
}

