/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.graphbuilder.rcp.progress.LabelBarProgressMonitor;
import org.esa.snap.graphbuilder.rcp.utils.ClipboardUtils;
import org.esa.snap.productlibrary.rcp.toolviews.DBWorker;
import org.esa.snap.productlibrary.rcp.toolviews.ProductFileHandler;
import org.esa.snap.productlibrary.rcp.toolviews.ProductLibraryToolView;
import org.esa.snap.productlibrary.rcp.toolviews.extensions.ProductLibraryActionExt;
import org.esa.snap.productlibrary.rcp.toolviews.extensions.ProductLibraryActionExtDescriptor;
import org.esa.snap.productlibrary.rcp.toolviews.extensions.ProductLibraryActionExtRegistry;
import org.esa.snap.productlibrary.rcp.toolviews.support.SortingDecorator;
import org.esa.snap.productlibrary.rcp.utils.ProductOpener;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.SnapFileChooser;

public class ProductLibraryActions {
    private final ProductLibraryToolView toolView;
    private List<ProductLibraryActionExt> actionExtList = new ArrayList<ProductLibraryActionExt>();
    private JMenuItem copyToItem;
    private JMenuItem moveToItem;
    private JMenuItem deleteItem;
    private File currentDirectory;

    public ProductLibraryActions(ProductLibraryToolView toolView) {
        this.toolView = toolView;
    }

    public ProductLibraryToolView getToolView() {
        return this.toolView;
    }

    JPanel createCommandPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        for (ProductLibraryActionExtDescriptor desc : ProductLibraryActionExtRegistry.getInstance().getDescriptors()) {
            if (desc.isSeperator()) {
                panel.add(Box.createRigidArea(new Dimension(24, 24)));
                continue;
            }
            final ProductLibraryActionExt action = desc.createActionExt(this);
            this.actionExtList.add(action);
            JButton button = action.getButton(panel);
            panel.add(button);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DBWorker worker = new DBWorker(DBWorker.TYPE.EXECUTEACTION, action, (ProgressMonitor)ProductLibraryActions.this.toolView.getLabelBarProgressMonitor());
                    worker.addListener(ProductLibraryActions.this.toolView.createDBListener());
                    worker.execute();
                }
            });
        }
        return panel;
    }

    void selectionChanged(ProductEntry[] selections) {
        for (ProductLibraryActionExt action : this.actionExtList) {
            action.selectionChanged(selections);
        }
    }

    public static boolean allProductsExist(ProductEntry[] selections) {
        boolean allProductsExits = true;
        for (ProductEntry entry : selections) {
            if (entry.getFile() != null && entry.getFile().exists()) continue;
            allProductsExits = false;
            break;
        }
        return allProductsExits;
    }

    private void performCopyAction() {
        File[] fileList = this.toolView.getSelectedFiles();
        if (fileList.length != 0) {
            ClipboardUtils.copyToClipboard((File[])fileList);
        }
    }

    private void performFileAction(ProductFileHandler.TYPE operationType) {
        File targetFolder;
        if (operationType.equals((Object)ProductFileHandler.TYPE.DELETE)) {
            targetFolder = null;
        } else {
            targetFolder = this.promptForRepositoryBaseDir();
            if (targetFolder == null) {
                return;
            }
        }
        ProductEntry[] entries = this.toolView.getSelectedProductEntries();
        LabelBarProgressMonitor progMon = this.toolView.getLabelBarProgressMonitor();
        ProductFileHandler fileHandler = new ProductFileHandler(entries, operationType, targetFolder, (ProgressMonitor)progMon);
        fileHandler.addListener(this.toolView.createProductFileHandlerListener());
        fileHandler.execute();
    }

    public File[] getSelectedFiles() {
        return this.toolView.getSelectedFiles();
    }

    public ProductEntry[] getSelectedProductEntries() {
        return this.toolView.getSelectedProductEntries();
    }

    public void performOpenAction() {
        ProductOpener.openProducts(this.getSelectedFiles());
    }

    File promptForRepositoryBaseDir() {
        JFileChooser fileChooser = ProductLibraryActions.createDirectoryChooser();
        fileChooser.setCurrentDirectory(this.currentDirectory);
        int response = fileChooser.showOpenDialog(SnapApp.getDefault().getMainFrame());
        this.currentDirectory = fileChooser.getCurrentDirectory();
        File selectedDir = fileChooser.getSelectedFile();
        if (selectedDir != null && selectedDir.isFile()) {
            selectedDir = selectedDir.getParentFile();
        }
        if (response == 0) {
            return selectedDir;
        }
        return null;
    }

    private static JFileChooser createDirectoryChooser() {
        SnapFileChooser fileChooser = new SnapFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Directories";
            }
        });
        fileChooser.setDialogTitle("Select Directory");
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(1);
        fileChooser.setApproveButtonText("Select");
        fileChooser.setApproveButtonMnemonic('S');
        return fileChooser;
    }

    public JPopupMenu createEntryTablePopup() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem selectAllItem = new JMenuItem("Select All");
        selectAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.toolView.selectAll();
            }
        });
        popup.add(selectAllItem);
        JMenuItem selectNoneItem = new JMenuItem("Select None");
        selectNoneItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.toolView.selectNone();
            }
        });
        popup.add(selectNoneItem);
        JMenuItem openSelectedItem = new JMenuItem("Open Selected");
        openSelectedItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.performOpenAction();
            }
        });
        popup.add(openSelectedItem);
        JMenuItem copySelectedItem = new JMenuItem("Copy Selected");
        copySelectedItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.performCopyAction();
            }
        });
        popup.add(copySelectedItem);
        popup.addSeparator();
        this.copyToItem = new JMenuItem("Copy Selected Files To...");
        this.copyToItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.performFileAction(ProductFileHandler.TYPE.COPY_TO);
            }
        });
        popup.add(this.copyToItem);
        this.moveToItem = new JMenuItem("Move Selected Files To...");
        this.moveToItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.performFileAction(ProductFileHandler.TYPE.MOVE_TO);
            }
        });
        popup.add(this.moveToItem);
        this.deleteItem = new JMenuItem("Delete Selected Files");
        this.deleteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dialogs.Answer status = Dialogs.requestDecision((String)"Deleting selected files", (String)"Are you sure you want to delete these products", (boolean)true, null);
                if (status == Dialogs.Answer.YES) {
                    ProductLibraryActions.this.performFileAction(ProductFileHandler.TYPE.DELETE);
                }
            }
        });
        popup.add(this.deleteItem);
        JMenuItem exploreItem = new JMenuItem("Browse Folder");
        exploreItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductEntry prodEntry;
                ProductEntry entry = ProductLibraryActions.this.toolView.getEntryOverMouse();
                if (entry != null && entry instanceof ProductEntry && (prodEntry = entry).getFile() != null) {
                    try {
                        Desktop.getDesktop().open(prodEntry.getFile().getParentFile());
                    }
                    catch (Exception ex) {
                        SystemUtils.LOG.severe(ex.getMessage());
                    }
                }
            }
        });
        popup.add(exploreItem);
        popup.addSeparator();
        JMenu sortMenu = new JMenu("Sort By");
        popup.add(sortMenu);
        sortMenu.add(this.createSortItem("Product Name", SortingDecorator.SORT_BY.NAME));
        sortMenu.add(this.createSortItem("Product Type", SortingDecorator.SORT_BY.TYPE));
        sortMenu.add(this.createSortItem("Acquisition Date", SortingDecorator.SORT_BY.DATE));
        sortMenu.add(this.createSortItem("Mission", SortingDecorator.SORT_BY.MISSON));
        sortMenu.add(this.createSortItem("File Size", SortingDecorator.SORT_BY.FILESIZE));
        return popup;
    }

    private JMenuItem createSortItem(String name, final SortingDecorator.SORT_BY sortBy) {
        JMenuItem item = new JMenuItem(name);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.toolView.sort(sortBy);
            }
        });
        return item;
    }

    void updateContextMenu(ProductEntry[] selections) {
        boolean allValid = true;
        for (ProductEntry entry : selections) {
            if (ProductFileHandler.canMove(entry)) continue;
            allValid = false;
            break;
        }
        this.copyToItem.setEnabled(allValid);
        this.moveToItem.setEnabled(allValid);
        this.deleteItem.setEnabled(allValid);
    }
}

