/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.SwingWorker;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.downloadable.StatusProgressMonitor;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.db.ProductDB;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.engine_utilities.gpf.CommonReaders;
import org.esa.snap.engine_utilities.gpf.ThreadManager;
import org.esa.snap.engine_utilities.util.ProductFunctions;
import org.esa.snap.engine_utilities.util.ZipUtils;

public final class DBScanner
extends SwingWorker {
    private final ProductDB db;
    private final File baseDir;
    private final Options options;
    private final ProgressMonitor pm;
    private final List<DBScannerListener> listenerList = new ArrayList<DBScannerListener>(1);
    private final List<ErrorFile> errorList = new ArrayList<ErrorFile>();

    public DBScanner(ProductDB database, File baseDir, Options options, ProgressMonitor pm) {
        this.db = database;
        this.pm = pm;
        this.baseDir = baseDir;
        this.options = options;
    }

    public void addListener(DBScannerListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public void removeListener(DBScannerListener listener) {
        this.listenerList.remove(listener);
    }

    private void notifyMSG(DBScannerListener.MSG msg) {
        for (DBScannerListener listener : this.listenerList) {
            listener.notifyMSG(this, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean doInBackground() throws Exception {
        this.errorList.clear();
        ArrayList<File> dirList = new ArrayList<File>(20);
        dirList.add(this.baseDir);
        if (this.options.doRecursive) {
            File[] subDirs = DBScanner.collectAllSubDirs(this.baseDir, 0, this.pm);
            dirList.addAll(Arrays.asList(subDirs));
        }
        ProductFunctions.ValidProductFileFilter fileFilter = new ProductFunctions.ValidProductFileFilter(false);
        ArrayList<File> fileList = new ArrayList<File>(dirList.size());
        for (File file : dirList) {
            File[] files = file.listFiles((FileFilter)fileFilter);
            if (files != null) {
                fileList.addAll(Arrays.asList(files));
            }
            this.pm.setTaskName("Collecting " + fileList.size() + " files...");
        }
        ArrayList<Product> qlProducts = new ArrayList<Product>(fileList.size());
        ProductEntry[] entriesInPath = this.db.getProductEntryInPath(this.baseDir);
        ConcurrentHashMap<File, ProductEntry> fileMap = new ConcurrentHashMap<File, ProductEntry>(entriesInPath.length);
        for (ProductEntry entry : entriesInPath) {
            fileMap.put(entry.getFile(), entry);
        }
        int total = fileList.size();
        this.pm.beginTask("Scanning Files...", total);
        int i = 0;
        int prodCount = 0;
        try {
            for (File file : fileList) {
                Product sourceProduct;
                String taskMsg = "Scanning " + ++i + " of " + total + " files ";
                if (prodCount > 0) {
                    taskMsg = taskMsg + "(" + prodCount + " new products)";
                }
                this.pm.setTaskName(taskMsg);
                this.pm.worked(1);
                if (this.pm.isCanceled()) break;
                if (this.options.validateZips && ZipUtils.isZip((File)file) && !ZipUtils.isValid((File)file)) {
                    this.errorList.add(new ErrorFile(file, "Corrupt zip file"));
                    continue;
                }
                ProductEntry existingEntry = (ProductEntry)fileMap.get(file);
                if (existingEntry != null) {
                    if (this.options.generateQuicklooks && !existingEntry.quickLookExists() && (sourceProduct = CommonReaders.readProduct((File)file)) != null) {
                        qlProducts.add(sourceProduct);
                    }
                    existingEntry.dispose();
                    continue;
                }
                try {
                    sourceProduct = CommonReaders.readProduct((File)file);
                    if (sourceProduct != null) {
                        ProductEntry entry = this.db.saveProduct(sourceProduct);
                        ++prodCount;
                        if (!sourceProduct.getDefaultQuicklook().hasCachedImage()) {
                            qlProducts.add(sourceProduct);
                        } else {
                            sourceProduct.dispose();
                        }
                        entry.dispose();
                        continue;
                    }
                    if (file.isDirectory()) continue;
                    SystemUtils.LOG.warning("No reader for " + file.getAbsolutePath());
                }
                catch (Throwable e) {
                    this.errorList.add(new ErrorFile(file, "Product unreadable"));
                    SystemUtils.LOG.warning("Unable to read " + file.getAbsolutePath() + '\n' + e.getMessage());
                }
            }
            this.db.cleanUpRemovedProducts(this.pm);
            this.notifyMSG(DBScannerListener.MSG.FOLDERS_SCANNED);
            if (this.options.generateQuicklooks) {
                int numQL = qlProducts.size();
                this.pm.beginTask("Generating Quicklooks...", numQL);
                ThreadManager threadManager = new ThreadManager();
                threadManager.setNumConsecutiveThreads(Math.min(threadManager.getNumConsecutiveThreads(), 4));
                for (int j = 0; j < numQL; ++j) {
                    this.pm.setTaskName("Generating Quicklook... " + (j + 1) + " of " + numQL);
                    this.pm.worked(1);
                    if (this.pm.isCanceled()) break;
                    final Product product = (Product)qlProducts.get(j);
                    final StatusProgressMonitor qlPM = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
                    qlPM.beginTask("Creating quicklook " + product.getName() + "... ", 100);
                    Thread worker = new Thread(){

                        @Override
                        public void run() {
                            try {
                                product.getDefaultQuicklook().getImage((ProgressMonitor)qlPM);
                            }
                            catch (Throwable e) {
                                SystemUtils.LOG.warning("Unable to create quicklook for " + product.getName() + '\n' + e.getMessage());
                            }
                            finally {
                                product.dispose();
                                qlPM.done();
                            }
                        }
                    };
                    threadManager.add(worker);
                    this.notifyMSG(DBScannerListener.MSG.QUICK_LOOK_GENERATED);
                }
                threadManager.finish();
            }
            this.pm.setTaskName("");
        }
        catch (Throwable e) {
            SystemUtils.LOG.severe("Scanning Exception\n" + e.getMessage());
        }
        finally {
            this.pm.done();
        }
        return true;
    }

    @Override
    public void done() {
        this.notifyMSG(DBScannerListener.MSG.DONE);
    }

    private static File[] collectAllSubDirs(File dir, int count, ProgressMonitor pm) {
        ArrayList<File> dirList = new ArrayList<File>(20);
        ProductFunctions.DirectoryFileFilter dirFilter = new ProductFunctions.DirectoryFileFilter();
        File[] subDirs = dir.listFiles((FileFilter)dirFilter);
        if (subDirs != null) {
            pm.setTaskName("Collecting " + (count += subDirs.length) + " folders...");
            for (File subDir : subDirs) {
                dirList.add(subDir);
                File[] dirs = DBScanner.collectAllSubDirs(subDir, count, pm);
                dirList.addAll(Arrays.asList(dirs));
            }
        }
        return dirList.toArray(new File[dirList.size()]);
    }

    public List<ErrorFile> getErrorList() {
        return this.errorList;
    }

    public static interface DBScannerListener {
        public void notifyMSG(DBScanner var1, MSG var2);

        public static enum MSG {
            DONE,
            FOLDERS_SCANNED,
            QUICK_LOOK_GENERATED;

        }
    }

    public static class Options {
        private final boolean doRecursive;
        private final boolean validateZips;
        private final boolean generateQuicklooks;

        public Options(boolean doRecursive, boolean validateZips, boolean generateQuicklooks) {
            this.doRecursive = doRecursive;
            this.validateZips = validateZips;
            this.generateQuicklooks = generateQuicklooks;
        }
    }

    public static class ErrorFile {
        public final File file;
        public final String message;
        public static final String CORRUPT_ZIP = "Corrupt zip file";
        public static final String CORRUPT_IMAGE = "Corrupt Image";
        public static final String UNREADABLE = "Product unreadable";

        public ErrorFile(File file, String msg) {
            this.file = file;
            this.message = msg;
        }
    }
}

