/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.esa.snap.core.util.SystemUtils;

public class DirectoryWatch {
    private final List<File> directoryList = new ArrayList<File>();
    private final List<FileContainer> watchedFiles = new ArrayList<FileContainer>();
    private final List<File> directoriesContent = new ArrayList<File>();
    private final List<DirectoryWatchListener> listeners = new ArrayList<DirectoryWatchListener>();
    private final List<File> addedFileList = new ArrayList<File>();
    private final List<File> removedFileList = new ArrayList<File>();
    private Timer timer;

    public synchronized void add(File dir) {
        if (dir != null) {
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException("The argument: " + dir.getPath() + " is not a directory");
            }
            if (this.getDirectoryIndex(dir) < 0) {
                this.directoryList.add(dir);
            }
        }
    }

    private synchronized void remove(File dir) {
        int index = this.getDirectoryIndex(dir);
        if (index >= 0) {
            File file;
            this.directoryList.remove(index);
            ArrayList<File> toDelete = new ArrayList<File>();
            for (File aDirectoriesContent : this.directoriesContent) {
                file = aDirectoriesContent;
                if (!dir.equals(file.getParentFile())) continue;
                toDelete.add(file);
            }
            Iterator<File> iterator = toDelete.iterator();
            while (iterator.hasNext()) {
                File aToDelete;
                file = aToDelete = iterator.next();
                this.directoriesContent.remove(file);
            }
        }
    }

    public synchronized void removeAll() {
        while (!this.directoryList.isEmpty()) {
            this.remove(this.directoryList.get(0));
        }
    }

    public synchronized void addListener(DirectoryWatchListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void start(long rate) {
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)new DirectoryWatchTask(), 0L, rate);
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private synchronized void checkDirectories() {
        this.addNewFilesToWatch();
        this.checkForFileChanges();
        this.checkForRemovedFiles();
        this.notifyListeners();
    }

    private int getDirectoryIndex(File dir) {
        return this.directoryList.indexOf(dir);
    }

    private void checkForRemovedFiles() {
        File file;
        this.removedFileList.clear();
        for (File aDirectoriesContent : this.directoriesContent) {
            file = aDirectoriesContent;
            if (file.exists()) continue;
            this.removedFileList.add(file);
        }
        Iterator<File> iterator = this.removedFileList.iterator();
        while (iterator.hasNext()) {
            File aRemovedFileList;
            file = aRemovedFileList = iterator.next();
            this.directoriesContent.remove(file);
        }
    }

    private void checkForFileChanges() {
        File file;
        ArrayList<File> stableFiles = new ArrayList<File>();
        this.addedFileList.clear();
        Iterator<FileContainer> iterator = this.watchedFiles.iterator();
        while (iterator.hasNext()) {
            FileContainer watchedFile;
            FileContainer fileContainer = watchedFile = iterator.next();
            file = fileContainer.getFile();
            long length = file.length();
            long lastModified = file.lastModified();
            if (fileContainer.getLastModified() == lastModified && fileContainer.getSize() == length) {
                fileContainer.setStableCount(1 + fileContainer.getStableCount());
                if (fileContainer.getStableCount() <= 2) continue;
                stableFiles.add(file);
                continue;
            }
            fileContainer.setLastModified(lastModified);
            fileContainer.setSize(length);
            fileContainer.setStableCount(0);
        }
        FileContainer comparer = new FileContainer();
        for (Object e : stableFiles) {
            file = (File)e;
            this.addedFileList.add(file);
            this.directoriesContent.add(file);
            SystemUtils.LOG.fine(file.getName() + " added to dirContents");
            comparer.setFile(file);
            this.watchedFiles.remove(comparer);
        }
    }

    private void notifyListeners() {
        DirectoryWatchListener listener;
        DirectoryWatchListener listener1;
        Iterator<DirectoryWatchListener> iterator;
        if (!this.addedFileList.isEmpty()) {
            File[] added = new File[this.addedFileList.size()];
            added = this.addedFileList.toArray(added);
            iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                listener = listener1 = iterator.next();
                listener.filesAdded(added);
            }
            this.addedFileList.clear();
        }
        if (!this.removedFileList.isEmpty()) {
            File[] removed = new File[this.removedFileList.size()];
            removed = this.removedFileList.toArray(removed);
            iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                listener = listener1 = iterator.next();
                listener.filesRemoved(removed);
            }
            this.removedFileList.clear();
        }
    }

    private void addNewFilesToWatch() {
        FileContainer comparer = new FileContainer();
        for (File aDirectoryList : this.directoryList) {
            File dir = aDirectoryList;
            File[] fileArray = dir.listFiles();
            if (fileArray == null) continue;
            for (File file : fileArray) {
                if (this.directoriesContent.contains(file)) continue;
                comparer.setFile(file);
                if (this.watchedFiles.contains(comparer)) continue;
                FileContainer container = new FileContainer();
                container.setFile(file);
                container.setLastModified(file.lastModified());
                container.setSize(file.length());
                container.setStableCount(0);
                this.watchedFiles.add(container);
            }
        }
    }

    public static interface DirectoryWatchListener {
        public void filesAdded(File[] var1);

        public void filesRemoved(File[] var1);
    }

    private class DirectoryWatchTask
    extends TimerTask {
        private DirectoryWatchTask() {
        }

        @Override
        public void run() {
            DirectoryWatch.this.checkDirectories();
        }
    }

    private static class FileContainer {
        private File file;
        private long lastModified;
        private long size;
        private int stableCount;

        private FileContainer() {
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public int getStableCount() {
            return this.stableCount;
        }

        public void setStableCount(int stableCount) {
            this.stableCount = stableCount;
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj instanceof FileContainer) {
                result = this.file.equals(((FileContainer)obj).getFile());
            }
            return result;
        }
    }
}

