/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.dialogs;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.esa.snap.engine_utilities.db.SQLUtils;
import org.esa.snap.engine_utilities.download.opensearch.CopernicusProductQuery;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.ModalDialog;

public class JointSearchDialog
extends ModalDialog {
    private final JList<String> missionJList = new JList();
    private JTextField daysMinus = new JTextField("7");
    private JTextField daysPlus = new JTextField("7");
    private final JTextField cloudCoverField = new JTextField();
    private final JComboBox<String> acquisitionModeCombo = new JComboBox<String>(new String[]{"All_Modes"});
    private final JList<String> productTypeJList = new JList();
    private boolean ok = false;

    public JointSearchDialog(String title, final String mission) {
        super((Window)SnapApp.getDefault().getMainFrame(), title, 1, null);
        this.missionJList.setSelectionMode(2);
        this.missionJList.setListData((String[])CopernicusProductQuery.instance().getAllMissions());
        this.initMissionList(mission);
        this.missionJList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (event.getValueIsAdjusting()) {
                    int[] selectedIndices = JointSearchDialog.this.missionJList.getSelectedIndices();
                    if (selectedIndices.length == 0) {
                        JointSearchDialog.this.initMissionList(mission);
                    } else {
                        boolean isOpticalOnly = true;
                        for (int i : selectedIndices) {
                            if (i != 0) continue;
                            isOpticalOnly = false;
                            break;
                        }
                        JointSearchDialog.this.cloudCoverField.setEnabled(isOpticalOnly);
                        if (selectedIndices.length > 1) {
                            JointSearchDialog.this.acquisitionModeCombo.setSelectedIndex(0);
                            JointSearchDialog.this.acquisitionModeCombo.setEnabled(false);
                            JointSearchDialog.this.productTypeJList.removeAll();
                            JointSearchDialog.this.productTypeJList.setListData(new String[]{"All_Types"});
                            JointSearchDialog.this.productTypeJList.setEnabled(false);
                        } else {
                            String selectedMission = (String)JointSearchDialog.this.missionJList.getSelectedValue();
                            JointSearchDialog.this.updateAcquisitionModeCombo(selectedMission);
                            JointSearchDialog.this.acquisitionModeCombo.setEnabled(true);
                            JointSearchDialog.this.updateProductTypeList(new String[]{selectedMission});
                            JointSearchDialog.this.productTypeJList.setEnabled(true);
                        }
                    }
                }
            }
        });
        this.initContent();
    }

    protected void initContent() {
        JPanel content = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        DialogUtils.addComponent((JPanel)content, (GridBagConstraints)gbc, (String)"Mission:", this.missionJList);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)content, (GridBagConstraints)gbc, (String)"Minus (days):", (JComponent)this.daysMinus).setToolTipText("0 or +ve integer");
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)content, (GridBagConstraints)gbc, (String)"Plus (days):", (JComponent)this.daysPlus).setToolTipText("0 or +ve integer");
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)content, (GridBagConstraints)gbc, (String)"Cloud Cover %:", (JComponent)this.cloudCoverField).setToolTipText("Specify single integer value or a range, e.g., 10-70");
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)content, (GridBagConstraints)gbc, (String)"Acquisition Mode: ", this.acquisitionModeCombo);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)content, (GridBagConstraints)gbc, (String)"Product Type: ", (JComponent)new JScrollPane(this.productTypeJList));
        DialogUtils.fillPanel((JPanel)content, (GridBagConstraints)gbc);
        this.getJDialog().setMinimumSize(new Dimension(250, 100));
        this.setContent(content);
    }

    protected void onOK() {
        this.ok = true;
        this.hide();
    }

    protected void onCancel() {
        this.ok = false;
        this.hide();
    }

    public boolean IsOK() {
        return this.ok;
    }

    public String[] getMissions() {
        return JointSearchDialog.toStringArray(this.missionJList.getSelectedValuesList());
    }

    public int getDaysMinus() {
        int days = JointSearchDialog.getIntFromString(this.daysMinus.getText());
        return days > -1 ? days : -1;
    }

    public int getDaysPlus() {
        int days = JointSearchDialog.getIntFromString(this.daysPlus.getText());
        return days > -1 ? days : -1;
    }

    public String getCloudCover() {
        return this.cloudCoverField.getText();
    }

    public String getAcquisitionMode() {
        return (String)this.acquisitionModeCombo.getSelectedItem();
    }

    public String[] getProductTypes() {
        List<String> selectedProductTypes = this.productTypeJList.getSelectedValuesList();
        return selectedProductTypes.toArray(new String[selectedProductTypes.size()]);
    }

    private static int getIntFromString(String s) {
        try {
            int intVal = Integer.parseInt(s);
            return intVal;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static String[] toStringArray(List<String> list) {
        return list.toArray(new String[list.size()]);
    }

    private void initMissionList(String mission) {
        if (mission.toUpperCase().contains("SENTINEL-1")) {
            this.missionJList.setSelectedIndex(1);
            this.cloudCoverField.setEnabled(true);
        } else {
            this.missionJList.setSelectedIndex(0);
            this.cloudCoverField.setEnabled(false);
        }
        String selectedMission = this.missionJList.getSelectedValue();
        this.updateAcquisitionModeCombo(selectedMission);
        this.updateProductTypeList(new String[]{selectedMission});
    }

    private void updateAcquisitionModeCombo(String mission) {
        String[] acqModes;
        this.acquisitionModeCombo.removeAllItems();
        this.acquisitionModeCombo.addItem("All_Modes");
        for (String mode : acqModes = CopernicusProductQuery.instance().getAllAcquisitionModes(new String[]{mission})) {
            this.acquisitionModeCombo.addItem(mode);
        }
    }

    private void updateProductTypeList(String[] missions) {
        this.productTypeJList.removeAll();
        this.productTypeJList.setListData((String[])SQLUtils.prependString((String)"All_Types", (String[])CopernicusProductQuery.instance().getAllProductTypes(missions)));
    }
}

