/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.doclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.Doclet;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.RootDoc;
import com.sun.tools.javadoc.Main;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.doclet.OperatorDesc;
import org.esa.snap.core.gpf.doclet.OperatorHandler;
import org.esa.snap.core.gpf.doclet.OperatorHandlerConsole;
import org.esa.snap.core.gpf.doclet.OperatorHandlerHtml;
import org.esa.snap.core.util.io.WildcardMatcher;

public class OperatorDoclet
extends Doclet {
    private static String format;
    private static Path projectPath;

    public static void main(String[] args) throws IOException {
        if (args.length < 1 || args.length > 2) {
            System.out.println("Usage: OperatorDoclet <projectPath> [ console | html ]");
            System.exit(1);
        }
        projectPath = Paths.get(args[0], new String[0]);
        if (args.length == 2) {
            format = args[1];
        }
        Set<String> packageNameSet = OperatorDoclet.getPackagesToConsider();
        File[] sourcePaths = WildcardMatcher.glob((String)(projectPath.toString() + "/snap-engine/*/src/main/java"));
        String sourcePathParam = OperatorDoclet.concatPaths(sourcePaths);
        ArrayList<String> params = new ArrayList<String>();
        params.add("-doclet");
        params.add(OperatorDoclet.class.getName());
        params.add("-sourcepath");
        params.add(sourcePathParam);
        params.addAll(packageNameSet);
        Main.main((String[])params.toArray(new String[0]));
    }

    private static String concatPaths(File[] sourcePaths) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sourcePaths.length; ++i) {
            sb.append(sourcePaths[i]);
            if (i >= sourcePaths.length - 1) continue;
            sb.append(";");
        }
        return sb.toString();
    }

    private static Set<String> getPackagesToConsider() {
        OperatorSpiRegistry operatorSpiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        Set<OperatorSpi> operatorSpis = operatorSpiRegistry.getOperatorSpis();
        TreeSet<String> packageNameSet = new TreeSet<String>();
        for (OperatorSpi operatorSpi : operatorSpis) {
            String packageName = operatorSpi.getOperatorClass().getPackage().getName();
            packageNameSet.add(packageName);
        }
        return packageNameSet;
    }

    public static boolean start(RootDoc root) {
        ClassDoc[] classDocs;
        OperatorHandler operatorHandler;
        if ("console".equalsIgnoreCase(format)) {
            operatorHandler = new OperatorHandlerConsole();
        } else if ("html".equalsIgnoreCase(format)) {
            Path outputDir = projectPath.resolve("target").resolve("operatorDoclet");
            try {
                Files.createDirectories(outputDir, new FileAttribute[0]);
                operatorHandler = new OperatorHandlerHtml(outputDir);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create output directory: " + outputDir);
            }
        } else {
            throw new RuntimeException("Illegal output format: " + format);
        }
        try {
            operatorHandler.start(root);
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        OperatorSpiRegistry operatorSpiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        for (ClassDoc classDoc : classDocs = root.classes()) {
            if (!classDoc.subclassOf(root.classNamed(Operator.class.getName()))) continue;
            try {
                System.out.println("Processing " + classDoc.typeName() + "...");
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                Class<?> type = contextClassLoader.loadClass(classDoc.qualifiedTypeName());
                OperatorSpi operatorSpi = operatorSpiRegistry.getOperatorSpi(OperatorSpi.getOperatorAlias(type));
                if (operatorSpi != null) {
                    OperatorDescriptor operatorDescriptor = operatorSpi.getOperatorDescriptor();
                    if (!operatorDescriptor.isInternal()) {
                        OperatorDesc operatorDesc = new OperatorDesc(type, classDoc, operatorDescriptor);
                        operatorHandler.processOperator(operatorDesc);
                        continue;
                    }
                    System.err.printf("Warning: Skipping %s because it is internal.%n", classDoc.typeName());
                    continue;
                }
                System.err.printf("No SPI found for operator class '%s'.%n", type.getName());
            }
            catch (Throwable e) {
                System.err.println("Error: " + classDoc.typeName() + ": " + e.getMessage());
                e.printStackTrace(System.err);
            }
        }
        try {
            operatorHandler.stop(root);
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        return true;
    }

    public static int optionLength(String optionName) {
        if (optionName.equals("format")) {
            return 1;
        }
        return 0;
    }

    public static boolean validOptions(String[][] options, DocErrorReporter docErrorReporter) {
        for (int i = 0; i < options.length; ++i) {
            for (int j = 0; j < options[i].length; ++j) {
                docErrorReporter.printWarning("options[" + i + "][" + j + "] = " + options[i][j]);
            }
        }
        return true;
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }
}

