/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.opengis.referencing.operation.MathTransform;

public class ResampleUtils {
    public static boolean allGridsAlignAtUpperLeftPixel(Product product) {
        ProductNodeGroup tiePointGridGroup;
        MathTransform mapTransform = product.getSceneGeoCoding().getImageToMapTransform();
        if (!(mapTransform instanceof AffineTransform)) {
            return false;
        }
        AffineTransform affineTransform = (AffineTransform)mapTransform;
        ProductNodeGroup bandGroup = product.getBandGroup();
        return ResampleUtils.allGridsAlignAtUpperLeftPixelCenter(affineTransform, (ProductNodeGroup<Band>)bandGroup, (ProductNodeGroup<TiePointGrid>)(tiePointGridGroup = product.getTiePointGridGroup())) || ResampleUtils.allGridsAlignAtUpperLeftPixelCorner(affineTransform, (ProductNodeGroup<Band>)bandGroup, (ProductNodeGroup<TiePointGrid>)tiePointGridGroup);
    }

    static boolean allGridsAlignAtUpperLeftPixelCorner(AffineTransform mapTransform, ProductNodeGroup<Band> bandGroup, ProductNodeGroup<TiePointGrid> tiePointGridGroup) {
        return ResampleUtils.allGridsAlignAtUpperLeft(mapTransform, bandGroup, tiePointGridGroup, 0.0);
    }

    static boolean allGridsAlignAtUpperLeftPixelCenter(AffineTransform mapTransform, ProductNodeGroup<Band> bandGroup, ProductNodeGroup<TiePointGrid> tiePointGridGroup) {
        return ResampleUtils.allGridsAlignAtUpperLeft(mapTransform, bandGroup, tiePointGridGroup, 0.5);
    }

    private static boolean allGridsAlignAtUpperLeft(AffineTransform mapTransform, ProductNodeGroup<Band> bandGroup, ProductNodeGroup<TiePointGrid> tiePointGridGroup, double offset) {
        ArrayList<AffineTransform> transforms = new ArrayList<AffineTransform>();
        transforms.add(mapTransform);
        double centerX = mapTransform.getTranslateX() + offset * mapTransform.getScaleX();
        double centerY = mapTransform.getTranslateY() + offset * mapTransform.getScaleY();
        return ResampleUtils.allGridsAlignAtUpperLeft(transforms, centerX, centerY, bandGroup, offset) && ResampleUtils.allGridsAlignAtUpperLeft(transforms, centerX, centerY, tiePointGridGroup, offset);
    }

    static boolean allGridsAlignAtUpperLeft(ArrayList<AffineTransform> transforms, double centerX, double centerY, ProductNodeGroup group, double offset) {
        for (int i = 0; i < group.getNodeCount(); ++i) {
            RasterDataNode rasterDataNode = (RasterDataNode)group.get(i);
            AffineTransform transform = rasterDataNode.getImageToModelTransform();
            if (transforms.contains(transform)) continue;
            if (Math.abs(centerX - (transform.getTranslateX() + offset * transform.getScaleX())) > 1.0E-8 || Math.abs(centerY - (transform.getTranslateY() + offset * transform.getScaleY())) > 1.0E-8) {
                return false;
            }
            transforms.add(transform);
        }
        return true;
    }
}

