/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.JAI;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;

@OperatorMetadata(alias="WriteRGB", category="Input-Output", description="Creates an RGB image from three source bands.", internal=true)
public class WriteRGBOp
extends Operator {
    @Parameter(description="The zero-based index of the red band.")
    private int red;
    @Parameter(description="The zero-based index of the green band.")
    private int green;
    @Parameter(description="The zero-based index of the blue band.")
    private int blue;
    @Parameter(defaultValue="png")
    private String formatName;
    @Parameter(description="The file to which the image is written.")
    private File file;
    @SourceProduct(alias="input")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    private transient RasterDataNode[] rgbChannelNodes;
    private transient Map<Band, Band> bandMap;
    private transient Map<Band, ProductData> dataMap;

    @Override
    public void initialize() throws OperatorException {
        Band redBand = this.sourceProduct.getBandAt(this.red);
        Band greenBand = this.sourceProduct.getBandAt(this.green);
        Band blueBand = this.sourceProduct.getBandAt(this.blue);
        if (!ProductUtils.areRastersEqualInSize((RasterDataNode[])new Band[]{redBand, greenBand, blueBand})) {
            throw new OperatorException("The red, green, and blue bands must be the same size");
        }
        this.bandMap = new HashMap<Band, Band>(3);
        this.dataMap = new HashMap<Band, ProductData>(3);
        this.rgbChannelNodes = new RasterDataNode[3];
        int height = this.sourceProduct.getSceneRasterHeight();
        int width = this.sourceProduct.getSceneRasterWidth();
        this.targetProduct = new Product("RGB", "RGB", width, height);
        this.prepareTargetBand(0, redBand, "red", width, height);
        this.prepareTargetBand(1, greenBand, "green", width, height);
        this.prepareTargetBand(2, blueBand, "blue", width, height);
    }

    private void prepareTargetBand(int rgbIndex, Band sourceBand, String bandName, int width, int height) {
        Band targetBand = new Band(bandName, sourceBand.getDataType(), width, height);
        this.targetProduct.addBand(targetBand);
        this.bandMap.put(targetBand, sourceBand);
        ProductData data = targetBand.createCompatibleRasterData();
        this.dataMap.put(targetBand, data);
        targetBand.setRasterData(data);
        this.rgbChannelNodes[rgbIndex] = targetBand;
    }

    @Override
    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle rectangle = targetTile.getRectangle();
        Band sourceBand = this.bandMap.get(band);
        Tile sourceTile = this.getSourceTile((RasterDataNode)sourceBand, rectangle);
        ProductData rgbData = this.dataMap.get(band);
        System.arraycopy(sourceTile.getRawSamples().getElems(), 0, rgbData.getElems(), rectangle.x + rectangle.y * rectangle.width, rectangle.width * rectangle.height);
    }

    @Override
    public void dispose() {
        try {
            this.writeImage();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        super.dispose();
    }

    private void writeImage() throws IOException {
        ImageInfo imageInfo = ProductUtils.createImageInfo((RasterDataNode[])this.rgbChannelNodes, (boolean)true, (ProgressMonitor)ProgressMonitor.NULL);
        BufferedImage outputImage = ProductUtils.createRgbImage((RasterDataNode[])this.rgbChannelNodes, (ImageInfo)imageInfo, (ProgressMonitor)ProgressMonitor.NULL);
        ParameterBlock storeParams = new ParameterBlock();
        storeParams.addSource(outputImage);
        storeParams.add(this.file);
        storeParams.add(this.formatName);
        JAI.create((String)"filestore", (ParameterBlock)storeParams);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(WriteRGBOp.class);
        }
    }
}

