/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common;

import com.bc.ceres.core.ProgressMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.StringUtils;

@OperatorMetadata(alias="Merge", category="Raster", description="Allows merging of several source products by using specified 'master' as reference product.", authors="SNAP Team", version="1.2", copyright="(c) 2012 by Brockmann Consult")
public class MergeOp
extends Operator {
    @SourceProduct(description="The master, which serves as the reference, e.g. providing the geo-information.")
    private Product masterProduct;
    @SourceProducts(description="The products to be merged into the master product.")
    private Product[] sourceProducts;
    @TargetProduct
    private Product targetProduct;
    @Parameter(itemAlias="include", description="Defines nodes to be included in the master product. If no includes are provided, all nodes are copied.")
    private NodeDescriptor[] includes;
    @Parameter(itemAlias="exclude", description="Defines nodes to be excluded from the target product. Excludes have precedence above includes.")
    private NodeDescriptor[] excludes;
    @Parameter(defaultValue="1.0E-5f", description="Defines the maximum lat/lon error in degree between the products. If set to NaN no check for compatible geographic boundary is performed")
    private float geographicError;

    @Override
    public void initialize() throws OperatorException {
        this.targetProduct = new Product(this.masterProduct.getName(), this.masterProduct.getProductType(), this.masterProduct.getSceneRasterWidth(), this.masterProduct.getSceneRasterHeight());
        ProductUtils.copyProductNodes((Product)this.masterProduct, (Product)this.targetProduct);
        this.validateSourceProducts();
        ArrayList<Product> sourceProductList = new ArrayList<Product>();
        sourceProductList.addAll(Arrays.asList(this.sourceProducts));
        sourceProductList.add(0, this.masterProduct);
        Map<String, List<NodeDescriptor>> inclusionMap = this.createDesciptorMap(this.includes == null ? new NodeDescriptor[]{} : this.includes);
        this.addDefaultInclusions(sourceProductList, inclusionMap);
        Map<String, List<NodeDescriptor>> exclusionMap = this.createDesciptorMap(this.excludes == null ? new NodeDescriptor[]{} : this.excludes);
        HashSet<Product> usedProducts = new HashSet<Product>();
        for (Map.Entry<String, List<NodeDescriptor>> entry : inclusionMap.entrySet()) {
            String productId = entry.getKey();
            Product product = this.getSourceProduct(productId);
            List<NodeDescriptor> includesList = entry.getValue();
            for (NodeDescriptor includeDescriptor : includesList) {
                Pattern inclPattern = includeDescriptor.getCompiledNamePattern();
                for (String bandName : product.getBandNames()) {
                    Matcher inclMatcher = inclPattern.matcher(bandName);
                    if (!inclMatcher.matches() || this.shallBandBeExcluded(bandName, productId, exclusionMap)) continue;
                    String newName = StringUtils.isNotNullAndNotEmpty((String)includeDescriptor.newName) ? includeDescriptor.newName : bandName;
                    this.copyBandWithFeatures(product, bandName, newName);
                    usedProducts.add(product);
                }
            }
        }
        for (Product product : usedProducts) {
            this.mergeAutoGrouping(product);
            ProductUtils.copyMasks((Product)product, (Product)this.targetProduct);
            ProductUtils.copyOverlayMasks((Product)product, (Product)this.targetProduct);
        }
    }

    private boolean shallBandBeExcluded(String bandName, String productId, Map<String, List<NodeDescriptor>> exclusionMap) {
        List<NodeDescriptor> excludesList = exclusionMap.get(productId);
        if (excludesList != null) {
            for (NodeDescriptor excludeDescriptor : excludesList) {
                Pattern exclPattern = excludeDescriptor.getCompiledNamePattern();
                Matcher exclMatcher = exclPattern.matcher(bandName);
                if (!exclMatcher.matches()) continue;
                return true;
            }
        }
        return false;
    }

    private void addDefaultInclusions(ArrayList<Product> sourceProductList, Map<String, List<NodeDescriptor>> inclusionMap) {
        for (Product sourceProduct : sourceProductList) {
            String productId = this.getSourceProductId(sourceProduct);
            if (inclusionMap.containsKey(productId)) continue;
            NodeDescriptor nodeDescriptor = new NodeDescriptor();
            nodeDescriptor.namePattern = ".*";
            nodeDescriptor.productId = productId;
            inclusionMap.put(nodeDescriptor.productId, Collections.singletonList(nodeDescriptor));
        }
    }

    private Map<String, List<NodeDescriptor>> createDesciptorMap(NodeDescriptor[] descriptors) {
        LinkedHashMap<String, List<NodeDescriptor>> map = new LinkedHashMap<String, List<NodeDescriptor>>();
        for (NodeDescriptor nd : descriptors) {
            this.validateNodeDescriptor(nd);
            List descriptorList = (List)map.get(nd.productId);
            if (descriptorList == null) {
                ArrayList<NodeDescriptor> list = new ArrayList<NodeDescriptor>();
                list.add(nd);
                map.put(nd.productId, list);
                continue;
            }
            descriptorList.add(nd);
        }
        return map;
    }

    private void validateNodeDescriptor(NodeDescriptor nd) {
        if (StringUtils.isNullOrEmpty((String)nd.productId)) {
            throw new OperatorException("Missing product id for an include or exclude description");
        }
        if (StringUtils.isNullOrEmpty((String)nd.name) && StringUtils.isNullOrEmpty((String)nd.namePattern)) {
            throw new OperatorException(String.format("Neither 'name' nor 'namePattern' given node descriptor with product id '%s'", nd.productId));
        }
        if (StringUtils.isNotNullAndNotEmpty((String)nd.newName) && StringUtils.isNotNullAndNotEmpty((String)nd.namePattern)) {
            throw new OperatorException(String.format("Property 'newName' cannot be used with 'namePattern' in node descriptor with product id '%s'", nd.productId));
        }
    }

    private void mergeAutoGrouping(Product srcProduct) {
        Product.AutoGrouping srcAutoGrouping = srcProduct.getAutoGrouping();
        if (srcAutoGrouping != null && !srcAutoGrouping.isEmpty()) {
            Product.AutoGrouping targetAutoGrouping = this.targetProduct.getAutoGrouping();
            if (targetAutoGrouping == null) {
                this.targetProduct.setAutoGrouping(srcAutoGrouping);
            } else {
                for (String[] grouping : srcAutoGrouping) {
                    if (targetAutoGrouping.contains((Object)grouping)) continue;
                    this.targetProduct.setAutoGrouping(targetAutoGrouping.toString() + ":" + srcAutoGrouping);
                }
            }
        }
    }

    private void copyBandWithFeatures(Product sourceProduct, String oldBandName, String newBandName) {
        Band sourceBand = sourceProduct.getBand(oldBandName);
        if (sourceBand == null) {
            String msg = String.format("Source product [%s] does not contain a band with name [%s]", sourceProduct.getName(), oldBandName);
            throw new OperatorException(msg);
        }
        if (this.targetProduct.containsBand(newBandName)) {
            return;
        }
        ProductUtils.copyBand((String)oldBandName, (Product)sourceProduct, (String)newBandName, (Product)this.targetProduct, (boolean)true);
    }

    private void validateSourceProducts() {
        for (Product sourceProduct : this.getSourceProducts()) {
            if (Float.isNaN(this.geographicError) || this.targetProduct.isCompatibleProduct(sourceProduct, this.geographicError)) continue;
            throw new OperatorException(String.format("Product [%s] is not compatible to master product.", this.getSourceProductId(sourceProduct)));
        }
    }

    @Override
    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        this.getLogger().warning("Wrongly configured operator. Tiles of Band '" + band.getName() + "' should not be requested.");
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(MergeOp.class);
        }
    }

    public static class NodeDescriptor {
        private String productId;
        private String name;
        private String newName;
        private String namePattern;
        private transient Pattern compiledPattern;

        public void setProductId(String productId) {
            this.productId = productId;
        }

        public void setName(String name) {
            this.name = name;
            this.compiledPattern = null;
        }

        public void setNewName(String newName) {
            this.newName = newName;
        }

        public void setNamePattern(String namePattern) {
            this.namePattern = namePattern;
            this.compiledPattern = null;
        }

        private Pattern getCompiledNamePattern() {
            if (this.compiledPattern == null) {
                this.compiledPattern = Pattern.compile(StringUtils.isNotNullAndNotEmpty((String)this.name) ? this.name : this.namePattern);
            }
            return this.compiledPattern;
        }
    }
}

