/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Logger;
import javax.media.jai.BorderExtender;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.internal.OperatorContext;

public abstract class Operator {
    final OperatorContext context = new OperatorContext(this);

    protected Operator() {
    }

    public void setParameterDefaultValues() {
        this.context.getParameterSet().setDefaultValues();
    }

    protected final void finalize() throws Throwable {
        this.context.dispose();
        super.finalize();
    }

    public abstract void initialize() throws OperatorException;

    public final void update() {
        this.context.updateOperator();
    }

    public final void execute(ProgressMonitor pm) {
        this.getTargetProduct();
        this.context.executeOperator(pm);
    }

    public void doExecute(ProgressMonitor pm) throws OperatorException {
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        throw new RuntimeException(MessageFormat.format("{0}: ''computeTile()'' method not implemented", this.getClass().getSimpleName()));
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        throw new RuntimeException(MessageFormat.format("{0}: ''computeTileStack()'' method not implemented", this.getClass().getSimpleName()));
    }

    public void dispose() {
    }

    public boolean canComputeTile() {
        return this.context.isComputeTileMethodImplemented();
    }

    public boolean canComputeTileStack() {
        return this.context.isComputeTileStackMethodImplemented();
    }

    @Deprecated
    protected final void deactivateComputeTileMethod() throws IllegalStateException {
        if (!this.canComputeTileStack()) {
            throw new IllegalStateException("!canComputeTileStack()");
        }
    }

    public ProductManager getProductManager() {
        return GPF.getDefaultInstance().getProductManager();
    }

    protected final void setRequiresAllBands(boolean requiresAllBands) {
        this.context.setRequiresAllBands(requiresAllBands);
    }

    public final String getId() {
        return this.context.getId();
    }

    public final Product[] getSourceProducts() {
        return this.context.getSourceProducts();
    }

    public final void setSourceProducts(Product ... products) {
        Assert.notNull((Object)products, (String)"products");
        this.context.setSourceProducts(products);
    }

    public Product getSourceProduct() {
        Product product = this.getSourceProduct("sourceProduct");
        if (product != null) {
            return product;
        }
        Product[] products = this.getSourceProducts();
        if (products.length > 0) {
            return products[0];
        }
        return null;
    }

    public void setSourceProduct(Product sourceProduct) {
        this.setSourceProduct("sourceProduct", sourceProduct);
    }

    public final Product getSourceProduct(String id) {
        Assert.notNull((Object)id, (String)"id");
        return this.context.getSourceProduct(id);
    }

    public final void setSourceProduct(String id, Product product) {
        Assert.notNull((Object)id, (String)"id");
        Assert.notNull((Object)product, (String)"product");
        this.context.setSourceProduct(id, product);
    }

    public final String getSourceProductId(Product product) {
        Assert.notNull((Object)product, (String)"product");
        return this.context.getSourceProductId(product);
    }

    public final Product getTargetProduct() throws OperatorException {
        return this.context.getTargetProduct();
    }

    public final void setTargetProduct(Product targetProduct) {
        this.context.setTargetProduct(targetProduct);
    }

    public final Object getTargetProperty(String name) throws OperatorException {
        return this.context.getTargetProperty(name);
    }

    public Object getParameter(String name) {
        return this.context.getParameter(name);
    }

    public Object getParameter(String name, Object defaultValue) {
        Object parameter = this.context.getParameter(name);
        return parameter != null ? parameter : defaultValue;
    }

    public void setParameter(String name, Object value) {
        this.context.setParameter(name, value);
    }

    public final Tile getSourceTile(RasterDataNode rasterDataNode, Rectangle region) throws OperatorException {
        return this.context.getSourceTile(rasterDataNode, region);
    }

    public final Tile getSourceTile(RasterDataNode rasterDataNode, Rectangle region, BorderExtender borderExtender) throws OperatorException {
        return this.context.getSourceTile(rasterDataNode, region, borderExtender);
    }

    protected final void checkForCancellation() throws OperatorException {
        this.context.checkForCancellation();
    }

    protected void ensureSceneGeoCoding(Product ... products) throws OperatorException {
        for (Product product : products) {
            if (product.getSceneGeoCoding() != null) continue;
            throw new OperatorException(String.format("Source product '%s' must be geo-coded.", product.getName()));
        }
    }

    protected Dimension ensureSingleRasterSize(Product ... products) throws OperatorException {
        Dimension sceneRasterSize = null;
        for (Product product : products) {
            if (product.isMultiSize()) {
                String message = String.format("Source product '%s' contains rasters of different sizes and can not be processed.\nPlease consider resampling it so that all rasters have the same size.", product.getName());
                throw new OperatorException(message);
            }
            if (sceneRasterSize == null) {
                sceneRasterSize = product.getSceneRasterSize();
                continue;
            }
            if (product.getSceneRasterSize().equals(sceneRasterSize)) continue;
            throw new OperatorException(String.format("All source products must have the same raster size of %d x %d pixels.", sceneRasterSize.width, sceneRasterSize.height));
        }
        return sceneRasterSize;
    }

    protected Dimension ensureSingleRasterSize(RasterDataNode ... rasterDataNodes) throws OperatorException {
        Dimension rasterSize = null;
        for (RasterDataNode rasterDataNode : rasterDataNodes) {
            if (rasterSize == null) {
                rasterSize = rasterDataNode.getRasterSize();
                continue;
            }
            if (rasterSize.equals(rasterDataNode.getRasterSize())) continue;
            throw new OperatorException(String.format("All source rasters must have the same size of %d x %d pixels.", rasterSize.width, rasterSize.height));
        }
        return rasterSize;
    }

    public final Logger getLogger() {
        return this.context.getLogger();
    }

    public void stopTileComputationObservation() {
        this.context.stopTileComputationObservation();
    }

    public final void setLogger(Logger logger) {
        Assert.notNull((Object)logger, (String)"logger");
        this.context.setLogger(logger);
    }

    public final OperatorSpi getSpi() {
        return this.context.getOperatorSpi();
    }

    public final void setSpi(OperatorSpi operatorSpi) {
        Assert.notNull((Object)operatorSpi, (String)"operatorSpi");
        Assert.argument((boolean)operatorSpi.getOperatorClass().isAssignableFrom(this.getClass()), (String)"operatorSpi");
        this.context.setOperatorSpi(operatorSpi);
    }
}

