/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.media.jai.Histogram;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.HistogramStxOp;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.QualitativeStxOp;
import org.esa.snap.core.datamodel.SummaryStxOp;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.WildcardMatcher;
import org.esa.snap.statistics.BandConfiguration;
import org.esa.snap.statistics.ProductLoader;
import org.esa.snap.statistics.ProductLoop;
import org.esa.snap.statistics.ProductValidator;
import org.esa.snap.statistics.StatisticComputer;
import org.esa.snap.statistics.TimeIntervalDefinition;
import org.esa.snap.statistics.output.BandNameCreator;
import org.esa.snap.statistics.output.CsvStatisticsWriter;
import org.esa.snap.statistics.output.FeatureStatisticsWriter;
import org.esa.snap.statistics.output.MetadataWriter;
import org.esa.snap.statistics.output.StatisticsOutputContext;
import org.esa.snap.statistics.output.StatisticsOutputter;
import org.esa.snap.statistics.output.Util;
import org.esa.snap.statistics.tools.TimeInterval;

@OperatorMetadata(alias="StatisticsOp", category="Raster", version="1.0", authors="Sabine Embacher, Tonio Fincke, Thomas Storm", copyright="(c) 2012 by Brockmann Consult GmbH", description="Computes statistics for an arbitrary number of source products.", autoWriteDisabled=true)
public class StatisticsOp
extends Operator {
    public static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String MAJORITY_CLASS = "majority_class";
    public static final String SECOND_MAJORITY_CLASS = "second_majority_class";
    public static final String MAXIMUM = "maximum";
    public static final String MINIMUM = "minimum";
    public static final String MEDIAN = "median";
    public static final String AVERAGE = "average";
    public static final String SIGMA = "sigma";
    public static final String MAX_ERROR = "max_error";
    public static final String TOTAL = "total";
    public static final String PERCENTILE_PREFIX = "p";
    public static final String PERCENTILE_SUFFIX = "_threshold";
    public static final String DEFAULT_PERCENTILES = "90,95";
    public static final int[] DEFAULT_PERCENTILES_INTS = new int[]{90, 95};
    private static final double FILL_VALUE = -999.0;
    static final int ALL_MEASURES = 0;
    static final int QUALITATIVE_MEASURES = 1;
    static final int QUANTITATIVE_MEASURES = 2;
    @SourceProducts(description="The source products to be considered for statistics computation. If not given, the parameter 'sourceProductPaths' must be provided.")
    Product[] sourceProducts;
    @Parameter(description="A comma-separated list of file paths specifying the source products.\nEach path may contain the wildcards '**' (matches recursively any directory),\n'*' (matches any character sequence in path names) and\n'?' (matches any single character).\nIf, for example, all NetCDF files under /eodata/ shall be considered, use '/eodata/**/*.nc'.")
    String[] sourceProductPaths;
    @Parameter(description="An ESRI shapefile, providing the considered geographical region(s) given as polygons. If null, all pixels are considered.")
    File shapefile;
    @Parameter(description="The start date. If not given, taken from the 'oldest' source product. Products that have a start date before the start date given by this parameter are not considered.", format="yyyy-MM-dd HH:mm:ss", converter=UtcConverter.class)
    ProductData.UTC startDate;
    @Parameter(description="The end date. If not given, taken from the 'youngest' source product. Products that have an end date after the end date given by this parameter are not considered.", format="yyyy-MM-dd HH:mm:ss", converter=UtcConverter.class)
    ProductData.UTC endDate;
    @Parameter(description="The band configurations. These configurations determine the input of the operator.", alias="bandConfigurations", itemAlias="bandConfiguration", notNull=true)
    BandConfiguration[] bandConfigurations;
    @Parameter(description="The target file for shapefile output. Shapefile output will only be written if this parameter is set. The band mapping file will have the suffix _band_mapping.txt.", notNull=false)
    File outputShapefile;
    @Parameter(description="The target file for ASCII output.The metadata file will have the suffix _metadata.txt.\nASCII output will only be written if this parameter is set.", notNull=false)
    File outputAsciiFile;
    @Parameter(description="The percentile levels that shall be created. Must be in the interval [0..100]", notNull=false, defaultValue="90,95")
    int[] percentiles;
    @Parameter(description="The degree of accuracy used for statistics computation. Higher numbers indicate higher accuracy but may lead to a considerably longer computation time.", defaultValue="3")
    int accuracy;
    @Parameter(description="If set, the StatisticsOp will divide the time between start and end time into time intervalsdefined by this parameter. All measures will be aggregated from products within these intervals. This parameter will only have an effect if the parameters start date and end date are set.")
    TimeIntervalDefinition interval;
    @Parameter(description="If true, categorical measures and quantitative measures will be written separately.", defaultValue="false")
    boolean writeDataTypesSeparately;
    final Set<StatisticsOutputter> allStatisticsOutputters = new HashSet<StatisticsOutputter>();
    private final Set<StatisticsOutputter> qualitativeStatisticsOutputters = new HashSet<StatisticsOutputter>();
    private final Set<StatisticsOutputter> quantitativeStatisticsOutputters = new HashSet<StatisticsOutputter>();
    private final Set[] statisticsOutputters = new Set[]{this.allStatisticsOutputters, this.qualitativeStatisticsOutputters, this.quantitativeStatisticsOutputters};
    private final SortedSet<String> regionNames = new TreeSet<String>();
    private PrintStream[] metadataOutputStreams = new PrintStream[3];
    private PrintStream[] csvOutputStreams = new PrintStream[3];
    private PrintStream[] bandMappingOutputStreams = new PrintStream[3];

    public void initialize() throws OperatorException {
        this.setDummyTargetProduct();
        this.validateInput();
    }

    public void doExecute(ProgressMonitor pm) throws OperatorException {
        TimeInterval[] timeIntervals = StatisticsOp.getTimeIntervals(this.interval, this.startDate, this.endDate);
        StatisticComputer statisticComputer = new StatisticComputer(this.shapefile, this.bandConfigurations, Util.computeBinCount(this.accuracy), timeIntervals, this.getLogger());
        ProductValidator productValidator = new ProductValidator(Arrays.asList(this.bandConfigurations), this.startDate, this.endDate, this.getLogger());
        ProductLoop productLoop = new ProductLoop(new ProductLoader(), productValidator, statisticComputer, pm, this.getLogger());
        productLoop.loop(this.sourceProducts, this.getProductsToLoad());
        String[] productNames = productLoop.getProductNames();
        if (productNames.length == 0) {
            throw new OperatorException("No input products found that matches the criteria.");
        }
        Map<BandConfiguration, StatisticComputer.StxOpMapping>[] stxOpsList = statisticComputer.getResultList();
        this.regionNames.clear();
        for (Map<BandConfiguration, StatisticComputer.StxOpMapping> stxOps : stxOpsList) {
            for (StatisticComputer.StxOpMapping stxOpMapping : stxOps.values()) {
                this.regionNames.addAll(stxOpMapping.summaryMap.keySet());
                this.regionNames.addAll(stxOpMapping.qualitativeMap.keySet());
            }
        }
        if (this.regionNames.size() == 0) {
            this.getLogger().warning("No statistics computed because no input product intersects any feature from the given shapefile.");
            return;
        }
        String[] regionIDS = this.regionNames.toArray(new String[0]);
        this.defineOutputters(timeIntervals, this.percentiles, productNames, regionIDS, stxOpsList);
        if (timeIntervals.length == 0) {
            this.processStatisticsPerTimeInterval(statisticComputer.getResults(0), null);
        }
        for (int i = 0; i < timeIntervals.length; ++i) {
            this.processStatisticsPerTimeInterval(statisticComputer.getResults(i), timeIntervals[i]);
        }
        try {
            for (StatisticsOutputter statisticsOutputter : this.allStatisticsOutputters) {
                statisticsOutputter.finaliseOutput();
            }
        }
        catch (IOException e) {
            throw new OperatorException("Unable to write output.", (Throwable)e);
        }
        finally {
            for (int j = 0; j < 3; ++j) {
                if (this.metadataOutputStreams[j] != null) {
                    this.metadataOutputStreams[j].close();
                }
                if (this.csvOutputStreams[j] != null) {
                    this.csvOutputStreams[j].close();
                }
                if (this.bandMappingOutputStreams[j] == null) continue;
                this.bandMappingOutputStreams[j].close();
            }
        }
        this.getLogger().log(Level.INFO, "Successfully computed statistics.");
    }

    private void processStatisticsPerTimeInterval(Map<BandConfiguration, StatisticComputer.StxOpMapping> stxOps, TimeInterval timeInterval) {
        for (Map.Entry<BandConfiguration, StatisticComputer.StxOpMapping> bandConfigurationStxOpMappingEntry : stxOps.entrySet()) {
            BandConfiguration bandConfiguration = bandConfigurationStxOpMappingEntry.getKey();
            String bandName = bandConfiguration.sourceBandName != null ? bandConfiguration.sourceBandName : bandConfiguration.expression.replace(" ", "_");
            StatisticComputer.StxOpMapping stxOpMapping = bandConfigurationStxOpMappingEntry.getValue();
            Map<String, QualitativeStxOp> qualitativeMap = stxOpMapping.qualitativeMap;
            for (String regionName : qualitativeMap.keySet()) {
                HashMap<String, Object> stxMap = new HashMap<String, Object>();
                QualitativeStxOp qualitativeStxOp = qualitativeMap.get(regionName);
                if (!qualitativeStxOp.getMajorityClass().equals("")) {
                    String[] classNames = qualitativeStxOp.getClassNames();
                    for (String className : classNames) {
                        stxMap.put(className, qualitativeStxOp.getNumberOfMembers(className));
                    }
                    stxMap.put(MAJORITY_CLASS, qualitativeStxOp.getMajorityClass());
                    stxMap.put(SECOND_MAJORITY_CLASS, qualitativeStxOp.getSecondMajorityClass());
                    stxMap.put(TOTAL, qualitativeStxOp.getTotalNumClassMembers());
                }
                for (StatisticsOutputter statisticsOutputter : this.qualitativeStatisticsOutputters) {
                    if (timeInterval != null) {
                        statisticsOutputter.addToOutput(bandName, timeInterval, regionName, stxMap);
                        continue;
                    }
                    statisticsOutputter.addToOutput(bandName, regionName, stxMap);
                }
            }
            Map<String, SummaryStxOp> summaryMap = stxOpMapping.summaryMap;
            Map<String, HistogramStxOp> histogramMap = stxOpMapping.histogramMap;
            for (String regionName : summaryMap.keySet()) {
                Object object;
                HashMap<String, Object> stxMap = new HashMap<String, Object>();
                SummaryStxOp summaryStxOp = summaryMap.get(regionName);
                Histogram histogram = histogramMap.get(regionName).getHistogram();
                if (histogram.getTotals()[0] == 0) {
                    stxMap.put(MINIMUM, -999.0);
                    stxMap.put(MAXIMUM, -999.0);
                    stxMap.put(AVERAGE, -999.0);
                    stxMap.put(SIGMA, -999.0);
                    stxMap.put(TOTAL, 0);
                    stxMap.put(MEDIAN, -999.0);
                    for (Object percentile : this.percentiles) {
                        stxMap.put(StatisticsOp.getPercentileName(percentile), -999.0);
                    }
                } else {
                    stxMap.put(MINIMUM, summaryStxOp.getMinimum());
                    stxMap.put(MAXIMUM, summaryStxOp.getMaximum());
                    stxMap.put(AVERAGE, summaryStxOp.getMean());
                    stxMap.put(SIGMA, summaryStxOp.getStandardDeviation());
                    stxMap.put(TOTAL, histogram.getTotals()[0]);
                    stxMap.put(MEDIAN, histogram.getPTileThreshold(0.5)[0]);
                    object = this.percentiles;
                    int className = ((int[])object).length;
                    for (int i = 0; i < className; ++i) {
                        Object percentile;
                        percentile = object[i];
                        stxMap.put(StatisticsOp.getPercentileName(percentile), this.computePercentile((int)percentile, histogram));
                    }
                }
                stxMap.put(MAX_ERROR, Util.getBinWidth(histogram));
                object = this.quantitativeStatisticsOutputters.iterator();
                while (object.hasNext()) {
                    StatisticsOutputter statisticsOutputter = (StatisticsOutputter)object.next();
                    if (timeInterval != null) {
                        statisticsOutputter.addToOutput(bandName, timeInterval, regionName, stxMap);
                        continue;
                    }
                    statisticsOutputter.addToOutput(bandName, regionName, stxMap);
                }
            }
        }
    }

    private File[] getProductsToLoad() {
        TreeSet fileSet = new TreeSet();
        if (this.sourceProductPaths != null) {
            for (String filePattern : this.sourceProductPaths) {
                if (filePattern == null) continue;
                try {
                    WildcardMatcher.glob((String)filePattern, fileSet);
                }
                catch (IOException e) {
                    this.logReadProductError(filePattern);
                }
            }
        }
        return fileSet.toArray(new File[fileSet.size()]);
    }

    static TimeInterval[] getTimeIntervals(TimeIntervalDefinition interval, ProductData.UTC startDate, ProductData.UTC endDate) {
        if (startDate == null || endDate == null) {
            return new TimeInterval[0];
        }
        if (interval == null) {
            return new TimeInterval[]{new TimeInterval(0, startDate, endDate)};
        }
        ArrayList<TimeInterval> timeIntervalList = new ArrayList<TimeInterval>();
        int timeField = StatisticsOp.getTimeField(interval);
        ProductData.UTC currentStartDate = new ProductData.UTC(startDate.getMJD());
        ProductData.UTC currentEndDate = StatisticsOp.getIncreasedDate(startDate, timeField, interval.amount);
        int counter = 0;
        while (currentEndDate.getAsDate().before(endDate.getAsDate())) {
            timeIntervalList.add(new TimeInterval(counter++, currentStartDate, currentEndDate));
            currentStartDate = new ProductData.UTC(currentEndDate.getMJD());
            currentEndDate = StatisticsOp.getIncreasedDate(currentEndDate, timeField, interval.amount);
        }
        timeIntervalList.add(new TimeInterval(counter, currentStartDate, endDate));
        return timeIntervalList.toArray(new TimeInterval[0]);
    }

    private static ProductData.UTC getIncreasedDate(ProductData.UTC date, int timeField, int amount) {
        Calendar calendar = date.getAsCalendar();
        calendar.add(timeField, amount);
        return ProductData.UTC.create((Date)calendar.getTime(), (long)0L);
    }

    private static int getTimeField(TimeIntervalDefinition interval) {
        switch (interval.unit) {
            case "days": {
                return 5;
            }
            case "weeks": {
                return 3;
            }
            case "months": {
                return 2;
            }
            case "years": {
                return 1;
            }
        }
        throw new OperatorException("Invalid interval unit: " + interval.unit);
    }

    private static String[] getMeasureNames(Map<BandConfiguration, StatisticComputer.StxOpMapping>[] stxOpsList, int[] percentiles, int qualifier) {
        ArrayList<String> measures = new ArrayList<String>();
        for (Map<BandConfiguration, StatisticComputer.StxOpMapping> stxOps : stxOpsList) {
            for (StatisticComputer.StxOpMapping stxOpMapping : stxOps.values()) {
                if (qualifier != 1 && !measures.contains(MINIMUM)) {
                    Collection<SummaryStxOp> summaryStxOps = stxOpMapping.summaryMap.values();
                    for (SummaryStxOp summaryStxOp : summaryStxOps) {
                        if (Double.isNaN(summaryStxOp.getMean())) continue;
                        measures.add(MINIMUM);
                        measures.add(MAXIMUM);
                        measures.add(MEDIAN);
                        measures.add(AVERAGE);
                        measures.add(SIGMA);
                        for (int percentile : percentiles) {
                            measures.add(StatisticsOp.getPercentileName(percentile));
                        }
                        measures.add(MAX_ERROR);
                        if (measures.contains(TOTAL)) break;
                        measures.add(TOTAL);
                        break;
                    }
                }
                if (qualifier == 2) continue;
                Collection<QualitativeStxOp> qualitativeStxOps = stxOpMapping.qualitativeMap.values();
                if (!qualitativeStxOps.isEmpty() && !measures.contains(MAJORITY_CLASS)) {
                    measures.add(MAJORITY_CLASS);
                    measures.add(SECOND_MAJORITY_CLASS);
                    if (!measures.contains(TOTAL)) {
                        measures.add(TOTAL);
                    }
                }
                for (QualitativeStxOp qualitativeStxOp : qualitativeStxOps) {
                    String[] classNames;
                    if (qualitativeStxOp.getMajorityClass().equals("")) continue;
                    for (String className : classNames = qualitativeStxOp.getClassNames()) {
                        if (measures.contains(className)) continue;
                        measures.add(className);
                    }
                }
            }
        }
        return measures.toArray(new String[0]);
    }

    @Deprecated
    public static String[] getAlgorithmNames(int[] percentiles) {
        ArrayList<String> algorithms = new ArrayList<String>();
        algorithms.add(MINIMUM);
        algorithms.add(MAXIMUM);
        algorithms.add(MEDIAN);
        algorithms.add(AVERAGE);
        algorithms.add(SIGMA);
        for (int percentile : percentiles) {
            algorithms.add(StatisticsOp.getPercentileName(percentile));
        }
        algorithms.add(MAX_ERROR);
        algorithms.add(TOTAL);
        return algorithms.toArray(new String[algorithms.size()]);
    }

    private static String getPercentileName(int percentile) {
        return PERCENTILE_PREFIX + percentile + PERCENTILE_SUFFIX;
    }

    private void defineOutputters(TimeInterval[] timeIntervals, int[] percentiles, String[] productNames, String[] regionIDs, Map<BandConfiguration, StatisticComputer.StxOpMapping>[] stxOpsList) {
        if (this.writeDataTypesSeparately && this.hasQualitativeAndQuantitativeData()) {
            this.defineOutputterType(timeIntervals, percentiles, productNames, regionIDs, stxOpsList, 1);
            this.defineOutputterType(timeIntervals, percentiles, productNames, regionIDs, stxOpsList, 2);
            this.allStatisticsOutputters.addAll(this.qualitativeStatisticsOutputters);
            this.allStatisticsOutputters.addAll(this.quantitativeStatisticsOutputters);
        } else {
            this.defineOutputterType(timeIntervals, percentiles, productNames, regionIDs, stxOpsList, 0);
            this.qualitativeStatisticsOutputters.addAll(this.allStatisticsOutputters);
            this.quantitativeStatisticsOutputters.addAll(this.allStatisticsOutputters);
        }
    }

    private void defineOutputterType(TimeInterval[] timeIntervals, int[] percentiles, String[] productNames, String[] regionIDs, Map<BandConfiguration, StatisticComputer.StxOpMapping>[] stxOpsList, int qualifier) {
        String[] bandNames = this.getBandNames(qualifier);
        String[] measureNames = StatisticsOp.getMeasureNames(stxOpsList, percentiles, qualifier);
        StatisticsOutputContext statisticsOutputContext = StatisticsOutputContext.create(productNames, bandNames, measureNames, timeIntervals, regionIDs);
        this.setupOutputters(qualifier);
        Set outputters = this.statisticsOutputters[qualifier];
        for (StatisticsOutputter statisticsOutputter : outputters) {
            statisticsOutputter.initialiseOutput(statisticsOutputContext);
        }
    }

    private String[] getBandNames(int quantifier) {
        if (quantifier == 1) {
            return this.getBandNames(true, true);
        }
        if (quantifier == 2) {
            return this.getBandNames(true, false);
        }
        return this.getBandNames(false, true);
    }

    private String[] getBandNames(boolean considerMeasureType, boolean retrieveCategorical) {
        ArrayList<String> bandNamesList = new ArrayList<String>();
        for (BandConfiguration bandConfiguration : this.bandConfigurations) {
            if (considerMeasureType && bandConfiguration.retrieveCategoricalStatistics != retrieveCategorical) continue;
            if (bandConfiguration.sourceBandName != null) {
                bandNamesList.add(bandConfiguration.sourceBandName);
                continue;
            }
            bandNamesList.add(bandConfiguration.expression.replace(" ", "_"));
        }
        return bandNamesList.toArray(new String[0]);
    }

    private boolean hasQualitativeAndQuantitativeData() {
        boolean hasQuantitativeData = false;
        boolean hasQualitativeData = false;
        for (BandConfiguration bandConfiguration : this.bandConfigurations) {
            if (bandConfiguration.retrieveCategoricalStatistics) {
                hasQualitativeData = true;
                if (!hasQuantitativeData) continue;
                return true;
            }
            hasQuantitativeData = true;
            if (!hasQualitativeData) continue;
            return true;
        }
        return false;
    }

    static File getOutputFile(File origFile, int qualifier) {
        if (origFile == null) {
            return null;
        }
        if (qualifier == 1) {
            return new File(origFile.getParent(), FileUtils.getFilenameWithoutExtension((File)origFile) + "_categorical" + FileUtils.getExtension((File)origFile));
        }
        if (qualifier == 2) {
            return new File(origFile.getParent(), FileUtils.getFilenameWithoutExtension((File)origFile) + "_quantitative" + FileUtils.getExtension((File)origFile));
        }
        return origFile;
    }

    private void setupOutputters(int qualifier) {
        File shapeFileOut;
        Set outputters = this.statisticsOutputters[qualifier];
        File asciiFile = StatisticsOp.getOutputFile(this.outputAsciiFile, qualifier);
        if (asciiFile != null) {
            try {
                File metadataFile = new File(asciiFile.getParent(), FileUtils.getFilenameWithoutExtension((File)asciiFile) + "_metadata.txt");
                this.metadataOutputStreams[qualifier] = new PrintStream(new FileOutputStream(metadataFile));
                this.csvOutputStreams[qualifier] = new PrintStream(new FileOutputStream(asciiFile));
                outputters.add(new CsvStatisticsWriter(this.csvOutputStreams[qualifier]));
                outputters.add(new MetadataWriter(this.metadataOutputStreams[qualifier]));
            }
            catch (FileNotFoundException e) {
                throw new OperatorException((Throwable)e);
            }
        }
        if ((shapeFileOut = StatisticsOp.getOutputFile(this.outputShapefile, qualifier)) != null) {
            try {
                String baseName = FileUtils.getFilenameWithoutExtension((File)shapeFileOut);
                File bandMappingFile = new File(shapeFileOut.getParent(), baseName + "_band_mapping.txt");
                FileOutputStream bandMappingFOS = new FileOutputStream(bandMappingFile);
                this.bandMappingOutputStreams[qualifier] = new PrintStream(bandMappingFOS);
                BandNameCreator bandNameCreator = new BandNameCreator(this.bandMappingOutputStreams[qualifier]);
                outputters.add(FeatureStatisticsWriter.createFeatureStatisticsWriter(this.shapefile.toURI().toURL(), shapeFileOut.getAbsolutePath(), bandNameCreator));
            }
            catch (MalformedURLException e) {
                throw new OperatorException("Unable to create shapefile outputter: shapefile '" + this.shapefile.getName() + "' is invalid.", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                throw new OperatorException("Unable to create shapefile outputter: maybe shapefile output directory does not exist?", (Throwable)e);
            }
        }
    }

    private Number computePercentile(int percentile, Histogram histogram) {
        return histogram.getPTileThreshold((double)percentile * 0.01)[0];
    }

    static Band getBand(BandConfiguration configuration, Product product) {
        Band band;
        if (configuration.sourceBandName != null) {
            band = product.getBand(configuration.sourceBandName);
            band.setNoDataValueUsed(true);
        } else {
            band = product.addBand(configuration.expression.replace(" ", "_"), configuration.expression, 31);
        }
        if (band == null) {
            throw new OperatorException(MessageFormat.format("Band ''{0}'' does not exist in product ''{1}''.", configuration.sourceBandName, product.getName()));
        }
        return band;
    }

    void validateInput() {
        if (this.startDate != null && this.endDate != null && this.endDate.getAsDate().before(this.startDate.getAsDate())) {
            throw new OperatorException("End date '" + this.endDate + "' before start date '" + this.startDate + "'");
        }
        if (this.accuracy < 0) {
            throw new OperatorException("Parameter 'accuracy' must be greater than or equal to 0");
        }
        if (this.accuracy > 6) {
            throw new OperatorException("Parameter 'accuracy' must be less than or equal to 6");
        }
        if (!(this.sourceProducts != null && this.sourceProducts.length != 0 || this.sourceProductPaths != null && this.sourceProductPaths.length != 0)) {
            throw new OperatorException("Either source products must be given or parameter 'sourceProductPaths' must be specified");
        }
        if (this.bandConfigurations == null) {
            throw new OperatorException("Parameter 'bandConfigurations' must be specified.");
        }
        for (BandConfiguration configuration : this.bandConfigurations) {
            if (configuration.sourceBandName == null && configuration.expression == null) {
                throw new OperatorException("Configuration must contain either a source band name or an expression.");
            }
            if (configuration.sourceBandName == null || configuration.expression == null) continue;
            throw new OperatorException("Configuration must contain either a source band name or an expression.");
        }
        if (this.interval != null && this.interval.amount < 1) {
            throw new OperatorException("interval amount must be larger than 0.");
        }
        if (this.outputAsciiFile != null && this.outputAsciiFile.isDirectory()) {
            throw new OperatorException("Parameter 'outputAsciiFile' must not point to a directory.");
        }
        if (this.outputShapefile != null) {
            if (this.outputShapefile.isDirectory()) {
                throw new OperatorException("Parameter 'outputShapefile' must point to a file.");
            }
            if (this.shapefile == null) {
                throw new OperatorException("Parameter 'shapefile' must be provided if an output shapefile shall be created.");
            }
        }
        if (this.shapefile != null && this.shapefile.isDirectory()) {
            throw new OperatorException("Parameter 'shapefile' must point to a file.");
        }
        if (this.percentiles == null || this.percentiles.length == 0) {
            this.percentiles = DEFAULT_PERCENTILES_INTS;
        }
        for (int percentile : this.percentiles) {
            if (percentile >= 0 && percentile <= 100) continue;
            throw new OperatorException("Percentile '" + percentile + "' outside of interval [0..100].");
        }
    }

    static boolean isProductAlreadyOpened(List<Product> products, File file) {
        for (Product product : products) {
            if (!product.getFileLocation().getAbsolutePath().equals(file.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    private void logReadProductError(String file) {
        this.getLogger().severe(String.format("Failed to read from '%s' (not a data product or reader missing)", file));
    }

    private void setDummyTargetProduct() {
        Product product = new Product("dummy", "dummy", 2, 2);
        product.addBand("dummy", 10);
        this.setTargetProduct(product);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(StatisticsOp.class);
        }
    }

    public static class UtcConverter
    implements Converter<ProductData.UTC> {
        public ProductData.UTC parse(String text) throws ConversionException {
            try {
                return ProductData.UTC.parse((String)text, (String)StatisticsOp.DATETIME_PATTERN);
            }
            catch (ParseException e) {
                throw new ConversionException((Throwable)e);
            }
        }

        public String format(ProductData.UTC value) {
            if (value != null) {
                return value.format();
            }
            return "";
        }

        public Class<ProductData.UTC> getValueType() {
            return ProductData.UTC.class;
        }
    }
}

