/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.media.jai.Histogram;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.HistogramStxOp;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.QualitativeStxOp;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.StxFactory;
import org.esa.snap.core.datamodel.StxOp;
import org.esa.snap.core.datamodel.SummaryStxOp;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.util.FeatureUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.statistics.BandConfiguration;
import org.esa.snap.statistics.HistogramExpanderTransmitter;
import org.esa.snap.statistics.output.Util;
import org.esa.snap.statistics.tools.TimeInterval;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class StatisticComputer {
    private final FeatureCollection<SimpleFeatureType, SimpleFeature> features;
    private final FeatureUtils.FeatureCrsProvider crsProvider;
    private final ProgressMonitor pm;
    private final BandConfiguration[] bandConfigurations;
    private final Map<BandConfiguration, StxOpMapping>[] stxOpMappingsList;
    private final int initialBinCount;
    private final Logger logger;
    private final TimeInterval[] timeIntervals;

    public StatisticComputer(File shapefile, BandConfiguration[] bandConfigurations, int initialBinCount, Logger logger) {
        this(shapefile, bandConfigurations, initialBinCount, new TimeInterval[]{new TimeInterval(0, new ProductData.UTC(0.0), new ProductData.UTC(1000000.0))}, logger);
    }

    public StatisticComputer(File shapefile, BandConfiguration[] bandConfigurations, int initialBinCount, TimeInterval[] timeIntervals, Logger logger) {
        this.initialBinCount = initialBinCount;
        this.timeIntervals = timeIntervals;
        Logger logger2 = this.logger = logger != null ? logger : SystemUtils.LOG;
        if (shapefile != null) {
            try {
                this.features = FeatureUtils.loadFeatureCollectionFromShapefile((File)shapefile);
            }
            catch (IOException e) {
                throw new OperatorException("Unable to load shapefile '" + shapefile.getAbsolutePath() + "'", (Throwable)e);
            }
        } else {
            this.features = null;
        }
        this.crsProvider = new FeatureUtils.FeatureCrsProvider(){

            public CoordinateReferenceSystem getFeatureCrs(Product targetProduct) {
                if (targetProduct.getSceneCRS() == Product.DEFAULT_IMAGE_CRS) {
                    return Product.DEFAULT_IMAGE_CRS;
                }
                return DefaultGeographicCRS.WGS84;
            }

            public boolean clipToProductBounds() {
                return true;
            }
        };
        this.pm = ProgressMonitor.NULL;
        this.bandConfigurations = bandConfigurations;
        this.stxOpMappingsList = new Map[Math.max(1, timeIntervals.length)];
        for (int i = 0; i < this.stxOpMappingsList.length; ++i) {
            this.stxOpMappingsList[i] = new HashMap<BandConfiguration, StxOpMapping>();
        }
    }

    int getIntervalIndex(Product product) {
        if (product.getEndTime() == null) {
            return 0;
        }
        if (this.timeIntervals.length == 0) {
            return 0;
        }
        Date productStart = product.getStartTime().getAsDate();
        Date productEnd = product.getEndTime().getAsDate();
        if (productStart.before(this.timeIntervals[0].getIntervalStart().getAsDate()) || productEnd.after(this.timeIntervals[this.timeIntervals.length - 1].getIntervalEnd().getAsDate())) {
            return -1;
        }
        for (int i = 0; i < this.timeIntervals.length - 1; ++i) {
            if (productStart.after(this.timeIntervals[i].getIntervalStart().getAsDate()) && productEnd.before(this.timeIntervals[i].getIntervalEnd().getAsDate())) {
                return i;
            }
            if (!productStart.after(this.timeIntervals[i].getIntervalStart().getAsDate()) || !productStart.before(this.timeIntervals[i + 1].getIntervalStart().getAsDate()) || !productEnd.before(this.timeIntervals[i + 1].getIntervalEnd().getAsDate())) continue;
            return i;
        }
        return this.timeIntervals.length - 1;
    }

    public void computeStatistic(Product product) {
        int intervalIndex = this.getIntervalIndex(product);
        VectorDataNode[] vectorDataNodes = null;
        if (this.features != null) {
            DefaultFeatureCollection productFeatures = FeatureUtils.clipFeatureCollectionToProductBounds(this.features, (Product)product, (FeatureUtils.FeatureCrsProvider)this.crsProvider, (ProgressMonitor)this.pm);
            VectorDataNode[] vectorDataNodeArray = vectorDataNodes = this.createVectorDataNodes((FeatureCollection<SimpleFeatureType, SimpleFeature>)productFeatures);
            int n = vectorDataNodeArray.length;
            for (int i = 0; i < n; ++i) {
                VectorDataNode vectorDataNode = vectorDataNodeArray[i];
                product.getVectorDataGroup().add((ProductNode)vectorDataNode);
            }
        }
        for (BandConfiguration bandConfiguration : this.bandConfigurations) {
            Band band = StatisticComputer.getBand(bandConfiguration, product);
            String newExpression = bandConfiguration.validPixelExpression;
            if (newExpression != null) {
                String oldExpression = band.getValidPixelExpression();
                if (oldExpression != null) {
                    this.logger.info("Replaced old valid pixel expression '" + oldExpression + "' by '" + newExpression + "'.");
                }
                band.setValidPixelExpression(newExpression);
            }
            StxOpMapping stxOpsMapping = this.getStxOpsMapping(intervalIndex, bandConfiguration);
            if (this.features != null) {
                for (VectorDataNode vectorDataNode : vectorDataNodes) {
                    String vdnName = vectorDataNode.getName();
                    Mask currentMask = (Mask)product.getMaskGroup().get(vdnName);
                    Shape roiShape = currentMask.getValidShape();
                    MultiLevelImage roiImage = currentMask.getSourceImage();
                    this.computeStatistic(vdnName, stxOpsMapping, band, bandConfiguration.retrieveCategoricalStatistics, roiShape, roiImage);
                }
                continue;
            }
            this.computeStatistic("world", stxOpsMapping, band, bandConfiguration.retrieveCategoricalStatistics, null, null);
        }
    }

    private void computeStatistic(String regionName, StxOpMapping stxOpsMapping, Band band, boolean retrieveCategoricalStatistics, Shape roiShape, MultiLevelImage roiImage) {
        if (retrieveCategoricalStatistics && StatisticComputer.isIntegerBand(band)) {
            QualitativeStxOp qualitativeStxOp = stxOpsMapping.getQualitativeStxOp(regionName, band);
            StxFactory.accumulate((RasterDataNode)band, (int)0, (RenderedImage)roiImage, (Shape)roiShape, (StxOp)qualitativeStxOp, (ProgressMonitor)SubProgressMonitor.create((ProgressMonitor)this.pm, (int)50));
        } else {
            SummaryStxOp summaryStxOp = stxOpsMapping.getSummaryOp(regionName);
            StxFactory.accumulate((RasterDataNode)band, (int)0, (RenderedImage)roiImage, (Shape)roiShape, (StxOp)summaryStxOp, (ProgressMonitor)SubProgressMonitor.create((ProgressMonitor)this.pm, (int)50));
            double minimum = summaryStxOp.getMinimum();
            double maximum = summaryStxOp.getMaximum();
            HistogramStxOp histogramStxOp = stxOpsMapping.getHistogramOp(regionName, minimum, maximum, band);
            StxFactory.accumulate((RasterDataNode)band, (int)0, (RenderedImage)roiImage, (Shape)roiShape, (StxOp)histogramStxOp, (ProgressMonitor)SubProgressMonitor.create((ProgressMonitor)this.pm, (int)50));
        }
    }

    private StxOpMapping getStxOpsMapping(int intervalIndex, BandConfiguration bandConfiguration) {
        StxOpMapping stxOpMapping = this.stxOpMappingsList[intervalIndex].get(bandConfiguration);
        if (stxOpMapping == null) {
            stxOpMapping = new StxOpMapping(this.initialBinCount);
            this.stxOpMappingsList[intervalIndex].put(bandConfiguration, stxOpMapping);
        }
        return stxOpMapping;
    }

    private VectorDataNode[] createVectorDataNodes(FeatureCollection<SimpleFeatureType, SimpleFeature> productFeatures) {
        FeatureIterator featureIterator = productFeatures.features();
        ArrayList<VectorDataNode> result = new ArrayList<VectorDataNode>();
        while (featureIterator.hasNext()) {
            SimpleFeature simpleFeature = (SimpleFeature)featureIterator.next();
            DefaultFeatureCollection fc = new DefaultFeatureCollection(simpleFeature.getID(), simpleFeature.getFeatureType());
            fc.add(simpleFeature);
            String name = Util.getFeatureName(simpleFeature);
            result.add(new VectorDataNode(name, (FeatureCollection)fc));
        }
        return result.toArray(new VectorDataNode[result.size()]);
    }

    static Band getBand(BandConfiguration configuration, Product product) {
        Band band;
        if (configuration.sourceBandName != null) {
            band = product.getBand(configuration.sourceBandName);
            band.setNoDataValueUsed(true);
        } else {
            band = product.addBand(configuration.expression.replace(" ", "_"), configuration.expression, 31);
        }
        if (band == null) {
            throw new OperatorException(MessageFormat.format("Band ''{0}'' does not exist in product ''{1}''.", configuration.sourceBandName, product.getName()));
        }
        return band;
    }

    public Map<BandConfiguration, StxOpMapping> getResults() {
        return this.getResults(0);
    }

    Map<BandConfiguration, StxOpMapping>[] getResultList() {
        return this.stxOpMappingsList;
    }

    Map<BandConfiguration, StxOpMapping> getResults(int intervalIndex) {
        return this.stxOpMappingsList[intervalIndex];
    }

    private static boolean isIntegerBand(Band band) {
        return band.getGeophysicalImage().getSampleModel().getDataType() < 4;
    }

    static class StxOpMapping {
        final Map<String, SummaryStxOp> summaryMap = new HashMap<String, SummaryStxOp>();
        final Map<String, HistogramStxOp> histogramMap = new HashMap<String, HistogramStxOp>();
        private final int initialBinCount;
        final Map<String, QualitativeStxOp> qualitativeMap;

        StxOpMapping(int initialBinCount) {
            this.initialBinCount = initialBinCount;
            this.qualitativeMap = new HashMap<String, QualitativeStxOp>();
        }

        private QualitativeStxOp getQualitativeStxOp(String vdnName, Band band) {
            QualitativeStxOp qualitativeStxOp = this.qualitativeMap.get(vdnName);
            if (qualitativeStxOp == null) {
                qualitativeStxOp = new QualitativeStxOp();
                this.qualitativeMap.put(vdnName, qualitativeStxOp);
            }
            qualitativeStxOp.determineClassCounterType(band);
            return qualitativeStxOp;
        }

        private SummaryStxOp getSummaryOp(String vdnName) {
            SummaryStxOp summaryStxOp = this.summaryMap.get(vdnName);
            if (summaryStxOp == null) {
                summaryStxOp = new SummaryStxOp();
                this.summaryMap.put(vdnName, summaryStxOp);
            }
            return summaryStxOp;
        }

        private HistogramStxOp getHistogramOp(String vdnName, double minimum, double maximum, Band band) {
            HistogramStxOp histogramStxOp = this.histogramMap.get(vdnName);
            boolean intHistogram = StatisticComputer.isIntegerBand(band);
            if (histogramStxOp == null) {
                histogramStxOp = new HistogramStxOp(this.initialBinCount, minimum, maximum, intHistogram, false);
                this.histogramMap.put(vdnName, histogramStxOp);
            } else {
                Histogram oldHistogram = histogramStxOp.getHistogram();
                double oldMin = oldHistogram.getLowValue()[0];
                double oldMax = oldHistogram.getHighValue()[0];
                if (minimum < oldMin || maximum > oldMax) {
                    histogramStxOp = HistogramExpanderTransmitter.createExpandedHistogramOp(oldHistogram, minimum, maximum, intHistogram, this.initialBinCount);
                    this.histogramMap.put(vdnName, histogramStxOp);
                }
            }
            return histogramStxOp;
        }
    }
}

