/*
 * Decompiled with CFR 0.152.
 */
package com.bc.jnn.nnio;

import com.bc.jnn.JnnException;
import com.bc.jnn.nnio.JnnParseException;
import com.bc.jnn.nnio.NnaParserHandler;
import com.bc.jnn.nnio.NnaTokenizer;
import java.io.IOException;
import java.io.Reader;

public class NnaParser {
    private static final String KW_NET = "Net";
    private static final String KW_LAYER = "Layer";
    private static final String KW_UNIT = "Unit";
    private static final String KW_CONNECTION = "C";
    private NnaTokenizer tokenizer;
    private NnaParserHandler handler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Reader reader, NnaParserHandler handler) throws IOException, JnnException {
        this.tokenizer = new NnaTokenizer(reader);
        this.handler = handler != null ? handler : new NullHandler();
        try {
            this.parse();
        }
        finally {
            this.tokenizer = null;
            this.handler = null;
        }
    }

    private void parse() throws IOException, JnnException {
        this.parseNet();
        this.parseLayersAndUnits();
        this.parseZeroOrMoreEols();
        this.parseEof();
    }

    private void parseNet() throws IOException, JnnException {
        this.parseZeroOrMoreEols();
        this.parseCharacter('[');
        this.parseKeyword(KW_NET);
        this.parseCharacter(']');
        this.parseEolOrEof();
        this.handler.handleNetStart();
        this.parseNetEntries();
        this.handler.handleNetEnd();
    }

    private void parseLayersAndUnits() throws IOException, JnnException {
        while (true) {
            this.parseZeroOrMoreEols();
            if (this.tokenizer.isEof()) break;
            this.parseLayerOrUnit();
        }
    }

    private void parseLayerOrUnit() throws IOException, JnnException {
        this.parseCharacter('[');
        String s = this.parseKeyword();
        if (s.equalsIgnoreCase(KW_LAYER)) {
            this.parseCharacter('(');
            int layerIndex = this.parseIndex("layer index");
            this.parseCharacter(')');
            this.parseCharacter(']');
            this.parseEolOrEof();
            this.handler.handleLayerStart(layerIndex - 1);
            this.parseLayerEntries();
            this.handler.handleLayerEnd();
        } else if (s.equals(KW_UNIT)) {
            this.parseCharacter('(');
            int layerIndex = this.parseIndex("layer index");
            this.parseCharacter(',');
            int unitIndex = this.parseIndex("unit index");
            this.parseCharacter(')');
            this.parseCharacter(']');
            this.parseEolOrEof();
            this.handler.handleUnitStart(layerIndex - 1, unitIndex - 1);
            this.parseUnitEntries();
            this.handler.handleUnitEnd();
        } else {
            this.tokenizer.pushBackToken();
            throw new JnnParseException(this.createUnexpectedTokenMessage("'Layer' or 'Unit'"));
        }
    }

    private void parseNetEntries() throws IOException, JnnException {
        this.parseZeroOrMoreEols();
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.isKeyword()) {
                String key = this.tokenizer.getKeyword();
                this.parseCharacter('=');
                this.tokenizer.nextToken();
                if (this.tokenizer.isKeyword()) {
                    String value = this.tokenizer.getKeyword();
                    this.parseEolOrEof();
                    this.handler.handleNetEntry(key, value);
                    continue;
                }
                double value = this.tokenizer.getNumber();
                this.parseEolOrEof();
                this.handler.handleNetEntry(key, value);
                continue;
            }
            if (!this.tokenizer.isEol()) break;
        }
        this.tokenizer.pushBackToken();
    }

    private void parseLayerEntries() throws IOException, JnnException {
        this.parseZeroOrMoreEols();
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.isKeyword()) {
                String key = this.tokenizer.getKeyword();
                this.parseCharacter('=');
                this.tokenizer.nextToken();
                if (this.tokenizer.isKeyword()) {
                    String value = this.tokenizer.getKeyword();
                    this.parseEolOrEof();
                    this.handler.handleLayerEntry(key, value);
                    continue;
                }
                double value = this.tokenizer.getNumber();
                this.parseEolOrEof();
                this.handler.handleLayerEntry(key, value);
                continue;
            }
            if (!this.tokenizer.isEol()) break;
        }
        this.tokenizer.pushBackToken();
    }

    private void parseUnitEntries() throws IOException, JnnException {
        this.parseZeroOrMoreEols();
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.isKeyword()) {
                String key = this.tokenizer.getKeyword();
                if (key.equalsIgnoreCase(KW_CONNECTION)) {
                    this.parseCharacter('(');
                    int connIndex = this.parseIndex("connection index");
                    this.parseCharacter(')');
                    this.parseCharacter('=');
                    int connLayerIndex = this.parseIndex("connected layer index");
                    this.parseCharacter(',');
                    int connUnitIndex = this.parseIndex("connected unit index");
                    this.parseCharacter(',');
                    double weight = this.parseNumber("connection weight");
                    this.parseEolOrEof();
                    this.handler.handleUnitConnection(connIndex - 1, connLayerIndex - 1, connUnitIndex - 1, weight);
                    continue;
                }
                this.parseCharacter('=');
                this.tokenizer.nextToken();
                if (this.tokenizer.isKeyword()) {
                    String value = this.tokenizer.getKeyword();
                    this.parseEolOrEof();
                    this.handler.handleUnitEntry(key, value);
                    continue;
                }
                double value = this.tokenizer.getNumber();
                this.parseEolOrEof();
                this.handler.handleUnitEntry(key, value);
                continue;
            }
            if (!this.tokenizer.isEol()) break;
        }
        this.tokenizer.pushBackToken();
    }

    private String parseKeyword() throws IOException, JnnException {
        this.tokenizer.nextToken();
        if (!this.tokenizer.isKeyword()) {
            this.tokenizer.pushBackToken();
            throw new JnnParseException(this.createUnexpectedTokenMessage("keyword"));
        }
        return this.tokenizer.getKeyword();
    }

    private int parseIndex(String type) throws IOException, JnnException {
        this.tokenizer.nextToken();
        if (!this.tokenizer.isNumber()) {
            this.tokenizer.pushBackToken();
            throw new JnnParseException(this.createUnexpectedTokenMessage(type));
        }
        int index = new Double(this.tokenizer.getNumber()).intValue();
        return index;
    }

    private double parseNumber(String type) throws IOException, JnnException {
        this.tokenizer.nextToken();
        if (!this.tokenizer.isNumber()) {
            this.tokenizer.pushBackToken();
            throw new JnnParseException(this.createUnexpectedTokenMessage(type));
        }
        return this.tokenizer.getNumber();
    }

    private void parseCharacter(char character) throws IOException, JnnException {
        this.tokenizer.nextToken();
        if (!this.tokenizer.isCharacter() || this.tokenizer.getCharacter() != character) {
            this.tokenizer.pushBackToken();
            throw new JnnParseException(this.createUnexpectedTokenMessage("'" + character + "'"));
        }
    }

    private void parseKeyword(String keyword) throws IOException, JnnException {
        this.tokenizer.nextToken();
        if (!this.tokenizer.isKeyword() || !keyword.equalsIgnoreCase(this.tokenizer.getKeyword())) {
            this.tokenizer.pushBackToken();
            throw new JnnParseException(this.createUnexpectedTokenMessage("'" + keyword + "'"));
        }
    }

    private void parseEof() throws IOException, JnnException {
        this.tokenizer.nextToken();
        if (!this.tokenizer.isEof()) {
            this.tokenizer.pushBackToken();
            throw new JnnParseException(this.createUnexpectedTokenMessage("end of file"));
        }
    }

    private void parseEolOrEof() throws IOException, JnnException {
        this.tokenizer.nextToken();
        if (!this.tokenizer.isEol() && !this.tokenizer.isEof()) {
            this.tokenizer.pushBackToken();
            throw new JnnParseException(this.createUnexpectedTokenMessage("end of line"));
        }
    }

    private void parseZeroOrMoreEols() throws IOException {
        do {
            this.tokenizer.nextToken();
        } while (this.tokenizer.isEol());
        this.tokenizer.pushBackToken();
    }

    private String createUnexpectedTokenMessage(String type) {
        StringBuffer sb = new StringBuffer(32);
        sb.append("line ");
        sb.append(this.tokenizer.getLineNumber());
        sb.append(": ");
        sb.append(type);
        sb.append(" expected, but found ");
        if (this.tokenizer.isEof()) {
            sb.append("end of file");
        } else if (this.tokenizer.isEol()) {
            sb.append("end of line");
        } else if (this.tokenizer.isKeyword()) {
            sb.append("keyword '");
            sb.append(this.tokenizer.getKeyword());
            sb.append("'");
        } else if (this.tokenizer.isNumber()) {
            sb.append("number '");
            sb.append(this.tokenizer.getNumber());
            sb.append("'");
        } else if (this.tokenizer.isCharacter()) {
            sb.append("character '");
            sb.append(this.tokenizer.getCharacter());
            sb.append("'");
        } else {
            sb.append("nothing");
        }
        return sb.toString();
    }

    private class NullHandler
    implements NnaParserHandler {
        private NullHandler() {
        }

        @Override
        public void handleNetStart() {
        }

        @Override
        public void handleNetEntry(String key, String value) {
        }

        @Override
        public void handleNetEntry(String key, double value) {
        }

        @Override
        public void handleNetEnd() {
        }

        @Override
        public void handleLayerStart(int layerIndex) {
        }

        @Override
        public void handleLayerEntry(String key, String value) {
        }

        @Override
        public void handleLayerEntry(String key, double value) {
        }

        @Override
        public void handleLayerEnd() {
        }

        @Override
        public void handleUnitStart(int layerIndex, int unitIndex) {
        }

        @Override
        public void handleUnitEntry(String key, String value) {
        }

        @Override
        public void handleUnitEntry(String key, double value) {
        }

        @Override
        public void handleUnitConnection(int connIndex, int connLayerIndex, int connUnitIndex, double weight) {
        }

        @Override
        public void handleUnitEnd() {
        }
    }
}

