/*
 * Decompiled with CFR 0.152.
 */
package com.bc.jnn.nnio;

import com.bc.jnn.JnnConnection;
import com.bc.jnn.JnnException;
import com.bc.jnn.JnnLayer;
import com.bc.jnn.JnnNet;
import com.bc.jnn.JnnUnit;
import com.bc.jnn.nnio.NnaDef;
import com.bc.jnn.nnio.NnaParserHandler;

public class NnaNetBuilder
implements NnaParserHandler {
    private JnnNet currentNet;
    private JnnLayer currentLayer;
    private JnnUnit currentUnit;

    public JnnNet getCurrentNet() {
        return this.currentNet;
    }

    @Override
    public void handleNetStart() {
        this.currentNet = new JnnNet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleNetEntry(String key, String value) throws JnnException {
        if (!key.equalsIgnoreCase("Precision")) throw new JnnException("Invalid net section entry: '" + key + " = " + value + "'.");
        if (NnaDef.NN_NAME_PRECISION_VALUE_SET[0].equalsIgnoreCase(value)) {
            this.currentNet.setPrecision(4);
            return;
        } else {
            if (!NnaDef.NN_NAME_PRECISION_VALUE_SET[1].equalsIgnoreCase(value)) throw new JnnException("Invalid net section entry: '" + key + " = " + value + "'.");
            this.currentNet.setPrecision(8);
        }
    }

    @Override
    public void handleNetEntry(String key, double value) throws JnnException {
        if (key.equalsIgnoreCase("MinVersion")) {
            this.currentNet.setVersionMinor((int)value);
        } else if (key.equalsIgnoreCase("MajVersion")) {
            this.currentNet.setVersionMajor((int)value);
        } else if (key.equalsIgnoreCase("NumLayers")) {
            this.currentNet.setNumLayers((int)value);
        } else if (key.equalsIgnoreCase("InpLayer")) {
            this.currentNet.setInputLayerIndex((int)value - 1);
        } else if (key.equalsIgnoreCase("OutLayer")) {
            this.currentNet.setOutputLayerIndex((int)value - 1);
        } else {
            throw new JnnException("Invalid net section entry: '" + key + " = " + value + "'.");
        }
    }

    @Override
    public void handleNetEnd() throws JnnException {
    }

    @Override
    public void handleLayerStart(int layerIndex) throws JnnException {
        this.currentLayer = new JnnLayer();
        this.currentNet.setLayerAt(layerIndex, this.currentLayer);
    }

    @Override
    public void handleLayerEntry(String key, String value) throws JnnException {
        if (key.equalsIgnoreCase("InpFunc")) {
            this.currentLayer.setInputFunction(NnaDef.functionNameToIndex(value));
        } else if (key.equalsIgnoreCase("ActFunc")) {
            this.currentLayer.setActivationFunction(NnaDef.functionNameToIndex(value));
        } else if (key.equalsIgnoreCase("OutFunc")) {
            this.currentLayer.setOutputFunction(NnaDef.functionNameToIndex(value));
        } else {
            throw new JnnException("Invalid layer section entry: '" + key + " = " + value + "'.");
        }
    }

    @Override
    public void handleLayerEntry(String key, double value) throws JnnException {
        if (key.equalsIgnoreCase("NumUnits")) {
            this.currentLayer.setNumUnits((int)value);
        } else if (key.equalsIgnoreCase("ActThres")) {
            this.currentLayer.setActivationThreshold(value);
        } else if (key.equalsIgnoreCase("ActSlope")) {
            this.currentLayer.setActivationSlope(value);
        } else {
            throw new JnnException("Invalid layer section entry: '" + key + " = " + value + "'.");
        }
    }

    @Override
    public void handleLayerEnd() throws JnnException {
        this.currentLayer = null;
    }

    @Override
    public void handleUnitStart(int layerIndex, int unitIndex) throws JnnException {
        this.currentUnit = new JnnUnit();
        JnnLayer layer = this.currentNet.getLayerAt(layerIndex);
        if (layer == null) {
            throw new JnnException("[Unit(" + layerIndex + "," + unitIndex + "]: Illegal layer index '" + layerIndex + "'.");
        }
        layer.setUnitAt(unitIndex, this.currentUnit);
    }

    @Override
    public void handleUnitEntry(String key, String value) throws JnnException {
        throw new JnnException("Invalid unit section entry: '" + key + " = " + value + "'.");
    }

    @Override
    public void handleUnitEntry(String key, double value) throws JnnException {
        if (key.equalsIgnoreCase("NumConns")) {
            this.currentUnit.setNumConnections((int)value);
        } else if (key.equalsIgnoreCase("InpScale")) {
            this.currentUnit.setInputScale(value);
        } else if (key.equalsIgnoreCase("InpBias")) {
            this.currentUnit.setInputBias(value);
        } else if (key.equalsIgnoreCase("OutScale")) {
            this.currentUnit.setOutputScale(value);
        } else if (key.equalsIgnoreCase("OutBias")) {
            this.currentUnit.setOutputBias(value);
        } else {
            throw new JnnException("Invalid unit section entry: '" + key + " = " + value + "'.");
        }
    }

    @Override
    public void handleUnitConnection(int connIndex, int layerIndex, int unitIndex, double weight) throws JnnException {
        JnnConnection connection = new JnnConnection();
        connection.setSourceLayerIndex(layerIndex);
        connection.setSourceUnitIndex(unitIndex);
        connection.setWeight(weight);
        this.currentUnit.setConnectionAt(connIndex, connection);
    }

    @Override
    public void handleUnitEnd() throws JnnException {
        this.currentUnit = null;
    }
}

