/*
 * Decompiled with CFR 0.152.
 */
package com.bc.jnn;

import com.bc.jnn.JnnConnection;
import java.text.MessageFormat;

public final class JnnUnit
implements Cloneable {
    private int numConns = 0;
    private double input = 0.0;
    private double activation;
    private double output;
    private double inpScale = 1.0;
    private double inpBias = 0.0;
    private double outScale = 1.0;
    private double outBias = 0.0;
    private JnnConnection[] connections;

    public int getNumConnections() {
        return this.numConns;
    }

    public void setNumConnections(int numConns) {
        this.numConns = numConns;
        if (this.connections == null || numConns != this.connections.length) {
            this.connections = new JnnConnection[numConns];
        }
    }

    public double getInputScale() {
        return this.inpScale;
    }

    public void setInputScale(double inpScale) {
        this.inpScale = inpScale;
    }

    public double getInputBias() {
        return this.inpBias;
    }

    public void setInputBias(double inpBias) {
        this.inpBias = inpBias;
    }

    public double getOutputScale() {
        return this.outScale;
    }

    public void setOutputScale(double outScale) {
        this.outScale = outScale;
    }

    public double getOutputBias() {
        return this.outBias;
    }

    public void setOutputBias(double outBias) {
        this.outBias = outBias;
    }

    public double getInput() {
        return this.input;
    }

    public void setInput(double input) {
        this.input = input;
    }

    public double getOutput() {
        return this.output;
    }

    public void setActivation(double activation) {
        this.activation = activation;
    }

    public double getActivation() {
        return this.activation;
    }

    public void setOutput(double output) {
        this.output = output;
    }

    public void setConnectionAt(int index, JnnConnection connection) {
        this.connections[index] = connection;
    }

    public JnnConnection getConnectionAt(int index) {
        return this.connections[index];
    }

    public boolean verifyIntegrity() {
        return this.verifyIntegrity(new StringBuffer());
    }

    public boolean verifyIntegrity(StringBuffer msg) {
        if (this.numConns < 0) {
            msg.append(MessageFormat.format("Invalid number of connections ''{0}'' (should be >= 0)", this.numConns));
            return false;
        }
        if (this.numConns > 0 && this.connections == null) {
            msg.append("No connections defined");
            return false;
        }
        for (int i = 0; i < this.numConns; ++i) {
            if (this.connections[i] != null) continue;
            msg.append(MessageFormat.format("No connection at 0-based index: ''{0}''", i));
            return false;
        }
        return true;
    }

    public JnnUnit clone() {
        try {
            JnnUnit clonedUnit = (JnnUnit)super.clone();
            JnnConnection[] clonedConnections = (JnnConnection[])this.connections.clone();
            for (int i = 0; i < clonedConnections.length; ++i) {
                clonedConnections[i] = clonedConnections[i].clone();
            }
            clonedUnit.connections = clonedConnections;
            return clonedUnit;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

