/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.wizards;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.esa.snap.graphbuilder.rcp.actions.OperatorAction;
import org.esa.snap.graphbuilder.rcp.wizards.WizardDialog;
import org.esa.snap.graphbuilder.rcp.wizards.WizardPanel;
import org.esa.snap.rcp.SnapApp;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;

public class WizardAction
extends OperatorAction {
    protected static final Set<String> KNOWN_KEYS = new HashSet<String>(Arrays.asList("wizardPanelClass"));

    public String getWizardPanelClass() {
        return this.getPropertyString("wizardPanelClass");
    }

    public static OperatorAction create(Map<String, Object> properties) {
        WizardAction action = new WizardAction();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (!KNOWN_KEYS.contains(entry.getKey())) continue;
            action.putValue(entry.getKey(), entry.getValue());
        }
        return action;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            Class<?> wizardClass = WizardAction.getClass(this.getWizardPanelClass());
            WizardPanel wizardPanel = (WizardPanel)wizardClass.newInstance();
            WizardDialog dialog = new WizardDialog(SnapApp.getDefault().getMainFrame(), false, this.getDialogTitle(), this.getHelpId(), wizardPanel);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            SnapApp.getDefault().handleError("Unable to create wizard", (Throwable)e);
        }
    }

    private static Class<?> getClass(String className) {
        Collection modules = Lookup.getDefault().lookupAll(ModuleInfo.class);
        for (ModuleInfo module : modules) {
            if (!module.isEnabled()) continue;
            try {
                Class<?> implClass = module.getClassLoader().loadClass(className);
                if (!WizardPanel.class.isAssignableFrom(implClass)) continue;
                return implClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    static {
        KNOWN_KEYS.addAll(OperatorAction.KNOWN_KEYS);
    }
}

