/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.wizards;

import java.awt.Component;
import java.io.File;
import javax.swing.JPanel;
import org.esa.snap.graphbuilder.rcp.dialogs.ProductSetPanel;
import org.esa.snap.graphbuilder.rcp.dialogs.support.FileTable;
import org.esa.snap.graphbuilder.rcp.wizards.WizardPanel;
import org.esa.snap.rcp.SnapApp;

public abstract class AbstractMultipleInputPanel
extends WizardPanel {
    protected ProductSetPanel productSetPanel;

    public AbstractMultipleInputPanel() {
        super("Input");
        this.createPanel();
    }

    @Override
    public void returnFromLaterStep() {
    }

    @Override
    public boolean canRedisplayNextPanel() {
        return false;
    }

    @Override
    public boolean hasNextPanel() {
        return true;
    }

    @Override
    public boolean canFinish() {
        return false;
    }

    @Override
    public boolean validateInput() {
        File[] fileList = this.productSetPanel.getFileList();
        if (fileList.length == 0 || fileList.length == 1 && !fileList[0].exists()) {
            AbstractMultipleInputPanel.showErrorMsg("Please add some products to the table");
            return false;
        }
        return true;
    }

    @Override
    public abstract WizardPanel getNextPanel();

    protected String getInstructions() {
        return "Browse for input products with the Add button, use the Add All Open button to add every product opened or drag and drop products into the table.\nSpecify the target folder where the products will be written to.\n";
    }

    private void createPanel() {
        JPanel textPanel = AbstractMultipleInputPanel.createTextPanel("Instructions", this.getInstructions());
        this.add((Component)textPanel, "North");
        this.productSetPanel = new ProductSetPanel(SnapApp.getDefault().getAppContext(), null, new FileTable(), true, true);
        this.add((Component)this.productSetPanel, "Center");
    }
}

