/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.actions;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import org.esa.snap.core.gpf.ui.DefaultOperatorAction;
import org.esa.snap.graphbuilder.rcp.dialogs.SingleOperatorDialog;
import org.esa.snap.ui.ModelessDialog;
import org.esa.snap.ui.UIUtils;

public class OperatorAction
extends DefaultOperatorAction {
    public static ImageIcon esaIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/graphbuilder/icons/esa.png", OperatorAction.class);
    public static ImageIcon rstbIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/graphbuilder/icons/csa.png", OperatorAction.class);
    public static ImageIcon arrayIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/graphbuilder/icons/array_logo.png", OperatorAction.class);
    public static ImageIcon esaPlanetIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/graphbuilder/icons/esa-planet.png", OperatorAction.class);
    public static ImageIcon geoAusIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/graphbuilder/icons/geo_aus.png", OperatorAction.class);
    protected static final Set<String> KNOWN_KEYS = new HashSet<String>(Arrays.asList("displayName", "operatorName", "dialogTitle", "targetProductNameSuffix", "helpId", "icon"));
    private ModelessDialog dialog;

    public static OperatorAction create(Map<String, Object> properties) {
        OperatorAction action = new OperatorAction();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (!KNOWN_KEYS.contains(entry.getKey())) continue;
            action.putValue(entry.getKey(), entry.getValue());
        }
        return action;
    }

    public void actionPerformed(ActionEvent event) {
        ModelessDialog dialog = this.createOperatorDialog();
        dialog.show();
    }

    public String getPropertyString(String key) {
        Object value = this.getValue(key);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public String getIcon() {
        return this.getPropertyString("icon");
    }

    protected ModelessDialog createOperatorDialog() {
        this.setHelpId(this.getPropertyString("helpId"));
        SingleOperatorDialog productDialog = new SingleOperatorDialog(this.getOperatorName(), this.getAppContext(), this.getDialogTitle(), this.getHelpId());
        if (this.getTargetProductNameSuffix() != null) {
            productDialog.setTargetProductNameSuffix(this.getTargetProductNameSuffix());
        }
        this.addIcon((ModelessDialog)productDialog);
        return productDialog;
    }

    protected void addIcon(ModelessDialog dlg) {
        String iconName = this.getIcon();
        if (iconName != null) {
            if (iconName.equals("esaIcon")) {
                OperatorAction.setIcon(dlg, esaPlanetIcon);
            } else if (iconName.equals("rstbIcon")) {
                OperatorAction.setIcon(dlg, rstbIcon);
            } else if (iconName.equals("geoAusIcon")) {
                OperatorAction.setIcon(dlg, geoAusIcon);
            } else {
                ImageIcon icon = UIUtils.loadImageIcon((String)iconName, OperatorAction.class);
                if (icon != null) {
                    OperatorAction.setIcon(dlg, icon);
                }
            }
        }
    }

    private static void setIcon(ModelessDialog dlg, ImageIcon ico) {
        if (ico == null) {
            return;
        }
        dlg.getJDialog().setIconImage(ico.getImage());
    }
}

