/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.gpf.ui;

import java.io.File;
import java.util.Map;
import javax.swing.JComponent;
import org.esa.snap.core.gpf.ui.TargetProductSelector;
import org.esa.snap.core.gpf.ui.TargetProductSelectorModel;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.AppContext;

public class TargetUI
extends BaseOperatorUI {
    TargetProductSelector targetProductSelector = null;
    private static final String FILE_PARAMETER = "file";
    private static final String FORMAT_PARAMETER = "formatName";
    private static final String deafultFileName = "target";
    private String sourceProductName;
    private AppContext appContext;

    @Override
    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.paramMap = parameterMap;
        this.targetProductSelector = new TargetProductSelector(new TargetProductSelectorModel(), true);
        this.appContext = appContext;
        File saveDir = null;
        Object value = this.paramMap.get(FILE_PARAMETER);
        if (value != null) {
            File file = (File)value;
            saveDir = file.getParentFile();
        }
        if (saveDir == null) {
            String homeDirPath = SystemUtils.getUserHomeDir().getPath();
            String savePath = SnapApp.getDefault().getPreferences().get("last_product_save_dir", homeDirPath);
            saveDir = new File(savePath);
        }
        this.targetProductSelector.getModel().setProductDir(saveDir);
        this.initParameters();
        return this.targetProductSelector.createDefaultPanel();
    }

    @Override
    public void initParameters() {
        assert (this.paramMap != null);
        String fileName = this.getDefaultFileName();
        String format = "BEAM-DIMAP";
        Object formatValue = this.paramMap.get(FORMAT_PARAMETER);
        if (formatValue != null) {
            format = (String)formatValue;
        }
        if (fileName != null) {
            this.targetProductSelector.getProductNameTextField().setText(fileName);
            this.targetProductSelector.getModel().setProductName(fileName);
            this.targetProductSelector.getModel().setFormatName(format);
        }
    }

    private String getDefaultFileName() {
        String fileName = deafultFileName;
        Object fileValue = this.paramMap.get(FILE_PARAMETER);
        if (fileValue != null) {
            File file = (File)fileValue;
            fileName = FileUtils.getFilenameWithoutExtension((File)file);
        }
        if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            boolean sourceProductsChange = false;
            if (!this.sourceProducts[0].getName().equals(this.sourceProductName)) {
                if (this.sourceProductName != null) {
                    sourceProductsChange = true;
                }
                this.sourceProductName = this.sourceProducts[0].getName();
            }
            if (fileName.equals(deafultFileName) || sourceProductsChange) {
                fileName = this.sourceProducts[0].getName();
            }
        }
        return fileName;
    }

    @Override
    public UIValidation validateParameters() {
        String productName = this.targetProductSelector.getModel().getProductName();
        if (productName == null || productName.isEmpty()) {
            return new UIValidation(UIValidation.State.ERROR, "productName not specified");
        }
        File file = this.targetProductSelector.getModel().getProductFile();
        if (file == null) {
            return new UIValidation(UIValidation.State.ERROR, "Target file not specified");
        }
        String productDir = this.targetProductSelector.getModel().getProductDir().getAbsolutePath();
        SnapApp.getDefault().getPreferences().put("last_product_save_dir", productDir);
        return new UIValidation(UIValidation.State.OK, "");
    }

    @Override
    public void updateParameters() {
        if (this.targetProductSelector.getModel().getProductName() != null) {
            this.paramMap.put(FILE_PARAMETER, this.targetProductSelector.getModel().getProductFile());
            this.paramMap.put(FORMAT_PARAMETER, this.targetProductSelector.getModel().getFormatName());
        }
    }
}

