/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.dialogs;

import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.binding.validators.NotEmptyValidator;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.binding.PropertyEditor;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import com.bc.ceres.swing.binding.internal.TextFieldEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.table.TableColumn;
import org.esa.snap.core.gpf.descriptor.SystemDependentVariable;
import org.esa.snap.core.gpf.descriptor.SystemVariable;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.dependency.BundleInstaller;
import org.esa.snap.core.gpf.descriptor.dependency.BundleLocation;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.esa.snap.ui.tooladapter.dialogs.AbstractAdapterEditor;
import org.esa.snap.ui.tooladapter.dialogs.Bundle;
import org.esa.snap.ui.tooladapter.dialogs.BundleForm;
import org.esa.snap.ui.tooladapter.dialogs.ForwardFocusAction;
import org.esa.snap.ui.tooladapter.dialogs.components.AnchorLabel;
import org.esa.snap.ui.tooladapter.dialogs.progress.ProgressHandler;
import org.esa.snap.ui.tooladapter.model.OperationType;
import org.esa.snap.ui.tooladapter.validators.RegexFieldValidator;
import org.esa.snap.utils.SpringUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;

public class ToolAdapterTabbedEditorDialog
extends AbstractAdapterEditor {
    private static final String ALIAS_PATTERN = "[^\\\\\\?%\\*:\\|\"<>\\./]*";
    private JTabbedPane tabbedPane;
    private int currentIndex;

    ToolAdapterTabbedEditorDialog(AppContext appContext, JDialog parent, ToolAdapterOperatorDescriptor operatorDescriptor, OperationType operation) {
        super(appContext, parent, operatorDescriptor, operation);
    }

    ToolAdapterTabbedEditorDialog(AppContext appContext, JDialog parent, ToolAdapterOperatorDescriptor operatorDescriptor, int newNameIndex, OperationType operation) {
        super(appContext, parent, operatorDescriptor, newNameIndex, operation);
    }

    @Override
    protected JTabbedPane createMainPanel() {
        this.tabbedPane = new JTabbedPane(2);
        this.tabbedPane.setBorder(BorderFactory.createEmptyBorder());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double widthRatio = 0.5;
        this.formWidth = Math.max((int)((double)screenSize.width * widthRatio), 640);
        double heightRatio = 0.5;
        int formHeight = Math.max((int)((double)screenSize.height * heightRatio), 512);
        this.tabbedPane.setPreferredSize(new Dimension(this.formWidth, formHeight));
        this.getJDialog().setMinimumSize(new Dimension(this.formWidth + 16, formHeight + 72));
        this.addTab(this.tabbedPane, Bundle.CTL_Panel_OperatorDescriptor_Text(), this.createDescriptorTab());
        ++this.currentIndex;
        this.addTab(this.tabbedPane, Bundle.CTL_Panel_ConfigParams_Text(), this.createToolInfoPanel());
        ++this.currentIndex;
        this.addTab(this.tabbedPane, Bundle.CTL_Panel_PreProcessing_Border_TitleText(), this.createPreProcessingTab());
        ++this.currentIndex;
        this.addTab(this.tabbedPane, Bundle.CTL_Panel_OpParams_Border_TitleText(), this.createParametersTab(this.formWidth));
        ++this.currentIndex;
        this.addTab(this.tabbedPane, Bundle.CTL_Panel_SysVar_Border_TitleText(), this.createVariablesPanel());
        ++this.currentIndex;
        this.addTab(this.tabbedPane, Bundle.CTL_Panel_Bundle_TitleText(), this.createBundlePanel());
        ++this.currentIndex;
        this.tabbedPane.setUI(new BasicTabbedPaneUI());
        this.formWidth = this.tabbedPane.getTabComponentAt(0).getWidth();
        return this.tabbedPane;
    }

    @Override
    protected JPanel createDescriptorPanel() {
        JPanel descriptorPanel = new JPanel(new SpringLayout());
        TextFieldEditor textEditor = new TextFieldEditor();
        this.addValidatedTextField(descriptorPanel, textEditor, Bundle.CTL_Label_Alias_Text(), "alias", ALIAS_PATTERN);
        JComponent component = this.addTextField(descriptorPanel, textEditor, Bundle.CTL_Label_UniqueName_Text(), "name", true, new String[]{" "});
        this.anchorLabels.put("name", new AnchorLabel("Name is not unique", this.tabbedPane, this.currentIndex, component));
        this.addTextField(descriptorPanel, textEditor, Bundle.CTL_Label_Label_Text(), "label", true, null);
        this.addTextField(descriptorPanel, textEditor, Bundle.CTL_Label_Version_Text(), "version", true, new String[]{" ", "-", "+"});
        this.addTextField(descriptorPanel, textEditor, Bundle.CTL_Label_Copyright_Text(), "copyright", false, null);
        this.addTextField(descriptorPanel, textEditor, Bundle.CTL_Label_Authors_Text(), "authors", false, null);
        this.addTextField(descriptorPanel, textEditor, Bundle.CTL_Label_Description_Text(), "description", false, null);
        this.propertyContainer.addPropertyChangeListener("alias", evt -> this.propertyContainer.setValue("name", (Object)("org.esa.snap.core.gpf.operators.tooladapter." + evt.getNewValue().toString())));
        List<String> menus = this.getAvailableMenuOptions(null);
        this.addComboField(descriptorPanel, Bundle.CTL_Label_MenuLocation_Text(), "menuLocation", menus);
        this.addComboField(descriptorPanel, Bundle.CTL_Label_TemplateType_Text(), "templateType", true, false);
        SpringUtilities.makeCompactGrid(descriptorPanel, 9, 2, 2, 2, 2, 2);
        return descriptorPanel;
    }

    @Override
    protected JPanel createVariablesPanel() {
        JPanel variablesBorderPanel = new JPanel();
        BoxLayout layout = new BoxLayout(variablesBorderPanel, 3);
        variablesBorderPanel.setLayout(layout);
        AbstractButton addVariableButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)Bundle.Icon_Add()), (boolean)false);
        addVariableButton.setText(Bundle.CTL_Button_Add_Variable_Text());
        addVariableButton.setMaximumSize(new Dimension(150, this.controlHeight));
        addVariableButton.setAlignmentX(0.0f);
        AbstractButton addDependentVariableButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)Bundle.Icon_Add()), (boolean)false);
        addDependentVariableButton.setText(Bundle.CTL_Button_Add_PDVariable_Text());
        addDependentVariableButton.setMaximumSize(new Dimension(250, this.controlHeight));
        addDependentVariableButton.setAlignmentX(0.0f);
        JPanel buttonsPannel = new JPanel(new SpringLayout());
        buttonsPannel.add(addVariableButton);
        buttonsPannel.add(addDependentVariableButton);
        SpringUtilities.makeCompactGrid(buttonsPannel, 1, 2, 0, 0, 0, 0);
        buttonsPannel.setAlignmentX(0.0f);
        variablesBorderPanel.add(buttonsPannel);
        this.varTable.setAutoResizeMode(3);
        this.varTable.setRowHeight(this.controlHeight);
        int[] widths = new int[]{this.controlHeight, 3 * this.controlHeight, 10 * this.controlHeight};
        for (int i = 0; i < widths.length; ++i) {
            TableColumn column = this.varTable.getColumnModel().getColumn(i);
            column.setPreferredWidth(widths[i]);
            column.setWidth(widths[i]);
        }
        JScrollPane scrollPane = new JScrollPane(this.varTable);
        scrollPane.setAlignmentX(0.0f);
        variablesBorderPanel.add(scrollPane);
        variablesBorderPanel.setAlignmentX(0.0f);
        Dimension variablesPanelDimension = new Dimension((this.formWidth - 6) / 2 - 4, 130);
        variablesBorderPanel.setMinimumSize(variablesPanelDimension);
        variablesBorderPanel.setMaximumSize(variablesPanelDimension);
        variablesBorderPanel.setPreferredSize(variablesPanelDimension);
        addVariableButton.addActionListener(e -> {
            this.newOperatorDescriptor.getVariables().add(new SystemVariable("key", ""));
            this.varTable.revalidate();
        });
        addDependentVariableButton.addActionListener(e -> {
            this.newOperatorDescriptor.getVariables().add(new SystemDependentVariable("key", ""));
            this.varTable.revalidate();
        });
        return variablesBorderPanel;
    }

    @Override
    protected JPanel createPreProcessingPanel() {
        PropertyDescriptor propertyDescriptor = this.propertyContainer.getDescriptor("preprocessorExternalTool");
        PropertyEditor editor = PropertyEditorRegistry.getInstance().findPropertyEditor(propertyDescriptor);
        JComponent firstEditorComponent = editor.createEditorComponent(propertyDescriptor, this.bindingContext);
        firstEditorComponent.setMaximumSize(new Dimension(firstEditorComponent.getMaximumSize().width, this.controlHeight));
        firstEditorComponent.setPreferredSize(new Dimension(firstEditorComponent.getPreferredSize().width, this.controlHeight));
        propertyDescriptor = this.propertyContainer.getDescriptor("processingWriter");
        editor = PropertyEditorRegistry.getInstance().findPropertyEditor(propertyDescriptor);
        JComponent secondEditorComponent = editor.createEditorComponent(propertyDescriptor, this.bindingContext);
        secondEditorComponent.setMaximumSize(new Dimension(secondEditorComponent.getMaximumSize().width, this.controlHeight));
        secondEditorComponent.setPreferredSize(new Dimension(secondEditorComponent.getPreferredSize().width, this.controlHeight));
        JCheckBox checkBoxComponent = (JCheckBox)this.createCheckboxComponent("preprocessTool", firstEditorComponent, this.newOperatorDescriptor.getPreprocessTool());
        checkBoxComponent.setText(Bundle.CTL_Label_PreprocessingTool_Text());
        JCheckBox writeComponent = (JCheckBox)this.createCheckboxComponent("writeForProcessing", secondEditorComponent, this.newOperatorDescriptor.shouldWriteBeforeProcessing());
        writeComponent.setText(Bundle.CTL_Label_WriteBefore_Text());
        JPanel preProcessingPanel = new JPanel(new SpringLayout());
        preProcessingPanel.add(checkBoxComponent);
        preProcessingPanel.add(firstEditorComponent);
        preProcessingPanel.add(writeComponent);
        preProcessingPanel.add(secondEditorComponent);
        SpringUtilities.makeCompactGrid(preProcessingPanel, 2, 2, 2, 2, 2, 2);
        ToolAdapterTabbedEditorDialog.forwardFocusWhenTabKeyReleased(checkBoxComponent, firstEditorComponent);
        ToolAdapterTabbedEditorDialog.forwardFocusWhenTabKeyReleased(firstEditorComponent, writeComponent);
        ToolAdapterTabbedEditorDialog.forwardFocusWhenTabKeyReleased(writeComponent, secondEditorComponent);
        ToolAdapterTabbedEditorDialog.forwardFocusWhenTabKeyReleased(secondEditorComponent, this.tabbedPane);
        return preProcessingPanel;
    }

    @Override
    protected JPanel createToolInfoPanel() {
        JPanel configPanel = new JPanel(new SpringLayout());
        JPanel panelToolFiles = new JPanel(new SpringLayout());
        PropertyEditorRegistry editorRegistry = PropertyEditorRegistry.getInstance();
        PropertyDescriptor propertyDescriptor = this.propertyContainer.getDescriptor("mainToolFileLocation");
        propertyDescriptor.setValidator((Validator)new NotEmptyValidator());
        PropertyEditor editor = editorRegistry.findPropertyEditor(propertyDescriptor);
        JComponent editorComponent = editor.createEditorComponent(propertyDescriptor, this.bindingContext);
        editorComponent.setMaximumSize(new Dimension(editorComponent.getMaximumSize().width, this.controlHeight));
        editorComponent.setPreferredSize(new Dimension(editorComponent.getPreferredSize().width, this.controlHeight));
        org.esa.snap.utils.UIUtils.enableUndoRedo(editorComponent);
        JLabel jLabel = new JLabel(Bundle.CTL_Label_ToolLocation_Text());
        panelToolFiles.add(jLabel);
        jLabel.setLabelFor(editorComponent);
        panelToolFiles.add(editorComponent);
        this.anchorLabels.put("mainToolFileLocation", new AnchorLabel(Bundle.MSG_Inexistent_Tool_Path_Text(), this.tabbedPane, this.currentIndex, editorComponent));
        propertyDescriptor = this.propertyContainer.getDescriptor("workingDir");
        propertyDescriptor.setAttribute("directory", (Object)true);
        propertyDescriptor.setValidator((property, value) -> {
            if (value == null || value.toString().trim().isEmpty()) {
                throw new ValidationException(MessageFormat.format("Value for ''{0}'' must not be empty.", property.getDescriptor().getDisplayName()));
            }
        });
        editor = editorRegistry.findPropertyEditor(propertyDescriptor);
        editorComponent = editor.createEditorComponent(propertyDescriptor, this.bindingContext);
        editorComponent.setMaximumSize(new Dimension(editorComponent.getMaximumSize().width, this.controlHeight));
        editorComponent.setPreferredSize(new Dimension(editorComponent.getPreferredSize().width, this.controlHeight));
        org.esa.snap.utils.UIUtils.enableUndoRedo(editorComponent);
        jLabel = new JLabel(Bundle.CTL_Label_WorkDir_Text());
        panelToolFiles.add(jLabel);
        jLabel.setLabelFor(editorComponent);
        this.anchorLabels.put("workingDir", new AnchorLabel(Bundle.MSG_Inexistent_WorkDir_Text(), this.tabbedPane, this.currentIndex, editorComponent));
        panelToolFiles.add(editorComponent);
        SpringUtilities.makeCompactGrid(panelToolFiles, 2, 2, 2, 2, 2, 2);
        configPanel.add(panelToolFiles);
        JPanel checkPanel = new JPanel(new SpringLayout());
        propertyDescriptor = this.propertyContainer.getDescriptor("isHandlingOutputName");
        editor = editorRegistry.findPropertyEditor(propertyDescriptor);
        editorComponent = editor.createEditorComponent(propertyDescriptor, this.bindingContext);
        editorComponent.setMaximumSize(new Dimension(editorComponent.getMaximumSize().width, this.controlHeight));
        editorComponent.setPreferredSize(new Dimension(editorComponent.getPreferredSize().width, this.controlHeight));
        checkPanel.add(editorComponent);
        checkPanel.add(new JLabel("Tool produces the name of the output product"));
        SpringUtilities.makeCompactGrid(checkPanel, 1, 2, 2, 2, 2, 2);
        configPanel.add(checkPanel);
        JLabel label = new JLabel(Bundle.CTL_Label_CmdLineTemplate_Text());
        configPanel.add(label);
        JScrollPane scrollPane = new JScrollPane(this.createTemplateEditorField());
        configPanel.add(scrollPane);
        configPanel.add(this.createPatternsPanel());
        SpringUtilities.makeCompactGrid(configPanel, 5, 1, 2, 2, 2, 2);
        return configPanel;
    }

    @Override
    protected JPanel createPatternsPanel() {
        JPanel patternsPanel = new JPanel(new SpringLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(Bundle.CTL_Panel_OutputPattern_Border_TitleText());
        titledBorder.setTitleJustification(2);
        patternsPanel.setBorder(titledBorder);
        TextFieldEditor textEditor = new TextFieldEditor();
        this.addTextField(patternsPanel, textEditor, Bundle.CTL_Label_ProgressPattern(), "progressPattern", false, null);
        this.propertyContainer.getDescriptor("progressPattern").setValidator((Validator)new RegexFieldValidator());
        this.addTextField(patternsPanel, textEditor, Bundle.CTL_Label_StepPattern(), "stepPattern", false, null);
        this.propertyContainer.getDescriptor("stepPattern").setValidator((Validator)new RegexFieldValidator());
        this.addTextField(patternsPanel, textEditor, Bundle.CTL_Label_ErrorPattern(), "errorPattern", false, null);
        this.propertyContainer.getDescriptor("errorPattern").setValidator((Validator)new RegexFieldValidator());
        SpringUtilities.makeCompactGrid(patternsPanel, 3, 2, 2, 2, 2, 2);
        return patternsPanel;
    }

    @Override
    protected JPanel createParametersPanel() {
        JPanel paramsPanel = new JPanel();
        BoxLayout layout = new BoxLayout(paramsPanel, 3);
        paramsPanel.setLayout(layout);
        AbstractButton addParamBut = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)Bundle.Icon_Add()), (boolean)false);
        addParamBut.setText("New Parameter");
        addParamBut.setMaximumSize(new Dimension(150, this.controlHeight));
        addParamBut.setAlignmentX(0.0f);
        addParamBut.setAlignmentY(0.0f);
        paramsPanel.add(addParamBut);
        JScrollPane tableScrollPane = new JScrollPane(this.paramsTable);
        tableScrollPane.setAlignmentX(0.0f);
        paramsPanel.add(tableScrollPane);
        addParamBut.addActionListener(e -> this.paramsTable.addParameterToTable());
        return paramsPanel;
    }

    @Override
    protected JPanel createBundlePanel() {
        JPanel bundlePanel = new JPanel(new SpringLayout());
        int rows = 0;
        this.bundleForm = new BundleForm(this.context, this.newOperatorDescriptor.getWindowsBundle(), this.newOperatorDescriptor.getLinuxBundle(), this.newOperatorDescriptor.getMacosxBundle(), this.newOperatorDescriptor.getVariables());
        bundlePanel.add(this.bundleForm);
        ++rows;
        org.esa.snap.core.gpf.descriptor.dependency.Bundle currentBundle = this.newOperatorDescriptor.getBundle();
        JButton button = this.renderInstallButton(currentBundle, bundlePanel);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setMaximumSize(new Dimension(buttonPanel.getWidth(), this.controlHeight));
        buttonPanel.add((Component)button, "East");
        bundlePanel.add(buttonPanel);
        this.bundleForm.setPropertyChangeListener(evt -> {
            org.esa.snap.core.gpf.descriptor.dependency.Bundle bundle = (org.esa.snap.core.gpf.descriptor.dependency.Bundle)evt.getSource();
            button.setText((bundle.getLocation() == BundleLocation.REMOTE ? "Download and " : "") + "Install Now");
            button.setToolTipText(bundle.getLocation() == BundleLocation.REMOTE ? bundle.getDownloadURL() : (bundle.getSource() != null ? bundle.getSource().toString() : ""));
            button.setMaximumSize(button.getPreferredSize());
            button.setVisible(this.canInstall(bundle));
        });
        SpringUtilities.makeCompactGrid(bundlePanel, ++rows, 1, 2, 2, 2, 2);
        return bundlePanel;
    }

    private JButton renderInstallButton(org.esa.snap.core.gpf.descriptor.dependency.Bundle currentBundle, JPanel bundlePanel) {
        JButton installButton = new JButton(){

            @Override
            public void setText(String text) {
                super.setText(text);
                ToolAdapterTabbedEditorDialog.this.adjustDimension(this);
            }
        };
        installButton.setText((currentBundle.getLocation() == BundleLocation.REMOTE ? "Download and " : "") + "Install Now");
        installButton.setToolTipText(currentBundle.getLocation() == BundleLocation.REMOTE ? currentBundle.getDownloadURL() : (currentBundle.getSource() != null ? currentBundle.getSource().toString() : ""));
        installButton.setMaximumSize(installButton.getPreferredSize());
        installButton.addActionListener(e -> {
            this.newOperatorDescriptor.setBundles(this.bundleForm.applyChanges());
            org.esa.snap.core.gpf.descriptor.dependency.Bundle modifiedBundle = this.newOperatorDescriptor.getBundle();
            try (BundleInstaller installer = new BundleInstaller(this.newOperatorDescriptor);){
                ProgressHandle progressHandle = ProgressHandleFactory.createSystemHandle((String)"Installing bundle");
                installer.setProgressMonitor((ProgressMonitor)new ProgressHandler(progressHandle, false));
                installer.setCallback(() -> {
                    if (modifiedBundle.isInstalled()) {
                        Path path = this.newOperatorDescriptor.resolveVariables(modifiedBundle.getTargetLocation()).toPath().resolve(FileUtils.getFilenameWithoutExtension((String)modifiedBundle.getEntryPoint()));
                        SwingUtilities.invokeLater(() -> {
                            progressHandle.finish();
                            Dialogs.showInformation((String)String.format("Bundle was installed in location:\n%s", path));
                            installButton.setVisible(false);
                            bundlePanel.revalidate();
                        });
                        String updateVariable = modifiedBundle.getUpdateVariable();
                        if (updateVariable != null) {
                            Optional<SystemVariable> variable = this.newOperatorDescriptor.getVariables().stream().filter(v -> v.getKey().equals(updateVariable)).findFirst();
                            variable.ifPresent(systemVariable -> {
                                systemVariable.setShared(true);
                                systemVariable.setValue(path.toString());
                            });
                            this.varTable.revalidate();
                        }
                    } else {
                        SwingUtilities.invokeLater(() -> {
                            progressHandle.finish();
                            Dialogs.showInformation((String)"Bundle installation failed. \nPlease see the application log for details.");
                            bundlePanel.revalidate();
                        });
                    }
                    return null;
                });
                installButton.setVisible(false);
                installer.install(true);
            }
            catch (Exception ex) {
                this.logger.warning(ex.getMessage());
            }
        });
        this.downloadAction = () -> {
            this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() - 1);
            installButton.requestFocusInWindow();
            installButton.doClick();
            return null;
        };
        installButton.setVisible(this.canInstall(currentBundle));
        return installButton;
    }

    private boolean canInstall(org.esa.snap.core.gpf.descriptor.dependency.Bundle bundle) {
        return bundle != null && !bundle.isInstalled() && BundleInstaller.isBundleFileAvailable((org.esa.snap.core.gpf.descriptor.dependency.Bundle)bundle) && (BundleLocation.LOCAL.equals((Object)bundle.getLocation()) && bundle.getSource() != null || BundleLocation.REMOTE.equals((Object)bundle.getLocation()) && bundle.getDownloadURL() != null);
    }

    private JPanel createPreProcessingTab() {
        JPanel preprocessAndPatternsPanel = new JPanel(new SpringLayout());
        preprocessAndPatternsPanel.add(this.createPreProcessingPanel());
        SpringUtilities.makeCompactGrid(preprocessAndPatternsPanel, 1, 1, 2, 2, 2, 2);
        preprocessAndPatternsPanel.setMaximumSize(preprocessAndPatternsPanel.getSize());
        return preprocessAndPatternsPanel;
    }

    private JPanel createDescriptorTab() {
        JPanel jPanel = new JPanel(new SpringLayout());
        jPanel.add(this.createDescriptorPanel());
        SpringUtilities.makeCompactGrid(jPanel, 1, 1, 2, 2, 2, 2);
        jPanel.setMaximumSize(jPanel.getSize());
        return jPanel;
    }

    private JPanel createParametersTab(int width) {
        JPanel paramsPanel = this.createParametersPanel();
        int tableWidth = width - 4;
        int[] widths = new int[]{this.controlHeight, 5 * this.controlHeight, 5 * this.controlHeight, 3 * this.controlHeight, 3 * this.controlHeight, (int)((double)tableWidth * 0.3), 30};
        for (int i = 0; i < widths.length; ++i) {
            this.paramsTable.getColumnModel().getColumn(i).setPreferredWidth(widths[i]);
        }
        this.paramsTable.setRowHeight(this.controlHeight);
        return paramsPanel;
    }

    private void addTab(JTabbedPane tabControl, String title, JPanel content) {
        JLabel tabText = new JLabel(title, 2);
        tabText.setPreferredSize(new Dimension(6 * this.controlHeight, this.controlHeight));
        TitledBorder titledBorder = BorderFactory.createTitledBorder(title);
        titledBorder.setTitleJustification(2);
        content.setBorder(titledBorder);
        tabControl.addTab(null, content);
        tabControl.setTabComponentAt(tabControl.getTabCount() - 1, tabText);
    }

    private static void forwardFocusWhenTabKeyReleased(JComponent aSenderComponent, JComponent aReceiverComponent) {
        ForwardFocusAction forwardFocusAction = new ForwardFocusAction("TabKeyAction", aReceiverComponent);
        aSenderComponent.setFocusTraversalKeys(0, new HashSet());
        int modifiers = 0;
        int keyCode = 9;
        KeyStroke tabKeyReleased = KeyStroke.getKeyStroke(keyCode, modifiers, true);
        aSenderComponent.getInputMap(1).put(tabKeyReleased, forwardFocusAction.getName());
        aSenderComponent.getActionMap().put(forwardFocusAction.getName(), forwardFocusAction);
    }
}

