/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.actions;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class EscapeAction
extends AbstractAction {
    private static final String KEY_STROKE_AND_KEY = "ESCAPE";
    private static final KeyStroke ESCAPE_KEY_STROKE = KeyStroke.getKeyStroke("ESCAPE");
    private static EscapeAction instance = new EscapeAction();

    public static void register(JDialog dialog) {
        EscapeAction.register(dialog.getRootPane());
    }

    public static void register(JRootPane rootPane) {
        rootPane.getInputMap(1).put(ESCAPE_KEY_STROKE, KEY_STROKE_AND_KEY);
        rootPane.getActionMap().put(KEY_STROKE_AND_KEY, instance);
    }

    private EscapeAction() {
        super("Escape");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ActionListener escapeAction;
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        JComponent rootPane = (JComponent)component;
        if (!(rootPane instanceof JRootPane)) {
            rootPane = (JComponent)SwingUtilities.getAncestorOfClass(JRootPane.class, component);
        }
        if ((escapeAction = this.getEscapeAction(rootPane)) != null) {
            escapeAction.actionPerformed(null);
        } else {
            Window window = SwingUtilities.windowForComponent(component);
            if (window != null) {
                window.dispose();
            }
        }
    }

    private ActionListener getEscapeAction(JComponent rootPane) {
        InputMap im = rootPane.getInputMap(2);
        if (im == null || (im = im.getParent()) == null) {
            return null;
        }
        KeyStroke[] keys = im.keys();
        if (keys == null) {
            return null;
        }
        for (KeyStroke keyStroke : keys) {
            if (!((Object)keyStroke).equals(ESCAPE_KEY_STROKE)) continue;
            Object key = im.get(ESCAPE_KEY_STROKE);
            return rootPane.getActionMap().get(key);
        }
        return null;
    }
}

