/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product;

import com.bc.ceres.grender.Rendering;
import com.bc.ceres.swing.figure.AbstractPointFigure;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.Handle;
import com.bc.ceres.swing.figure.PointFigure;
import com.bc.ceres.swing.figure.Symbol;
import com.bc.ceres.swing.figure.support.DefaultFigureStyle;
import com.bc.ceres.swing.figure.support.NamedSymbol;
import com.bc.ceres.swing.figure.support.PointHandle;
import com.bc.ceres.swing.figure.support.ShapeSymbol;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.esa.snap.core.datamodel.SceneTransformProvider;
import org.esa.snap.core.util.AwtGeomToJtsGeomConverter;
import org.esa.snap.ui.product.SimpleFeatureFigure;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.operation.TransformException;

public class SimpleFeaturePointFigure
extends AbstractPointFigure
implements SimpleFeatureFigure {
    private static final Font labelFont = new Font("Helvetica", 1, 14);
    private static final int[] labelOutlineAlphas = new int[]{64, 128, 192, 255};
    private static final Stroke[] labelOutlineStrokes = new Stroke[labelOutlineAlphas.length];
    private static final Color[] labelOutlineColors = new Color[labelOutlineAlphas.length];
    private static final Color labelFontColor = Color.WHITE;
    private static final Color labelOutlineColor = Color.BLACK;
    private static final String[] labelAttributeNames = new String[]{"label", "Label"};
    private SceneTransformProvider sceneTransformProvider;
    private SimpleFeature simpleFeature;
    private Point geometry;

    public SimpleFeaturePointFigure(SimpleFeature simpleFeature, SceneTransformProvider provider, FigureStyle style) {
        this(simpleFeature, provider, style, style);
    }

    public SimpleFeaturePointFigure(SimpleFeature simpleFeature, SceneTransformProvider provider, FigureStyle normalStyle, FigureStyle selectedStyle) {
        super(normalStyle, selectedStyle);
        this.simpleFeature = simpleFeature;
        this.sceneTransformProvider = provider;
        Object o = simpleFeature.getDefaultGeometry();
        if (!(o instanceof Point)) {
            throw new IllegalArgumentException("simpleFeature");
        }
        this.setGeometry((Geometry)((Point)o));
        this.setSelectable(true);
    }

    public Object createMemento() {
        return this.getGeometry().clone();
    }

    public void setMemento(Object memento) {
        Point point = (Point)memento;
        this.simpleFeature.setDefaultGeometry((Object)point);
        this.forceRegeneration();
        this.fireFigureChanged();
    }

    @Override
    public SimpleFeature getSimpleFeature() {
        return this.simpleFeature;
    }

    public Point getGeometry() {
        return (Point)this.simpleFeature.getDefaultGeometry();
    }

    @Override
    public void setGeometry(Geometry geometry) {
        Coordinate coordinate;
        Point point = (Point)geometry;
        Point2D.Double sceneCoords = new Point2D.Double(point.getX(), point.getY());
        Point2D.Double modelCoords = new Point2D.Double();
        try {
            this.sceneTransformProvider.getSceneToModelTransform().transform((Point2D)sceneCoords, (Point2D)modelCoords);
            coordinate = new Coordinate(modelCoords.getX(), modelCoords.getY());
        }
        catch (TransformException e) {
            coordinate = new Coordinate(Double.NaN, Double.NaN);
        }
        this.geometry = new Point((CoordinateSequence)new CoordinateArraySequence(new Coordinate[]{coordinate}), point.getFactory());
    }

    @Override
    public void forceRegeneration() {
        this.setGeometry((Geometry)this.simpleFeature.getDefaultGeometry());
    }

    public double getX() {
        return this.geometry.getX();
    }

    public double getY() {
        return this.geometry.getY();
    }

    public void setLocation(double x, double y) {
        Coordinate coordinate = this.geometry.getCoordinate();
        coordinate.x = x;
        coordinate.y = y;
        Point2D.Double modelCoords = new Point2D.Double(x, y);
        Point2D.Double sceneCoords = new Point2D.Double();
        try {
            this.sceneTransformProvider.getModelToSceneTransform().transform((Point2D)modelCoords, (Point2D)sceneCoords);
            this.simpleFeature.setDefaultGeometry((Object)new AwtGeomToJtsGeomConverter().createPoint((Point2D)sceneCoords));
        }
        catch (TransformException e) {
            coordinate.x = Double.NaN;
            coordinate.y = Double.NaN;
        }
        this.geometry.geometryChanged();
        this.fireFigureChanged();
    }

    public double getRadius() {
        return 1.0E-10;
    }

    public Object clone() {
        SimpleFeaturePointFigure clone = (SimpleFeaturePointFigure)super.clone();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(this.simpleFeature.getFeatureType());
        builder.init(this.simpleFeature);
        clone.simpleFeature = builder.buildFeature(null);
        clone.simpleFeature.setDefaultGeometry(this.getGeometry().clone());
        clone.geometry = (Point)this.geometry.clone();
        clone.sceneTransformProvider = this.sceneTransformProvider;
        return clone;
    }

    protected void drawPoint(Rendering rendering) {
        super.drawPoint(rendering);
        String label = this.getLabel();
        if (label != null && !label.trim().isEmpty()) {
            this.drawLabel(rendering, label);
        }
    }

    private String getLabel() {
        for (String labelAttributeName : labelAttributeNames) {
            Object labelAttribute = this.simpleFeature.getAttribute(labelAttributeName);
            if (!(labelAttribute instanceof String)) continue;
            return (String)labelAttribute;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawLabel(Rendering rendering, String label) {
        Graphics2D graphics = rendering.getGraphics();
        Font oldFont = graphics.getFont();
        Stroke oldStroke = graphics.getStroke();
        Paint oldPaint = graphics.getPaint();
        try {
            graphics.setFont(labelFont);
            GlyphVector glyphVector = labelFont.createGlyphVector(graphics.getFontRenderContext(), label);
            Rectangle2D logicalBounds = glyphVector.getLogicalBounds();
            float tx = (float)(logicalBounds.getX() - 0.5 * logicalBounds.getWidth());
            float ty = (float)(this.getSymbol().getBounds().getMaxY() + logicalBounds.getHeight() + 1.0);
            Shape labelOutline = glyphVector.getOutline(tx, ty);
            for (int i = 0; i < labelOutlineAlphas.length; ++i) {
                graphics.setStroke(labelOutlineStrokes[i]);
                graphics.setPaint(labelOutlineColors[i]);
                graphics.draw(labelOutline);
            }
            graphics.setPaint(labelFontColor);
            graphics.fill(labelOutline);
        }
        finally {
            graphics.setPaint(oldPaint);
            graphics.setStroke(oldStroke);
            graphics.setFont(oldFont);
        }
    }

    public int getMaxSelectionStage() {
        return 1;
    }

    public Handle[] createHandles(int selectionStage) {
        if (selectionStage == 1) {
            DefaultFigureStyle handleStyle = new DefaultFigureStyle();
            handleStyle.setStrokeColor(Color.YELLOW);
            handleStyle.setStrokeOpacity(0.8);
            handleStyle.setStrokeWidth(1.0);
            handleStyle.setFillColor(Color.YELLOW);
            handleStyle.setFillOpacity(0.4);
            Symbol symbol = this.getSymbol();
            if (symbol instanceof NamedSymbol) {
                NamedSymbol namedSymbol = (NamedSymbol)symbol;
                symbol = namedSymbol.getSymbol();
            }
            if (symbol instanceof ShapeSymbol) {
                ShapeSymbol shapeSymbol = (ShapeSymbol)symbol;
                return new Handle[]{new PointHandle((PointFigure)this, (FigureStyle)handleStyle, shapeSymbol.getShape())};
            }
            return new Handle[]{new PointHandle((PointFigure)this, (FigureStyle)handleStyle)};
        }
        return super.createHandles(selectionStage);
    }

    static {
        for (int i = 0; i < labelOutlineAlphas.length; ++i) {
            SimpleFeaturePointFigure.labelOutlineStrokes[i] = new BasicStroke(labelOutlineAlphas.length - i);
            SimpleFeaturePointFigure.labelOutlineColors[i] = new Color(labelOutlineColor.getRed(), labelOutlineColor.getGreen(), labelOutlineColor.getBlue(), labelOutlineAlphas[i]);
        }
    }
}

