/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.esa.snap.ui.Bundle;
import org.esa.snap.ui.UIDefaults;
import org.esa.snap.ui.UIUtils;
import org.openide.util.HelpCtx;

public abstract class AbstractDialog {
    public static final int ID_OK = 1;
    public static final int ID_YES = 2;
    public static final int ID_NO = 4;
    public static final int ID_APPLY = 8;
    public static final int ID_CLOSE = 16;
    public static final int ID_CANCEL = 32;
    public static final int ID_RESET = 64;
    public static final int ID_HELP = 128;
    public static final int ID_OTHER = -1431655766;
    private final JDialog dialog;
    private final Window parent;
    private final int buttonMask;
    private int buttonId;
    private Component content;
    private boolean shown;
    private Map<Integer, AbstractButton> buttonMap;
    private JPanel buttonRow;
    private String helpId;

    protected AbstractDialog(JDialog dialog, int buttonMask, Object[] otherButtons, String helpID) {
        this.parent = (Window)dialog.getParent();
        this.dialog = dialog;
        this.buttonMask = buttonMask;
        this.buttonMap = new HashMap<Integer, AbstractButton>(5);
        this.setComponentName(dialog);
        this.setButtonID(0);
        this.initUI(otherButtons);
        this.setHelpID(helpID);
    }

    public JDialog getJDialog() {
        return this.dialog;
    }

    public Window getParent() {
        return this.parent;
    }

    public String getTitle() {
        return this.dialog.getTitle();
    }

    public void setTitle(String title) {
        this.dialog.setTitle(title);
    }

    public int getButtonMask() {
        return this.buttonMask;
    }

    public int getButtonID() {
        return this.buttonId;
    }

    protected void setButtonID(int buttonID) {
        this.buttonId = buttonID;
    }

    public String getHelpID() {
        return this.helpId;
    }

    public void setHelpID(String helpID) {
        this.helpId = helpID;
        this.updateHelpID();
    }

    public JPanel getButtonPanel() {
        return this.buttonRow;
    }

    public Component getContent() {
        return this.content;
    }

    public void setContent(Component content) {
        if (this.content != null) {
            this.dialog.getContentPane().remove(this.content);
        }
        this.content = content;
        this.dialog.getContentPane().add(this.content, "Center");
        this.dialog.validate();
        this.updateHelpID();
    }

    public void setContent(Object content) {
        Component component = content instanceof Component ? (Component)content : new JLabel(content.toString());
        this.setContent(component);
    }

    public AbstractButton getButton(int buttonID) {
        return this.buttonMap.get(buttonID);
    }

    public int show() {
        this.setButtonID(0);
        if (!this.shown) {
            this.dialog.pack();
            this.center();
        }
        this.dialog.setVisible(true);
        this.shown = true;
        return this.getButtonID();
    }

    public void hide() {
        this.dialog.setVisible(false);
    }

    public abstract void close();

    public void center() {
        UIUtils.centerComponent(this.dialog, this.parent);
    }

    public void showErrorDialog(String errorMessage) {
        this.showErrorDialog(errorMessage, this.getJDialog().getTitle());
    }

    public void showErrorDialog(String message, String title) {
        AbstractDialog.showMessageDialog(this.getJDialog(), message, title, 0);
    }

    public static void showErrorDialog(Component component, String message, String dialogTitle) {
        AbstractDialog.showMessageDialog(component, message, dialogTitle, 0);
    }

    public void showInformationDialog(String infoMessage) {
        this.showInformationDialog(infoMessage, this.getJDialog().getTitle());
    }

    public void showInformationDialog(String infoMessage, String title) {
        AbstractDialog.showMessageDialog(this.getJDialog(), infoMessage, title, 1);
    }

    public static void showInformationDialog(Component component, String message, String dialogTitle) {
        AbstractDialog.showMessageDialog(component, message, dialogTitle, 1);
    }

    public void showWarningDialog(String warningMessage) {
        this.showWarningDialog(warningMessage, this.getJDialog().getTitle());
    }

    public void showWarningDialog(String warningMessage, String title) {
        AbstractDialog.showMessageDialog(this.getJDialog(), warningMessage, title, 2);
    }

    public static void showWarningDialog(Component component, String message, String dialogTitle) {
        AbstractDialog.showMessageDialog(component, message, dialogTitle, 2);
    }

    protected void onOK() {
        this.hide();
    }

    protected void onYes() {
        this.hide();
    }

    protected void onNo() {
        this.hide();
    }

    protected void onCancel() {
        this.hide();
    }

    protected void onApply() {
    }

    protected void onClose() {
        this.hide();
    }

    protected void onReset() {
    }

    protected void onHelp() {
        if (this.helpId == null || !new HelpCtx(this.helpId).display()) {
            this.showWarningDialog(String.format(Bundle.CTL_AbstractDlg_NoHelpIDShowingStandard(), this.helpId));
        }
    }

    protected void onOther() {
        this.hide();
    }

    protected boolean verifyUserInput() {
        return true;
    }

    protected void collectButtons(List<AbstractButton> buttons) {
    }

    private void initUI(Object[] otherItems) {
        JButton button;
        this.buttonRow = new JPanel();
        this.buttonRow.setLayout(new BoxLayout(this.buttonRow, 0));
        int insetSize = 6;
        JPanel contentPane = new JPanel(new BorderLayout(0, insetSize + insetSize / 2));
        contentPane.setBorder(UIDefaults.DIALOG_BORDER);
        contentPane.add((Component)this.buttonRow, "South");
        this.dialog.setResizable(true);
        this.dialog.setContentPane(contentPane);
        ArrayList<AbstractButton> buttons = new ArrayList<AbstractButton>();
        this.collectButtons(buttons);
        if (otherItems != null) {
            for (Object otherItem : otherItems) {
                if (otherItem instanceof String) {
                    String text = (String)otherItem;
                    JButton otherButton = new JButton(text);
                    otherButton.setName(this.getQualifiedPropertyName(text));
                    otherButton.addActionListener(e -> {
                        this.setButtonID(-1431655766);
                        if (this.verifyUserInput()) {
                            this.onOther();
                        }
                    });
                    buttons.add(otherButton);
                    continue;
                }
                if (!(otherItem instanceof AbstractButton)) continue;
                AbstractButton otherButton = (AbstractButton)otherItem;
                otherButton.addActionListener(e -> {
                    this.setButtonID(-1431655766);
                    if (this.verifyUserInput()) {
                        this.onOther();
                    }
                });
                buttons.add(otherButton);
            }
        }
        if ((this.buttonMask & 1) != 0) {
            button = new JButton("OK");
            button.setMnemonic('O');
            button.setName(this.getQualifiedPropertyName("ok"));
            button.addActionListener(e -> {
                this.setButtonID(1);
                if (this.verifyUserInput()) {
                    this.onOK();
                }
            });
            buttons.add(button);
            button.setDefaultCapable(true);
            this.getJDialog().getRootPane().setDefaultButton(button);
            this.registerButton(1, button);
        }
        if ((this.buttonMask & 2) != 0) {
            button = new JButton("Yes");
            button.setMnemonic('Y');
            button.setName(this.getQualifiedPropertyName("yes"));
            button.addActionListener(e -> {
                this.setButtonID(2);
                if (this.verifyUserInput()) {
                    this.onYes();
                }
            });
            buttons.add(button);
            button.setDefaultCapable(true);
            this.getJDialog().getRootPane().setDefaultButton(button);
            this.registerButton(2, button);
        }
        if ((this.buttonMask & 4) != 0) {
            button = new JButton("No");
            button.setMnemonic('N');
            button.setName(this.getQualifiedPropertyName("no"));
            button.addActionListener(e -> {
                this.setButtonID(4);
                if (this.verifyUserInput()) {
                    this.onNo();
                }
            });
            buttons.add(button);
            this.registerButton(4, button);
        }
        if ((this.buttonMask & 0x20) != 0) {
            button = new JButton("Cancel");
            button.setMnemonic('C');
            button.setName(this.getQualifiedPropertyName("cancel"));
            button.addActionListener(e -> this.close());
            buttons.add(button);
            button.setVerifyInputWhenFocusTarget(false);
            this.registerButton(32, button);
        }
        if ((this.buttonMask & 8) != 0) {
            button = new JButton("Apply");
            button.setMnemonic('A');
            button.setName(this.getQualifiedPropertyName("apply"));
            button.addActionListener(e -> {
                this.setButtonID(8);
                if (this.verifyUserInput()) {
                    this.onApply();
                }
            });
            buttons.add(button);
            button.setDefaultCapable(true);
            this.getJDialog().getRootPane().setDefaultButton(button);
            this.registerButton(8, button);
        }
        if ((this.buttonMask & 0x10) != 0) {
            button = new JButton("Close");
            button.setMnemonic('C');
            button.setName(this.getQualifiedPropertyName("close"));
            button.addActionListener(e -> {
                this.setButtonID(16);
                this.onClose();
            });
            button.setToolTipText("Close dialog window");
            buttons.add(button);
            button.setVerifyInputWhenFocusTarget(false);
            this.registerButton(16, button);
        }
        if ((this.buttonMask & 0x40) != 0) {
            button = new JButton("Reset");
            button.setName(this.getQualifiedPropertyName("reset"));
            button.setMnemonic('R');
            button.addActionListener(e -> {
                this.setButtonID(64);
                this.onReset();
            });
            buttons.add(button);
            this.registerButton(64, button);
        }
        if ((this.buttonMask & 0x80) != 0) {
            button = new JButton("Help");
            button.setName(this.getQualifiedPropertyName("help"));
            button.setMnemonic('H');
            button.addActionListener(e -> {
                this.setButtonID(128);
                this.onHelp();
            });
            button.setToolTipText("Show help on this topic.");
            buttons.add(button);
            this.registerButton(128, button);
        }
        this.buttonRow.add(Box.createHorizontalGlue());
        for (int i = 0; i < buttons.size(); ++i) {
            if (i != 0) {
                this.buttonRow.add(Box.createRigidArea(new Dimension(4, 0)));
            }
            this.buttonRow.add(buttons.get(i));
        }
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractDialog.this.close();
            }
        });
    }

    protected String getQualifiedPropertyName(String name) {
        return this.getClass().getSimpleName() + "." + name;
    }

    protected void registerButton(int buttonID, AbstractButton button) {
        this.buttonMap.put(buttonID, button);
    }

    private void updateHelpID() {
        Container contentPane;
        if (this.helpId == null) {
            return;
        }
        if (this.getJDialog().getContentPane() != null && (contentPane = this.getJDialog().getContentPane()) instanceof JComponent) {
            HelpCtx.setHelpIDString((JComponent)((JComponent)contentPane), (String)this.helpId);
        }
    }

    private static void showMessageDialog(Component dialog, String message, String dialogTitle, int messageType) {
        JOptionPane.showMessageDialog(dialog, message, dialogTitle, messageType);
    }

    private void setComponentName(JDialog dialog) {
        if (this.dialog.getName() == null && dialog.getTitle() != null) {
            dialog.setName(dialog.getTitle().toLowerCase().replaceAll(" ", "_"));
        }
    }
}

