/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.support;

import java.util.Arrays;
import org.esa.snap.binning.WritableVector;

public final class VectorImpl
implements WritableVector {
    private final float[] elements;
    private int offset;
    private int size;

    public VectorImpl(float[] elements) {
        this.elements = elements;
        this.size = elements.length;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public float get(int index) {
        return this.elements[this.offset + index];
    }

    @Override
    public void set(int index, float element) {
        this.elements[this.offset + index] = element;
    }

    public String toString() {
        return Arrays.toString(Arrays.copyOfRange(this.elements, this.offset, this.offset + this.size));
    }

    public void setOffsetAndSize(int offset, int size) {
        this.offset = offset;
        this.size = size;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getSize() {
        return this.size;
    }
}

