/*
 * Decompiled with CFR 0.152.
 */
package be.abeel.net;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;

public class URIFactory {
    private static String[] special = new String[]{"%21", "%23", "%24", "%26", "%27", "%28", "%29", "%2A", "%2B", "%2C", "%2F", "%3A", "%3B", "%3D", "%3F", "%40", "%5B", "%5D"};

    public static URL url(String s) throws MalformedURLException, URISyntaxException {
        return URIFactory.magicURI(s).toURL();
    }

    public static URI magicURI(String urlString) throws MalformedURLException, URISyntaxException {
        boolean contains = true;
        while (contains) {
            contains = false;
            for (String s : special) {
                if (!urlString.contains(s)) continue;
                contains = true;
            }
            if (!contains) continue;
            try {
                urlString = URLDecoder.decode(urlString, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("Apparently I was wrong and UTF-8 does not exist after all.");
                throw new RuntimeException(e);
            }
        }
        return URIFactory.rawURI(urlString);
    }

    public static URI uri(String urlString) throws MalformedURLException, URISyntaxException {
        return URIFactory.magicURI(urlString);
    }

    public static URI rawURI(String urlString) throws MalformedURLException, URISyntaxException {
        URL url = new URL(urlString);
        String host = url.getHost();
        String protocol = url.getProtocol();
        String path = url.getPath();
        String query = url.getQuery();
        String user = url.getUserInfo();
        int port = url.getPort();
        String anchor = url.getRef();
        return new URI(protocol, user, host, port, path, query, anchor);
    }
}

