/*
 * Decompiled with CFR 0.152.
 */
package be.abeel.io;

import be.abeel.io.LineIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class LineIteratorFactory {
    public static LineIterator createFromGZip(File f) throws IOException {
        return new LineIterator(new GZIPInputStream(new FileInputStream(f)));
    }

    public static LineIterator createFromZip(File f) throws IOException {
        ZipInputStream zipinputstream = new ZipInputStream(new FileInputStream(f));
        ZipEntry zipentry = zipinputstream.getNextEntry();
        if (zipentry != null) {
            String entryName = zipentry.getName();
            File newFile = new File(entryName);
            return new LineIterator(newFile);
        }
        return null;
    }
}

