/*
 * Decompiled with CFR 0.152.
 */
package be.abeel.graphics;

import be.abeel.graphics.Drawable;
import be.abeel.io.ExtensionManager;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class PDFexport {
    public static void exportPDF(Drawable d, String fileName, int x, int y) {
        Rectangle pagesize = new Rectangle((float)x, (float)y);
        Document document = new Document(pagesize, 50.0f, 50.0f, 50.0f, 50.0f);
        try {
            fileName = ExtensionManager.extension(fileName, ExtensionManager.PDF);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(fileName));
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            document.open();
            PdfTemplate tp = cb.createTemplate((float)x, (float)y);
            Graphics2D g2 = tp.createGraphics((float)x, (float)y, (FontMapper)new DefaultFontMapper());
            Rectangle2D.Double r2D = new Rectangle2D.Double(0.0, 0.0, x, y);
            d.draw(g2, r2D);
            g2.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
            document.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }
}

