/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.srtm3_geotiff;

import java.io.File;
import java.io.IOException;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.dem.ElevationFile;
import org.esa.snap.core.dataop.dem.ElevationTile;
import org.esa.snap.dem.dataio.srtm3_geotiff.SRTM3GeoTiffElevationModel;
import org.esa.snap.dem.dataio.srtm3_geotiff.SRTM3GeoTiffElevationTile;
import org.esa.snap.engine_utilities.util.Settings;

public final class SRTM3GeoTiffFile
extends ElevationFile {
    private final SRTM3GeoTiffElevationModel demModel;
    private static final String remoteHTTP1 = "http://srtm.csi.cgiar.org/wp-content/uploads/files/srtm_5x5/TIFF/";
    private static final String remoteHTTP2 = "http://cgiar-csi-srtm.openterrain.org.s3.amazonaws.com/source/";
    private static final String remoteFTP = Settings.instance().get("DEM.srtm3GeoTiffDEM_FTP", "xftp.jrc.it");
    private static final String remotePath = Settings.getPath((String)"DEM.srtm3GeoTiffDEM_remotePath");
    private static final String remoteHTTP = Settings.instance().get("DEM.srtm3GeoTiffDEM_HTTP", "http://srtm.csi.cgiar.org/wp-content/uploads/files/srtm_5x5/TIFF/");

    public SRTM3GeoTiffFile(SRTM3GeoTiffElevationModel model, File localFile, ProductReader reader) {
        super(localFile, reader);
        this.demModel = model;
    }

    protected ElevationTile createTile(Product product) throws IOException {
        SRTM3GeoTiffElevationTile tile = new SRTM3GeoTiffElevationTile(this.demModel, product);
        this.demModel.updateCache((ElevationTile)tile);
        return tile;
    }

    protected Boolean getRemoteFile() throws IOException {
        try {
            boolean found = this.getRemoteHttpFile(remoteHTTP);
            if (!found && !(found = this.getRemoteHttpFile(remoteHTTP1).booleanValue())) {
                found = this.getRemoteHttpFile(remoteHTTP2);
            }
            return found;
        }
        catch (Exception e) {
            try {
                return this.getRemoteHttpFile(remoteHTTP1);
            }
            catch (Exception e2) {
                return this.getRemoteHttpFile(remoteHTTP2);
            }
        }
    }
}

