/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.srtm1_esrigrid;

import org.esa.snap.core.dataop.dem.AbstractElevationModelDescriptor;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.dem.dataio.srtm1_esrigrid.SRTM1GridElevationModel;

public class SRTM1GridElevationModelDescriptor
extends AbstractElevationModelDescriptor {
    public static final String NAME = "SRTM 1Sec Grid";
    public static final int NUM_X_TILES = 360;
    public static final int NUM_Y_TILES = 120;
    public static final int DEGREE_RES = 1;
    public static final int PIXEL_RES = 3600;
    public static final int NO_DATA_VALUE = Short.MIN_VALUE;
    public static final int RASTER_WIDTH = 1296000;
    public static final int RASTER_HEIGHT = 432000;

    public String getName() {
        return NAME;
    }

    public int getNumXTiles() {
        return 360;
    }

    public int getNumYTiles() {
        return 120;
    }

    public float getNoDataValue() {
        return -32768.0f;
    }

    public int getRasterWidth() {
        return 1296000;
    }

    public int getRasterHeight() {
        return 432000;
    }

    public int getTileWidthInDegrees() {
        return 1;
    }

    public int getTileWidth() {
        return 3600;
    }

    public boolean canBeDownloaded() {
        return false;
    }

    public ElevationModel createDem(Resampling resamplingMethod) {
        try {
            return new SRTM1GridElevationModel(this, resamplingMethod);
        }
        catch (Exception e) {
            return null;
        }
    }
}

