/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.cdem;

import java.io.File;
import java.io.IOException;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.dem.ElevationFile;
import org.esa.snap.core.dataop.dem.ElevationTile;
import org.esa.snap.dem.dataio.cdem.CDEMElevationModel;
import org.esa.snap.dem.dataio.cdem.CDEMElevationTile;
import org.esa.snap.engine_utilities.util.Settings;

public final class CDEMFile
extends ElevationFile {
    private final CDEMElevationModel demModel;
    private static final String remoteHTTP1 = "http://step.esa.int/auxdata/dem/cdem/";
    private static final String remoteHTTP = Settings.instance().get("DEM.CDEM_HTTP", "http://step.esa.int/auxdata/dem/cdem/");

    public CDEMFile(CDEMElevationModel model, File localFile, ProductReader reader) {
        super(localFile, reader);
        this.demModel = model;
    }

    protected ElevationTile createTile(Product product) throws IOException {
        return new CDEMElevationTile(this.demModel, product);
    }

    protected Boolean getRemoteFile() throws IOException {
        return this.getRemoteHttpFile(remoteHTTP);
    }

    public static String getRemoteHTTP() {
        return remoteHTTP;
    }
}

