/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.cdem;

import org.esa.snap.core.dataop.dem.AbstractElevationModelDescriptor;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.dem.dataio.cdem.CDEMElevationModel;

public class CDEMElevationModelDescriptor
extends AbstractElevationModelDescriptor {
    private static final String NAME = "CDEM";
    private static final int NUM_X_TILES = 72;
    private static final int NUM_Y_TILES = 24;
    private static final int DEGREE_RES = 5;
    private static final int PIXEL_RES = 6000;
    private static final int NO_DATA_VALUE = Short.MIN_VALUE;
    private static final int RASTER_WIDTH = 432000;
    private static final int RASTER_HEIGHT = 144000;

    public String getName() {
        return NAME;
    }

    public int getNumXTiles() {
        return 72;
    }

    public int getNumYTiles() {
        return 24;
    }

    public float getNoDataValue() {
        return -32768.0f;
    }

    public int getRasterWidth() {
        return 432000;
    }

    public int getRasterHeight() {
        return 144000;
    }

    public int getTileWidthInDegrees() {
        return 5;
    }

    public int getTileWidth() {
        return 6000;
    }

    public boolean canBeDownloaded() {
        return true;
    }

    public synchronized ElevationModel createDem(Resampling resamplingMethod) {
        return new CDEMElevationModel(this, resamplingMethod);
    }
}

