/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.aster;

import java.io.IOException;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.dem.BaseElevationTile;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.dem.dataio.EarthGravitationalModel96;
import org.esa.snap.dem.dataio.aster.AsterElevationModel;
import org.esa.snap.engine_utilities.gpf.TileGeoreferencing;

public final class AsterElevationTile
extends BaseElevationTile {
    private final EarthGravitationalModel96 egm = EarthGravitationalModel96.instance();

    public AsterElevationTile(AsterElevationModel dem, Product product) throws IOException {
        super((ElevationModel)dem, product);
    }

    protected void addGravitationalModel(int index, float[] line) throws Exception {
        GeoPos geoPos = new GeoPos();
        TileGeoreferencing tileGeoRef = new TileGeoreferencing(this.product, 0, index, line.length, 1);
        double[][] v = new double[4][4];
        for (int i = 0; i < line.length; ++i) {
            if (line[i] == this.noDataValue) continue;
            tileGeoRef.getGeoPos(i, index, geoPos);
            int n = i;
            line[n] = line[n] + this.egm.getEGM(geoPos.lat, geoPos.lon, v);
        }
    }
}

