/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.ace2_5min;

import java.io.File;
import java.io.IOException;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.dem.BaseElevationTile;
import org.esa.snap.core.dataop.dem.ElevationFile;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.dataop.dem.ElevationTile;
import org.esa.snap.dem.dataio.ace2_5min.ACE2_5MinElevationModel;
import org.esa.snap.engine_utilities.util.Settings;

public final class ACE2_5MinFile
extends ElevationFile {
    private final ACE2_5MinElevationModel demModel;
    private static final String remoteHTTP = Settings.instance().get("DEM.ace2_5MinDEM_HTTP", "http://step.esa.int/auxdata/dem/ACE2/5M/");

    public ACE2_5MinFile(ACE2_5MinElevationModel model, File localFile, ProductReader reader) {
        super(localFile, reader);
        this.demModel = model;
    }

    protected ElevationTile createTile(Product product) {
        BaseElevationTile tile = new BaseElevationTile((ElevationModel)this.demModel, product);
        this.demModel.updateCache((ElevationTile)tile);
        return tile;
    }

    protected Boolean getRemoteFile() throws IOException {
        return this.getRemoteHttpFile(remoteHTTP);
    }
}

