/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.ace;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MapGeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.dataop.maptransf.Datum;
import org.esa.snap.core.dataop.maptransf.MapInfo;
import org.esa.snap.core.dataop.maptransf.MapProjectionRegistry;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.dem.dataio.ace.ACEFileInfo;
import org.esa.snap.dem.dataio.ace.ACEReaderPlugIn;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

public class ACEReader
extends AbstractProductReader {
    private ZipFile _zipFile = null;
    private ImageInputStream _imageInputStream = null;
    private ACEFileInfo _fileInfo = null;
    private Product _product = null;

    public ACEReader(ACEReaderPlugIn readerPlugIn) {
        super((ProductReaderPlugIn)readerPlugIn);
    }

    protected Product readProductNodesImpl() throws IOException {
        String fileName;
        this.initReader();
        File dataFile = ReaderUtils.getFileFromInput((Object)this.getInput());
        this._fileInfo = ACEFileInfo.create(dataFile);
        try {
            String ext = FileUtils.getExtension((File)dataFile);
            if (ext != null && ext.equalsIgnoreCase(".zip")) {
                String entryName = FileUtils.getFilenameWithoutExtension((String)dataFile.getName()) + ".ACE";
                this._zipFile = new ZipFile(dataFile);
                ZipEntry entry = this.getZipEntryIgnoreCase(entryName);
                InputStream inputStream = this._zipFile.getInputStream(entry);
                this._imageInputStream = new FileCacheImageInputStream(inputStream, ACEReader.createCacheDir());
                fileName = FileUtils.getFilenameWithoutExtension((String)entryName);
            } else {
                this._imageInputStream = new FileImageInputStream(dataFile);
                fileName = FileUtils.getFilenameWithoutExtension((File)dataFile);
            }
            this._imageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        this.initProduct("ACE_" + fileName);
        this._product.setFileLocation(dataFile);
        return this._product;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        pm.beginTask("Reading DEM Data...", 1);
        try {
            short[] elems = (short[])destBuffer.getElems();
            this.readRasterDataImpl(elems, sourceOffsetY, sourceOffsetX, sourceStepX, sourceStepY, destWidth, destHeight, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            this.maskInt32Extrema(elems);
        }
        finally {
            pm.done();
        }
    }

    public void close() throws IOException {
        super.close();
        this.closeImageInputStream();
        this.closeZipFile();
        this._product = null;
    }

    private void closeImageInputStream() throws IOException {
        if (this._imageInputStream != null) {
            this._imageInputStream.close();
            this._imageInputStream = null;
        }
    }

    private void closeZipFile() throws IOException {
        if (this._zipFile != null) {
            this._zipFile.close();
            this._zipFile = null;
        }
    }

    private void initReader() {
        this._zipFile = null;
        this._imageInputStream = null;
        this._product = null;
        this._fileInfo = null;
    }

    private static File createCacheDir() throws IOException {
        File cacheDir = new File(SystemUtils.getCacheDir(), "temp");
        if (!cacheDir.exists() && !cacheDir.mkdirs()) {
            throw new IOException("Failed to create directory '" + cacheDir + "'.");
        }
        return cacheDir;
    }

    private void initProduct(String productName) {
        int width = this._fileInfo.getWidth();
        int height = this._fileInfo.getHeight();
        this._product = new Product(productName, "ACE", width, height, (ProductReader)this);
        MapInfo mapInfo = new MapInfo(MapProjectionRegistry.getProjection((String)"Geographic Lat/Lon"), 0.5f, 0.5f, this._fileInfo.getEasting(), this._fileInfo.getNorthing() + (float)height * this._fileInfo.getPixelSizeY(), this._fileInfo.getPixelSizeX(), this._fileInfo.getPixelSizeY(), Datum.WGS_84);
        mapInfo.setSceneWidth(width);
        mapInfo.setSceneHeight(height);
        this._product.setSceneGeoCoding((GeoCoding)new MapGeoCoding(mapInfo));
        this._product.setDescription("ACE DEM");
        Band elevationBand = new Band("elevation", 11, width, height);
        elevationBand.setUnit("meters");
        elevationBand.setDescription("ACE Elevation");
        elevationBand.setGeophysicalNoDataValue((double)this._fileInfo.getNoDataValue());
        this._product.addBand(elevationBand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void readRasterDataImpl(short[] elems, int sourceOffsetY, int sourceOffsetX, int sourceStepX, int sourceStepY, int destWidth, int destHeight, ProgressMonitor pm) throws IOException {
        block9: {
            int sceneWidth = this._product.getSceneRasterWidth();
            pm.beginTask("Reading raster data...", destHeight);
            try {
                if (sourceStepX == 1) {
                    int sourceY = sourceOffsetY;
                    for (int destY = 0; destY < destHeight; ++destY) {
                        if (pm.isCanceled()) {
                            break block9;
                        }
                        long sourcePos = sourceY * sceneWidth + sourceOffsetX;
                        int destPos = destY * destWidth;
                        this._imageInputStream.seek(2L * sourcePos);
                        this._imageInputStream.readFully(elems, destPos, destWidth);
                        sourceY += sourceStepY;
                        pm.worked(sourceStepY);
                    }
                    break block9;
                }
                int sourceY = sourceOffsetY;
                for (int destY = 0; destY < destHeight; ++destY) {
                    if (pm.isCanceled()) {
                        break;
                    }
                    int sourceX = sourceOffsetX;
                    for (int destX = 0; destX < destWidth; ++destX) {
                        long sourcePos = sourceY * sceneWidth + sourceX;
                        int destPos = destY * destWidth + destX;
                        this._imageInputStream.seek(2L * sourcePos);
                        elems[destPos] = this._imageInputStream.readShort();
                        sourceX += sourceStepX;
                    }
                    sourceY += sourceStepY;
                    pm.worked(sourceStepY);
                }
            }
            finally {
                pm.done();
            }
        }
    }

    private void maskInt32Extrema(short[] elems) {
        short noDataValue = (short)this._fileInfo.getNoDataValue();
        for (int i = 0; i < elems.length; ++i) {
            if (elems[i] != Short.MIN_VALUE && elems[i] != Short.MAX_VALUE) continue;
            elems[i] = noDataValue;
        }
    }

    private ZipEntry getZipEntryIgnoreCase(String entryName) {
        Enumeration<? extends ZipEntry> enumeration = this._zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!zipEntry.getName().equalsIgnoreCase(entryName)) continue;
            return zipEntry;
        }
        return null;
    }
}

