/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.util;

import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ConvolutionFilterBand;
import org.esa.snap.core.datamodel.Kernel;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.rcp.SnapApp;

public class FakeUncertaintyGenerator {
    public static final int UNCERTAINTY_KIND_COUNT = 2;

    private FakeUncertaintyGenerator() {
    }

    private static int addUncertaintyBands(Product product, int bandCount) {
        Band[] bands = product.getBands();
        product.setAutoGrouping("radiance_*_variance:radiance_*_confidence:radiance_*_blur:radiance");
        for (Band band : bands) {
            ++bandCount;
            String bandName = band.getName();
            if (!bandName.startsWith("radiance") || bandName.endsWith("_blur") || bandName.endsWith("_variance") || bandName.endsWith("_confidence")) continue;
            Band varianceBand = product.getBand(bandName + "_variance");
            Band confidenceBand = product.getBand(bandName + "_confidence");
            if (confidenceBand == null) {
                if (bandCount % 2 == 0) {
                    ConvolutionFilterBand blurredBand = new ConvolutionFilterBand(bandName + "_blur", (RasterDataNode)band, new Kernel(11, 11, new double[]{0.0, 0.0, 0.001388888888888889, 0.001388888888888889, 0.002777777777777778, 0.002777777777777778, 0.002777777777777778, 0.001388888888888889, 0.001388888888888889, 0.0, 0.0, 0.0, 0.001388888888888889, 0.002777777777777778, 0.004166666666666667, 0.005555555555555556, 0.006944444444444444, 0.005555555555555556, 0.004166666666666667, 0.002777777777777778, 0.001388888888888889, 0.0, 0.001388888888888889, 0.002777777777777778, 0.005555555555555556, 0.008333333333333333, 0.0125, 0.0125, 0.0125, 0.008333333333333333, 0.005555555555555556, 0.002777777777777778, 0.001388888888888889, 0.001388888888888889, 0.004166666666666667, 0.008333333333333333, 0.015277777777777777, 0.019444444444444445, 0.022222222222222223, 0.019444444444444445, 0.015277777777777777, 0.008333333333333333, 0.004166666666666667, 0.001388888888888889, 0.002777777777777778, 0.005555555555555556, 0.0125, 0.019444444444444445, 0.027777777777777776, 0.030555555555555555, 0.027777777777777776, 0.019444444444444445, 0.0125, 0.005555555555555556, 0.002777777777777778, 0.002777777777777778, 0.006944444444444444, 0.0125, 0.022222222222222223, 0.030555555555555555, 0.03333333333333333, 0.030555555555555555, 0.022222222222222223, 0.0125, 0.006944444444444444, 0.002777777777777778, 0.002777777777777778, 0.005555555555555556, 0.0125, 0.019444444444444445, 0.027777777777777776, 0.030555555555555555, 0.027777777777777776, 0.019444444444444445, 0.0125, 0.005555555555555556, 0.002777777777777778, 0.001388888888888889, 0.004166666666666667, 0.008333333333333333, 0.015277777777777777, 0.019444444444444445, 0.022222222222222223, 0.019444444444444445, 0.015277777777777777, 0.008333333333333333, 0.004166666666666667, 0.001388888888888889, 0.001388888888888889, 0.002777777777777778, 0.005555555555555556, 0.008333333333333333, 0.0125, 0.0125, 0.0125, 0.008333333333333333, 0.005555555555555556, 0.002777777777777778, 0.001388888888888889, 0.0, 0.001388888888888889, 0.002777777777777778, 0.004166666666666667, 0.005555555555555556, 0.006944444444444444, 0.005555555555555556, 0.004166666666666667, 0.002777777777777778, 0.001388888888888889, 0.0, 0.0, 0.0, 0.001388888888888889, 0.001388888888888889, 0.002777777777777778, 0.002777777777777778, 0.002777777777777778, 0.001388888888888889, 0.001388888888888889, 0.0, 0.0}), 1);
                    product.addBand((Band)blurredBand);
                    String varianceExpr = String.format("0.1 * (1 + 0.1 * min(max(random_gaussian(), 0), 10)) * %s", blurredBand.getName());
                    varianceBand = FakeUncertaintyGenerator.addVarianceBand(product, band, varianceExpr);
                    confidenceBand = FakeUncertaintyGenerator.addConfidenceBand(product, band, varianceBand);
                } else if (bandCount % 2 == 1) {
                    int w2 = product.getSceneRasterWidth() / 2;
                    int h2 = product.getSceneRasterHeight() / 2;
                    int s = Math.min(w2, h2);
                    String varianceExpr = String.format("100 * 0.5 * (1 + sin(4 * PI * sqrt(sq(X-%d) + sq(Y-%d)) / %d))", w2, h2, s);
                    varianceBand = FakeUncertaintyGenerator.addVarianceBand(product, band, varianceExpr);
                    confidenceBand = FakeUncertaintyGenerator.addConfidenceBand(product, band, varianceBand);
                }
            }
            band.addAncillaryVariable((RasterDataNode)varianceBand, new String[]{"variance"});
            band.addAncillaryVariable((RasterDataNode)confidenceBand, new String[]{"confidence"});
        }
        return bandCount;
    }

    private static Band addVarianceBand(Product product, Band sourceBand, String varianceExpr) {
        Band varianceBand = product.addBand(sourceBand.getName() + "_variance", varianceExpr, 30);
        varianceBand.setUnit(sourceBand.getUnit());
        ProductUtils.copySpectralBandProperties((Band)sourceBand, (Band)varianceBand);
        return varianceBand;
    }

    private static Band addConfidenceBand(Product product, Band sourceBand, Band varianceBand) {
        Stx varStx = varianceBand.getStx();
        double minVar = Math.max(varStx.getMean() - 3.0 * varStx.getStandardDeviation(), varStx.getMinimum());
        double maxVar = Math.min(varStx.getMean() + 3.0 * varStx.getStandardDeviation(), varStx.getMaximum());
        double absVar = maxVar - minVar;
        Band confidenceBand = product.addBand(sourceBand.getName() + "_confidence", String.format("min(max((1 - (%s - %s) / %s), 0), 1)", varianceBand.getName(), minVar, absVar), 30);
        confidenceBand.setUnit("dl");
        return confidenceBand;
    }

    public static class StartOp
    implements Runnable {
        int bandCount;

        @Override
        public void run() {
            if (Boolean.getBoolean("snap.uncertainty.test")) {
                SnapApp.getDefault().getProductManager().addListener(new ProductManager.Listener(){

                    public void productAdded(ProductManager.Event event) {
                        bandCount = FakeUncertaintyGenerator.addUncertaintyBands(event.getProduct(), bandCount);
                    }

                    public void productRemoved(ProductManager.Event event) {
                    }
                });
            }
        }
    }
}

