/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.media.jai.Histogram;
import javax.swing.AbstractAction;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.statistics.StatisticsDataProvider;
import org.esa.snap.rcp.statistics.StatisticsPanel;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.statistics.output.BandNameCreator;
import org.esa.snap.statistics.output.FeatureStatisticsWriter;
import org.esa.snap.statistics.output.StatisticsOutputContext;
import org.esa.snap.statistics.output.Util;
import org.esa.snap.ui.product.ProductSceneView;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

class PutStatisticsIntoVectorDataAction
extends AbstractAction {
    private Mask[] selectedMasks;
    private final Map<SimpleFeatureType, VectorDataNode> featureType2VDN = new HashMap<SimpleFeatureType, VectorDataNode>();
    private final Map<SimpleFeatureType, Set<Mask>> featureType2Mask = new HashMap<SimpleFeatureType, Set<Mask>>();
    private final Map<Mask, Histogram> mask2Histogram = new HashMap<Mask, Histogram>();
    private final Map<Mask, String> mask2RegionName = new HashMap<Mask, String>();
    private final StatisticsDataProvider provider;

    PutStatisticsIntoVectorDataAction(StatisticsDataProvider provider) {
        super("Put statistics into vector data");
        this.provider = provider;
    }

    @Override
    public boolean isEnabled() {
        boolean hasSelectedMasks = this.hasSelectedMasks();
        boolean hasTarget = this.getFeatureTypes().length != 0;
        return super.isEnabled() && hasSelectedMasks && hasTarget;
    }

    private boolean hasSelectedMasks() {
        boolean hasSelectedMasks;
        boolean bl = hasSelectedMasks = this.selectedMasks != null && this.selectedMasks.length != 0;
        if (hasSelectedMasks) {
            for (Mask selectedMask : this.selectedMasks) {
                if (selectedMask != null) break;
                hasSelectedMasks = false;
            }
        }
        return hasSelectedMasks;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.selectedMasks[0] == null) {
            return;
        }
        for (SimpleFeatureType featureType : this.getFeatureTypes()) {
            VectorDataNode originalVDN = this.featureType2VDN.get(featureType);
            if (originalVDN.isPermanent()) {
                SystemUtils.LOG.warning("Unable to put statistics into permanent vector data.");
                Dialogs.showError("Unable to put statistics into permanent vector data (such as pins/GCPs).");
                continue;
            }
            FeatureStatisticsWriter featureStatisticsWriter = FeatureStatisticsWriter.createFeatureStatisticsWriter(this.getFeatureCollection(featureType), null, (BandNameCreator)new BandNameCreator());
            featureStatisticsWriter.initialiseOutput(StatisticsOutputContext.create((String[])new String[]{this.provider.getRasterDataNode().getName()}, (String[])new String[]{"minimum", "maximum", "median", "average", "sigma", "p90", "p95", "pxx_max_error", "total"}));
            for (Mask mask : this.getMasks(featureType)) {
                HashMap<String, Number> statistics = new HashMap<String, Number>();
                Histogram histogram = this.getHistogram(mask);
                statistics.put("minimum", histogram.getLowValue(0));
                statistics.put("maximum", histogram.getHighValue(0));
                statistics.put("median", histogram.getPTileThreshold(0.5)[0]);
                statistics.put("average", histogram.getMean()[0]);
                statistics.put("sigma", histogram.getStandardDeviation()[0]);
                statistics.put("p90", histogram.getPTileThreshold(0.9)[0]);
                statistics.put("p95", histogram.getPTileThreshold(0.95)[0]);
                statistics.put("pxx_max_error", StatisticsPanel.getBinSize(histogram));
                statistics.put("total", histogram.getTotals()[0]);
                featureStatisticsWriter.addToOutput(this.provider.getRasterDataNode().getName(), this.mask2RegionName.get(mask), statistics);
            }
            this.exchangeVDN(featureType, featureStatisticsWriter);
            Dialogs.showMessage("Extending vector data with statistics", "The vector data have successfully been extended with the computed statistics.", 1, null);
        }
    }

    private void exchangeVDN(SimpleFeatureType featureType, FeatureStatisticsWriter featureStatisticsWriter) {
        VectorDataNode originalVDN = this.featureType2VDN.get(featureType);
        VectorDataNode vectorDataNode = PutStatisticsIntoVectorDataAction.createVectorDataNode(featureStatisticsWriter, originalVDN);
        ProductNodeGroup<VectorDataNode> vectorDataNodeGroup = this.provider.getVectorDataNodeGroup();
        vectorDataNodeGroup.remove((ProductNode)originalVDN);
        originalVDN.dispose();
        vectorDataNodeGroup.add((ProductNode)vectorDataNode);
        ProductSceneView sceneView = SnapApp.getDefault().getSelectedProductSceneView();
        if (sceneView != null) {
            sceneView.setLayersVisible(new VectorDataNode[]{vectorDataNode});
        }
    }

    private static VectorDataNode createVectorDataNode(FeatureStatisticsWriter featureStatisticsWriter, VectorDataNode originalVDN) {
        SimpleFeatureType updatedFeatureType = featureStatisticsWriter.getUpdatedFeatureType();
        List features = featureStatisticsWriter.getFeatures();
        ListFeatureCollection featureCollection = new ListFeatureCollection(updatedFeatureType, features);
        PlacemarkDescriptor placemarkDescriptor = originalVDN.getPlacemarkDescriptor();
        VectorDataNode vectorDataNode = new VectorDataNode(originalVDN.getName(), (FeatureCollection)featureCollection, placemarkDescriptor);
        vectorDataNode.setPermanent(originalVDN.isPermanent());
        vectorDataNode.setModified(true);
        vectorDataNode.setDescription(originalVDN.getDescription());
        return vectorDataNode;
    }

    private Histogram getHistogram(Mask mask) {
        return this.mask2Histogram.get(mask);
    }

    private Mask[] getMasks(SimpleFeatureType featureType) {
        Set<Mask> masks = this.featureType2Mask.get(featureType);
        return masks.toArray(new Mask[masks.size()]);
    }

    private FeatureCollection<SimpleFeatureType, SimpleFeature> getFeatureCollection(SimpleFeatureType featureType) {
        return this.featureType2VDN.get(featureType).getFeatureCollection();
    }

    private SimpleFeatureType[] getFeatureTypes() {
        if (!this.hasSelectedMasks()) {
            return new SimpleFeatureType[0];
        }
        ArrayList<SimpleFeatureType> result = new ArrayList<SimpleFeatureType>();
        Histogram[] histograms = this.provider.getHistograms();
        for (int i = 0; i < this.selectedMasks.length; ++i) {
            Mask selectedMask = this.selectedMasks[i];
            this.mask2Histogram.put(selectedMask, histograms[i]);
            if (!selectedMask.getImageType().getName().equals("Geometry")) continue;
            VectorDataNode vectorDataNode = Mask.VectorDataType.getVectorData((Mask)selectedMask);
            SimpleFeatureType featureType = vectorDataNode.getFeatureType();
            if (!result.contains(featureType)) {
                result.add(featureType);
            }
            if (!this.featureType2Mask.containsKey(featureType)) {
                this.featureType2Mask.put(featureType, new HashSet());
            }
            this.featureType2Mask.get(featureType).add(selectedMask);
            this.featureType2VDN.put(featureType, vectorDataNode);
            this.setMaskRegionName(selectedMask, vectorDataNode);
        }
        return result.toArray(new SimpleFeatureType[result.size()]);
    }

    private void setMaskRegionName(Mask selectedMask, VectorDataNode vectorDataNode) {
        SimpleFeatureIterator features = vectorDataNode.getFeatureCollection().features();
        this.mask2RegionName.put(selectedMask, Util.getFeatureName((SimpleFeature)((SimpleFeature)features.next())));
        features.close();
    }

    public void setSelectedMasks(Mask[] selectedMasks) {
        this.selectedMasks = selectedMasks;
    }
}

