/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.placemark.gcp;

import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GcpDescriptor;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.ProductNodeListenerAdapter;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.rcp.placemark.PlacemarkManagerTopComponent;
import org.esa.snap.rcp.placemark.TableModelFactory;
import org.esa.snap.rcp.placemark.gcp.Bundle;
import org.esa.snap.rcp.placemark.gcp.GcpGeoCodingForm;
import org.esa.snap.rcp.placemark.gcp.GcpTableModel;
import org.esa.snap.ui.DecimalTableCellRenderer;
import org.esa.snap.ui.product.AbstractPlacemarkTableModel;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="GcpManagerTopComponent", iconBase="org/esa/snap/rcp/icons/GcpManager.gif", persistenceType=0)
public class GcpManagerTopComponent
extends PlacemarkManagerTopComponent {
    public static final String ID = GcpManagerTopComponent.class.getName();
    private GcpGeoCodingForm geoCodingForm;
    private final ProductNodeListenerAdapter geoCodinglistener = new ProductNodeListenerAdapter(){

        public void nodeChanged(ProductNodeEvent event) {
            if ("sceneGeoCoding".equals(event.getPropertyName())) {
                GcpManagerTopComponent.this.updateUIState();
            }
        }
    };

    public GcpManagerTopComponent() {
        super((PlacemarkDescriptor)GcpDescriptor.getInstance(), new TableModelFactory(){

            @Override
            public AbstractPlacemarkTableModel createTableModel(PlacemarkDescriptor placemarkDescriptor, Product product, Band[] selectedBands, TiePointGrid[] selectedGrids) {
                return new GcpTableModel(placemarkDescriptor, product, selectedBands, selectedGrids);
            }
        });
    }

    @Override
    protected Component getSouthExtension() {
        this.geoCodingForm = new GcpGeoCodingForm();
        return this.geoCodingForm;
    }

    @Override
    public void setProduct(Product product) {
        Product oldProduct = this.getProduct();
        if (oldProduct != product) {
            if (oldProduct != null) {
                oldProduct.removeProductNodeListener((ProductNodeListener)this.geoCodinglistener);
            }
            if (product != null) {
                product.addProductNodeListener((ProductNodeListener)this.geoCodinglistener);
            }
        }
        super.setProduct(product);
    }

    @Override
    protected void addCellRenderer(TableColumnModel columnModel) {
        super.addCellRenderer(columnModel);
        columnModel.getColumn(4).setCellRenderer((TableCellRenderer)new DecimalTableCellRenderer(new DecimalFormat("0.000000")));
        columnModel.getColumn(5).setCellRenderer((TableCellRenderer)new DecimalTableCellRenderer(new DecimalFormat("0.000000")));
    }

    @Override
    protected void updateUIState() {
        super.updateUIState();
        this.geoCodingForm.setProduct(this.getProduct());
        this.geoCodingForm.updateUIState();
    }

    @Override
    protected String getTitle() {
        return Bundle.CTL_GcpManagerTopComponent_Name();
    }

    @Override
    protected String getHelpId() {
        return Bundle.CTL_GcpManagerTopComponent_HelpId();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(Bundle.CTL_GcpManagerTopComponent_HelpId());
    }
}

