/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.nodes;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.esa.snap.core.datamodel.ProductNode;

public class UndoableProductNodeEdit<T extends ProductNode>
extends AbstractUndoableEdit {
    private final String name;
    private final T node;
    private final Edit<T> undo;
    private final Edit<T> redo;

    public UndoableProductNodeEdit(String name, T node, Edit<T> undo, Edit<T> redo) {
        this.name = name;
        this.node = node;
        this.undo = undo;
        this.redo = redo;
    }

    @Override
    public String getPresentationName() {
        return this.name;
    }

    @Override
    public void undo() throws CannotUndoException {
        if (this.undo != null) {
            this.undo.edit(this.node);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        if (this.redo != null) {
            this.redo.edit(this.node);
        }
    }

    @Override
    public boolean canUndo() {
        return this.undo != null;
    }

    @Override
    public boolean canRedo() {
        return this.redo != null;
    }

    static interface Edit<T extends ProductNode> {
        public void edit(T var1);
    }
}

