/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc.wms;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.layermanager.layersrc.HistoryComboBoxModel;
import org.esa.snap.rcp.layermanager.layersrc.wms.WmsAssistantPage2;
import org.esa.snap.ui.UserInputHistory;
import org.esa.snap.ui.layer.AbstractLayerSourceAssistantPage;
import org.esa.snap.ui.layer.LayerSourcePageContext;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.data.wms.WebMapServer;

class WmsAssistantPage1
extends AbstractLayerSourceAssistantPage {
    private JComboBox wmsUrlBox;
    private static final String PROPERTY_WMS_HISTORY = "WmsAssistant.wms.history";
    private UserInputHistory history;

    WmsAssistantPage1() {
        super("Select WMS");
    }

    public boolean validatePage() {
        if (this.wmsUrlBox.getSelectedItem() != null) {
            String wmsUrl = this.wmsUrlBox.getSelectedItem().toString();
            return wmsUrl != null && !wmsUrl.trim().isEmpty();
        }
        return false;
    }

    public boolean hasNextPage() {
        return true;
    }

    public AbstractLayerSourceAssistantPage getNextPage() {
        LayerSourcePageContext pageContext = this.getContext();
        WebMapServer wms = null;
        WMSCapabilities wmsCapabilities = null;
        String wmsUrl = this.wmsUrlBox.getSelectedItem().toString();
        if (wmsUrl != null && !wmsUrl.isEmpty()) {
            try {
                wms = this.getWms(pageContext.getWindow(), wmsUrl);
                wmsCapabilities = wms.getCapabilities();
            }
            catch (Exception e) {
                e.printStackTrace();
                pageContext.showErrorDialog("Failed to access WMS:\n" + e.getMessage());
            }
        }
        this.history.copyInto(SnapApp.getDefault().getPreferences());
        if (wms != null && wmsCapabilities != null) {
            pageContext.setPropertyValue("wms", (Object)wms);
            pageContext.setPropertyValue("wmsCapabilities", (Object)wmsCapabilities);
            return new WmsAssistantPage2();
        }
        return null;
    }

    public boolean canFinish() {
        return false;
    }

    public Component createPageComponent() {
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        gbc.anchor = 17;
        gbc.gridy = 0;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.gridwidth = 2;
        panel.add((Component)new JLabel("URL for WMS (e.g. http://<host>/<server>):"), gbc);
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.gridwidth = 1;
        this.history = new UserInputHistory(8, PROPERTY_WMS_HISTORY);
        this.history.initBy(SnapApp.getDefault().getPreferences());
        if (this.history.getNumEntries() == 0) {
            this.history.push("http://geoservice.dlr.de/basemap/wms");
            this.history.push("https://www.geoseaportal.de/wss/service/StaticInformation_Background/guest");
        }
        this.wmsUrlBox = new JComboBox(new HistoryComboBoxModel(this.history));
        this.wmsUrlBox.setEditable(true);
        panel.add((Component)this.wmsUrlBox, gbc);
        this.wmsUrlBox.addItemListener(new MyItemListener());
        return panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebMapServer getWms(Window window, String wmsUrl) throws Exception {
        WebMapServer wms;
        try {
            window.setCursor(Cursor.getPredefinedCursor(3));
            URL url = new URL(wmsUrl);
            wms = new WebMapServer(url);
            this.getContext().setPropertyValue("wmsUrl", (Object)url);
        }
        finally {
            window.setCursor(Cursor.getDefaultCursor());
        }
        return wms;
    }

    private class MyItemListener
    implements ItemListener {
        private MyItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            WmsAssistantPage1.this.getContext().updateState();
        }
    }
}

