/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc.shapefile;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.dom.DefaultDomConverter;
import com.bc.ceres.binding.dom.DomConverter;
import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.binding.dom.XppDomElement;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.annotations.LayerTypeMetadata;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.xml.XppDomWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.transform.TransformerException;
import org.esa.snap.core.util.FeatureUtils;
import org.esa.snap.rcp.layermanager.layersrc.shapefile.FeatureLayer;
import org.geotools.data.FeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.SLDParser;
import org.geotools.styling.SLDTransformer;
import org.geotools.styling.Style;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@LayerTypeMetadata(name="FeatureLayerType", aliasNames={"FeatureLayerType"})
public class FeatureLayerType
extends LayerType {
    public static final String PROPERTY_NAME_SLD_STYLE = "sldStyle";
    public static final String PROPERTY_NAME_FEATURE_COLLECTION = "featureCollection";
    public static final String PROPERTY_NAME_FEATURE_COLLECTION_URL = "featureCollectionUrl";
    public static final String PROPERTY_NAME_FEATURE_COLLECTION_CRS = "featureCollectionTargetCrs";
    public static final String PROPERTY_NAME_FEATURE_COLLECTION_CLIP_GEOMETRY = "featureCollectionClipGeometry";

    public boolean isValidFor(LayerContext ctx) {
        return true;
    }

    public Layer createLayer(LayerContext ctx, PropertySet configuration) {
        FeatureCollection fc;
        CoordinateReferenceSystem targetCrs = null;
        if (ctx != null) {
            targetCrs = (CoordinateReferenceSystem)ctx.getCoordinateReferenceSystem();
        }
        if ((fc = (FeatureCollection)configuration.getValue(PROPERTY_NAME_FEATURE_COLLECTION)) == null) {
            try {
                URL url = (URL)configuration.getValue(PROPERTY_NAME_FEATURE_COLLECTION_URL);
                FeatureSource featureSource = FeatureUtils.getFeatureSource((URL)url);
                fc = featureSource.getFeatures();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        CoordinateReferenceSystem featureCrs = (CoordinateReferenceSystem)configuration.getValue(PROPERTY_NAME_FEATURE_COLLECTION_CRS);
        Geometry clipGeometry = (Geometry)configuration.getValue(PROPERTY_NAME_FEATURE_COLLECTION_CLIP_GEOMETRY);
        fc = FeatureUtils.clipCollection((FeatureCollection)fc, (CoordinateReferenceSystem)featureCrs, (Geometry)clipGeometry, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, null, (CoordinateReferenceSystem)targetCrs, (ProgressMonitor)ProgressMonitor.NULL);
        return new FeatureLayer(this, (FeatureCollection<SimpleFeatureType, SimpleFeature>)fc, configuration);
    }

    public PropertySet createLayerConfig(LayerContext ctx) {
        PropertyContainer configuration = new PropertyContainer();
        configuration.addProperty(Property.create((String)PROPERTY_NAME_FEATURE_COLLECTION, FeatureCollection.class));
        configuration.getDescriptor(PROPERTY_NAME_FEATURE_COLLECTION).setTransient(true);
        configuration.addProperty(Property.create((String)PROPERTY_NAME_SLD_STYLE, Style.class));
        configuration.getDescriptor(PROPERTY_NAME_SLD_STYLE).setDomConverter((DomConverter)new StyleDomConverter());
        configuration.getDescriptor(PROPERTY_NAME_SLD_STYLE).setNotNull(true);
        configuration.addProperty(Property.create((String)PROPERTY_NAME_FEATURE_COLLECTION_CLIP_GEOMETRY, Geometry.class));
        configuration.getDescriptor(PROPERTY_NAME_FEATURE_COLLECTION_CLIP_GEOMETRY).setDomConverter((DomConverter)new GeometryDomConverter());
        configuration.addProperty(Property.create((String)PROPERTY_NAME_FEATURE_COLLECTION_URL, URL.class));
        configuration.addProperty(Property.create((String)PROPERTY_NAME_FEATURE_COLLECTION_CRS, CoordinateReferenceSystem.class));
        configuration.getDescriptor(PROPERTY_NAME_FEATURE_COLLECTION_CRS).setDomConverter((DomConverter)new CRSDomConverter());
        return configuration;
    }

    private static class GeometryDomConverter
    implements DomConverter {
        private GeometryDomConverter() {
        }

        public Class<?> getValueType() {
            return Geometry.class;
        }

        public Object convertDomToValue(DomElement parentElement, Object value) throws ConversionException, ValidationException {
            GeometryFactory gf = new GeometryFactory();
            DefaultDomConverter domConverter = new DefaultDomConverter(Coordinate.class);
            DomElement[] children = (DomElement[])parentElement.getChildren("coordinate");
            ArrayList<Coordinate> coordList = new ArrayList<Coordinate>();
            for (DomElement child : children) {
                Coordinate coordinate = (Coordinate)domConverter.convertDomToValue(child, null);
                coordList.add(coordinate);
            }
            return gf.createPolygon(gf.createLinearRing(coordList.toArray(new Coordinate[coordList.size()])), null);
        }

        public void convertValueToDom(Object value, DomElement parentElement) throws ConversionException {
            Geometry geom = (Geometry)value;
            Coordinate[] coordinates = geom.getCoordinates();
            DefaultDomConverter domConverter = new DefaultDomConverter(Coordinate.class);
            for (Coordinate coordinate : coordinates) {
                DomElement child = parentElement.createChild("coordinate");
                domConverter.convertValueToDom((Object)coordinate, child);
            }
        }
    }

    private static class CRSDomConverter
    implements DomConverter {
        private CRSDomConverter() {
        }

        public Class<?> getValueType() {
            return null;
        }

        public Object convertDomToValue(DomElement parentElement, Object value) throws ConversionException, ValidationException {
            try {
                value = CRS.parseWKT((String)parentElement.getValue());
            }
            catch (FactoryException e) {
                throw new IllegalArgumentException(e);
            }
            return value;
        }

        public void convertValueToDom(Object value, DomElement parentElement) throws ConversionException {
            CoordinateReferenceSystem crs = (CoordinateReferenceSystem)value;
            parentElement.setValue(crs.toWKT());
        }
    }

    private static class StyleDomConverter
    implements DomConverter {
        private StyleDomConverter() {
        }

        public Class<?> getValueType() {
            return Style.class;
        }

        public Object convertDomToValue(DomElement parentElement, Object value) throws ConversionException, ValidationException {
            DomElement child = parentElement.getChild(0);
            SLDParser s = new SLDParser(CommonFactoryFinder.getStyleFactory(null), (Reader)new StringReader(child.toXml()));
            Style[] styles = s.readXML();
            return styles[0];
        }

        public void convertValueToDom(Object value, DomElement parentElement) throws ConversionException {
            Style style = (Style)value;
            SLDTransformer transformer = new SLDTransformer();
            transformer.setIndentation(2);
            try {
                String s = transformer.transform((Object)style);
                XppDomWriter domWriter = new XppDomWriter();
                new HierarchicalStreamCopier().copy((HierarchicalStreamReader)new XppReader((Reader)new StringReader(s)), (HierarchicalStreamWriter)domWriter);
                parentElement.addChild((DomElement)new XppDomElement(domWriter.getConfiguration()));
            }
            catch (TransformerException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

