/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.ProductNodeListenerAdapter;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.netbeans.docwin.WindowUtilities;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.colormanip.BrightnessContrastPanel;
import org.esa.snap.rcp.colormanip.ColorFormModel;
import org.esa.snap.rcp.colormanip.ColorManipulationChildForm;
import org.esa.snap.rcp.colormanip.ColorManipulationForm;
import org.esa.snap.rcp.colormanip.Continuous1BandSwitcherForm;
import org.esa.snap.rcp.colormanip.Continuous3BandGraphicalForm;
import org.esa.snap.rcp.colormanip.Discrete1BandTabularForm;
import org.esa.snap.rcp.colormanip.EmptyImageInfoForm;
import org.esa.snap.rcp.colormanip.ImageInfoEditorSupport;
import org.esa.snap.rcp.colormanip.MoreOptionsForm;
import org.esa.snap.rcp.colormanip.MoreOptionsPane;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.rcp.util.SelectionSupport;
import org.esa.snap.rcp.windows.ProductSceneViewTopComponent;
import org.esa.snap.runtime.Config;
import org.esa.snap.ui.AbstractDialog;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.SnapFileChooser;
import org.esa.snap.ui.product.BandChooser;
import org.esa.snap.ui.product.ProductSceneView;
import org.openide.windows.TopComponent;

class ColorManipulationFormImpl
implements SelectionSupport.Handler<ProductSceneView>,
ColorManipulationForm {
    private static final String PREFERENCES_KEY_IO_DIR = "snap.color_palettes.dir";
    private static final String FILE_EXTENSION = ".cpd";
    private AbstractButton resetButton;
    private AbstractButton multiApplyButton;
    private AbstractButton importButton;
    private AbstractButton exportButton;
    private final TopComponent toolView;
    private final ColorFormModel formModel;
    private Band[] bandsToBeModified;
    private SnapFileFilter snapFileFilter;
    private final ProductNodeListener productNodeListener;
    private boolean defaultColorPalettesInstalled;
    private JPanel contentPanel;
    private ColorManipulationChildForm childForm;
    private ColorManipulationChildForm continuous1BandSwitcherForm;
    private ColorManipulationChildForm discrete1BandTabularForm;
    private ColorManipulationChildForm continuous3BandGraphicalForm;
    private JPanel toolButtonsPanel;
    private AbstractButton helpButton;
    private Path ioDir;
    private JPanel editorPanel;
    private MoreOptionsPane moreOptionsPane;
    private SceneViewImageInfoChangeListener sceneViewChangeListener;
    private String titlePrefix;
    private ColorManipulationChildForm emptyForm;
    private BrightnessContrastPanel brightnessContrastPanel;
    private JTabbedPane tabbedPane;

    ColorManipulationFormImpl(TopComponent colorManipulationToolView, ColorFormModel formModel) {
        Assert.notNull((Object)colorManipulationToolView);
        Assert.notNull((Object)formModel);
        this.toolView = colorManipulationToolView;
        this.formModel = formModel;
        this.productNodeListener = new ColorManipulationPNL();
        this.sceneViewChangeListener = new SceneViewImageInfoChangeListener();
        this.titlePrefix = this.formModel.getTitlePrefix();
        this.emptyForm = new EmptyImageInfoForm(this);
    }

    @Override
    public ColorFormModel getFormModel() {
        return this.formModel;
    }

    @Override
    public JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.initContentPanel();
        }
        if (!this.defaultColorPalettesInstalled) {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            executorService.submit(new InstallDefaultColorPalettes());
        }
        return this.contentPanel;
    }

    @Override
    public void revalidateToolViewPaneControl() {
        this.getToolViewPaneControl().invalidate();
        this.getToolViewPaneControl().validate();
        this.getToolViewPaneControl().repaint();
        this.updateToolButtons();
    }

    private static AbstractButton createButton(String iconPath) {
        return ImageInfoEditorSupport.createButton(iconPath);
    }

    private Component getToolViewPaneControl() {
        return this.toolView;
    }

    private void setProductSceneView(ProductSceneView productSceneView) {
        ProductSceneView productSceneViewOld = this.getFormModel().getProductSceneView();
        if (productSceneViewOld != null) {
            Product product = productSceneViewOld.getProduct();
            if (product != null) {
                product.removeProductNodeListener(this.productNodeListener);
            }
            productSceneViewOld.removePropertyChangeListener((PropertyChangeListener)this.sceneViewChangeListener);
        }
        this.getFormModel().setProductSceneView(productSceneView);
        if (this.getFormModel().isValid()) {
            this.getFormModel().getProductSceneView().getProduct().addProductNodeListener(this.productNodeListener);
            this.getFormModel().getProductSceneView().addPropertyChangeListener((PropertyChangeListener)this.sceneViewChangeListener);
        }
        if (this.getFormModel().isValid()) {
            this.getFormModel().setModifiedImageInfo(this.getFormModel().getOriginalImageInfo());
        }
        this.installChildForm();
        this.updateTitle();
        this.updateToolButtons();
        this.updateMultiApplyState();
    }

    private void installChildForm() {
        ColorManipulationChildForm oldForm = this.childForm;
        ColorManipulationChildForm newForm = this.emptyForm;
        if (this.getFormModel().isValid()) {
            newForm = this.getFormModel().isContinuous3BandImage() ? (oldForm instanceof Continuous3BandGraphicalForm ? oldForm : this.getContinuous3BandGraphicalForm()) : (this.getFormModel().isContinuous1BandImage() ? (oldForm instanceof Continuous1BandSwitcherForm ? oldForm : this.getContinuous1BandSwitcherForm()) : (this.getFormModel().isDiscrete1BandImage() ? (oldForm instanceof Discrete1BandTabularForm ? oldForm : this.getDiscrete1BandTabularForm()) : (oldForm instanceof Continuous1BandSwitcherForm ? oldForm : this.getContinuous1BandSwitcherForm())));
        }
        if (newForm != oldForm) {
            this.childForm = newForm;
            this.installToolButtons();
            this.installMoreOptions();
            this.editorPanel.removeAll();
            this.editorPanel.add(this.childForm.getContentPanel(), "Center");
            if (!(this.childForm instanceof EmptyImageInfoForm)) {
                this.editorPanel.add((Component)this.moreOptionsPane.getContentPanel(), "South");
            }
            this.revalidateToolViewPaneControl();
            if (oldForm != null) {
                oldForm.handleFormHidden(this.getFormModel());
            }
            this.childForm.handleFormShown(this.getFormModel());
        } else {
            this.childForm.updateFormModel(this.getFormModel());
        }
    }

    private void updateTitle() {
        String titlePostfix = "";
        if (this.getFormModel().isValid()) {
            titlePostfix = " - " + this.getFormModel().getModelName();
        }
        this.toolView.setDisplayName(this.titlePrefix + titlePostfix);
    }

    private void updateToolButtons() {
        this.resetButton.setEnabled(this.getFormModel().isValid());
        this.importButton.setEnabled(this.getFormModel().isValid() && !this.getFormModel().isContinuous3BandImage());
        this.exportButton.setEnabled(this.getFormModel().isValid() && !this.getFormModel().isContinuous3BandImage());
    }

    private ColorManipulationChildForm getContinuous3BandGraphicalForm() {
        if (this.continuous3BandGraphicalForm == null) {
            this.continuous3BandGraphicalForm = new Continuous3BandGraphicalForm(this);
        }
        return this.continuous3BandGraphicalForm;
    }

    private ColorManipulationChildForm getContinuous1BandSwitcherForm() {
        if (this.continuous1BandSwitcherForm == null) {
            this.continuous1BandSwitcherForm = new Continuous1BandSwitcherForm(this);
        }
        return this.continuous1BandSwitcherForm;
    }

    private ColorManipulationChildForm getDiscrete1BandTabularForm() {
        if (this.discrete1BandTabularForm == null) {
            this.discrete1BandTabularForm = new Discrete1BandTabularForm(this);
        }
        return this.discrete1BandTabularForm;
    }

    @Override
    public ActionListener wrapWithAutoApplyActionListener(ActionListener actionListener) {
        return e -> {
            actionListener.actionPerformed(e);
            this.applyChanges();
        };
    }

    private void initContentPanel() {
        this.moreOptionsPane = new MoreOptionsPane(this, this.formModel.isMoreOptionsFormCollapsedOnInit());
        this.brightnessContrastPanel = new BrightnessContrastPanel(this);
        this.resetButton = ColorManipulationFormImpl.createButton("org/esa/snap/rcp/icons/Undo24.gif");
        this.resetButton.setName("ResetButton");
        this.resetButton.setToolTipText("Reset to defaults");
        this.resetButton.addActionListener(this.wrapWithAutoApplyActionListener(e -> this.resetToDefaults()));
        this.multiApplyButton = ColorManipulationFormImpl.createButton("org/esa/snap/rcp/icons/MultiAssignBands24.gif");
        this.multiApplyButton.setName("MultiApplyButton");
        this.multiApplyButton.setToolTipText("Apply to other bands");
        this.multiApplyButton.addActionListener(e -> this.applyMultipleColorPaletteDef());
        this.importButton = ColorManipulationFormImpl.createButton("tango/22x22/actions/document-open.png");
        this.importButton.setName("ImportButton");
        this.importButton.setToolTipText("Import colour palette from text file.");
        this.importButton.addActionListener(e -> {
            this.importColorPaletteDef();
            this.applyChanges();
        });
        this.importButton.setEnabled(true);
        this.exportButton = ColorManipulationFormImpl.createButton("tango/22x22/actions/document-save-as.png");
        this.exportButton.setName("ExportButton");
        this.exportButton.setToolTipText("Save colour palette to text file.");
        this.exportButton.addActionListener(e -> {
            this.exportColorPaletteDef();
            this.childForm.updateFormModel(this.getFormModel());
        });
        this.exportButton.setEnabled(true);
        this.helpButton = ColorManipulationFormImpl.createButton("tango/22x22/apps/help-browser.png");
        this.helpButton.setToolTipText("Help.");
        this.helpButton.setName("helpButton");
        this.helpButton.addActionListener(e -> this.toolView.getHelpCtx().display());
        this.editorPanel = new JPanel(new BorderLayout(4, 4));
        this.toolButtonsPanel = GridBagUtils.createPanel();
        this.contentPanel = new JPanel(new BorderLayout(4, 4));
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.contentPanel.setPreferredSize(new Dimension(320, 200));
        this.contentPanel.add((Component)this.editorPanel, "Center");
        this.contentPanel.add((Component)this.toolButtonsPanel, "East");
        this.setProductSceneView(SnapApp.getDefault().getSelectedProductSceneView());
        SnapApp.getDefault().getSelectionSupport(ProductSceneView.class).addHandler(this);
    }

    public void updateMultiApplyState() {
        this.multiApplyButton.setEnabled(this.getFormModel().isValid() && !this.getFormModel().isContinuous3BandImage());
    }

    @Override
    public void installToolButtons() {
        this.toolButtonsPanel.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.gridy = 0;
        gbc.insets.bottom = 0;
        gbc.gridwidth = 1;
        ++gbc.gridy;
        this.toolButtonsPanel.add((Component)this.resetButton, gbc);
        this.toolButtonsPanel.add((Component)this.multiApplyButton, gbc);
        ++gbc.gridy;
        this.toolButtonsPanel.add((Component)this.importButton, gbc);
        this.toolButtonsPanel.add((Component)this.exportButton, gbc);
        ++gbc.gridy;
        AbstractButton[] additionalButtons = this.childForm.getToolButtons();
        for (int i = 0; i < additionalButtons.length; ++i) {
            AbstractButton button = additionalButtons[i];
            this.toolButtonsPanel.add((Component)button, gbc);
            if (i % 2 != 1) continue;
            ++gbc.gridy;
        }
        ++gbc.gridy;
        gbc.fill = 3;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        this.toolButtonsPanel.add((Component)new JLabel(" "), gbc);
        gbc.fill = 0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        ++gbc.gridy;
        gbc.gridx = 1;
        this.toolButtonsPanel.add((Component)this.helpButton, gbc);
    }

    @Override
    public void installMoreOptions() {
        MoreOptionsForm moreOptionsForm = this.childForm.getMoreOptionsForm();
        if (moreOptionsForm != null) {
            moreOptionsForm.updateForm();
            if (this.tabbedPane == null) {
                this.tabbedPane = new JTabbedPane();
                this.tabbedPane.addTab("Histogram", moreOptionsForm.getContentPanel());
                this.tabbedPane.addTab("Brightness/Contrast", this.brightnessContrastPanel);
            }
            this.moreOptionsPane.setComponent(this.tabbedPane);
        }
    }

    @Override
    public void applyChanges() {
        this.updateMultiApplyState();
        if (this.getFormModel().isValid()) {
            try {
                this.getToolViewPaneControl().setCursor(Cursor.getPredefinedCursor(3));
                if (this.getFormModel().isContinuous3BandImage()) {
                    this.getFormModel().setRasters(this.childForm.getRasters());
                } else {
                    this.getFormModel().getRaster().setImageInfo(this.getFormModel().getModifiedImageInfo());
                }
                this.getFormModel().applyModifiedImageInfo();
            }
            finally {
                this.getToolViewPaneControl().setCursor(Cursor.getDefaultCursor());
            }
        }
        this.updateMultiApplyState();
    }

    private void resetToDefaults() {
        if (this.getFormModel().isValid()) {
            this.getFormModel().setModifiedImageInfo(this.createDefaultImageInfo());
            this.childForm.resetFormModel(this.getFormModel());
        }
    }

    private void applyMultipleColorPaletteDef() {
        if (!this.getFormModel().isValid()) {
            return;
        }
        Product selectedProduct = this.getFormModel().getProduct();
        ProductManager productManager = selectedProduct.getProductManager();
        RasterDataNode[] protectedRasters = this.getFormModel().getRasters();
        ArrayList<Band> availableBandList = new ArrayList<Band>();
        for (int i = 0; i < productManager.getProductCount(); ++i) {
            Band[] bands;
            Product product = productManager.getProduct(i);
            for (Band band : bands = product.getBands()) {
                boolean validBand = false;
                if (band.getImageInfo() != null) {
                    validBand = true;
                    for (RasterDataNode protectedRaster : protectedRasters) {
                        if (band != protectedRaster) continue;
                        validBand = false;
                    }
                }
                if (!validBand) continue;
                availableBandList.add(band);
            }
        }
        Band[] availableBands = new Band[availableBandList.size()];
        availableBandList.toArray(availableBands);
        availableBandList.clear();
        if (availableBands.length == 0) {
            AbstractDialog.showWarningDialog((Component)this.getToolViewPaneControl(), (String)"No other bands available.", (String)this.titlePrefix);
            return;
        }
        BandChooser bandChooser = new BandChooser(SwingUtilities.getWindowAncestor((Component)this.toolView), "Apply to other bands", this.toolView.getHelpCtx().getHelpID(), availableBands, this.bandsToBeModified, false);
        HashSet<Band> modifiedRasters = new HashSet<Band>(availableBands.length);
        if (bandChooser.show() == 1) {
            this.bandsToBeModified = bandChooser.getSelectedBands();
            for (Band band : this.bandsToBeModified) {
                this.applyColorPaletteDef(this.getFormModel().getModifiedImageInfo().getColorPaletteDef(), (RasterDataNode)band, band.getImageInfo());
                modifiedRasters.add(band);
            }
        }
        WindowUtilities.getOpened(ProductSceneViewTopComponent.class).forEach(tc -> {
            ProductSceneView view = tc.getView();
            for (RasterDataNode raster : view.getRasters()) {
                if (!modifiedRasters.contains(raster)) continue;
                view.updateImage();
                return;
            }
        });
    }

    private void setIODir(File dir) {
        this.ioDir = dir.toPath();
        Config.instance().preferences().put(PREFERENCES_KEY_IO_DIR, this.ioDir.toString());
    }

    @Override
    public Path getIODir() {
        if (this.ioDir == null) {
            this.ioDir = Paths.get(Config.instance().preferences().get(PREFERENCES_KEY_IO_DIR, this.getColorPalettesDir().toString()), new String[0]);
        }
        return this.ioDir;
    }

    private SnapFileFilter getOrCreateColorPaletteDefinitionFileFilter() {
        if (this.snapFileFilter == null) {
            String formatName = "COLOR_PALETTE_DEFINITION_FILE";
            String description = "Colour palette files (*.cpd)";
            this.snapFileFilter = new SnapFileFilter("COLOR_PALETTE_DEFINITION_FILE", FILE_EXTENSION, "Colour palette files (*.cpd)");
        }
        return this.snapFileFilter;
    }

    private void importColorPaletteDef() {
        ImageInfo targetImageInfo = this.getFormModel().getModifiedImageInfo();
        if (targetImageInfo == null) {
            return;
        }
        SnapFileChooser fileChooser = new SnapFileChooser();
        fileChooser.setDialogTitle("Import Colour Palette");
        fileChooser.setFileFilter((FileFilter)this.getOrCreateColorPaletteDefinitionFileFilter());
        fileChooser.setCurrentDirectory(this.getIODir().toFile());
        int result = fileChooser.showOpenDialog(this.getToolViewPaneControl());
        File file = fileChooser.getSelectedFile();
        if (file != null && file.getParentFile() != null) {
            this.setIODir(file.getParentFile());
        }
        if (result == 0 && file != null && file.canRead()) {
            try {
                ColorPaletteDef colorPaletteDef = ColorPaletteDef.loadColorPaletteDef((File)file);
                colorPaletteDef.getFirstPoint().setLabel(file.getName());
                this.applyColorPaletteDef(colorPaletteDef, this.getFormModel().getRaster(), targetImageInfo);
                this.getFormModel().setModifiedImageInfo(targetImageInfo);
                this.childForm.updateFormModel(this.getFormModel());
                this.updateMultiApplyState();
            }
            catch (IOException e) {
                this.showErrorDialog("Failed to import colour palette:\n" + e.getMessage());
            }
        }
    }

    private void applyColorPaletteDef(ColorPaletteDef colorPaletteDef, RasterDataNode targetRaster, ImageInfo targetImageInfo) {
        if (this.isIndexCoded(targetRaster)) {
            targetImageInfo.setColors(colorPaletteDef.getColors());
        } else {
            Stx stx = targetRaster.getStx(false, ProgressMonitor.NULL);
            Boolean autoDistribute = this.getAutoDistribute(colorPaletteDef);
            if (autoDistribute == null) {
                return;
            }
            targetImageInfo.setColorPaletteDef(colorPaletteDef, stx.getMinimum(), stx.getMaximum(), autoDistribute.booleanValue());
        }
    }

    private Boolean getAutoDistribute(ColorPaletteDef colorPaletteDef) {
        if (colorPaletteDef.isAutoDistribute()) {
            return Boolean.TRUE;
        }
        int answer = JOptionPane.showConfirmDialog(this.getToolViewPaneControl(), "Automatically distribute points of\ncolour palette between min/max?", "Import Colour Palette", 1);
        if (answer == 0) {
            return Boolean.TRUE;
        }
        if (answer == 1) {
            return Boolean.FALSE;
        }
        return null;
    }

    private boolean isIndexCoded(RasterDataNode targetRaster) {
        return targetRaster instanceof Band && ((Band)targetRaster).getIndexCoding() != null;
    }

    private void exportColorPaletteDef() {
        ImageInfo imageInfo = this.getFormModel().getModifiedImageInfo();
        if (imageInfo == null) {
            return;
        }
        SnapFileChooser fileChooser = new SnapFileChooser();
        fileChooser.setDialogTitle("Export Colour Palette");
        fileChooser.setFileFilter((FileFilter)this.getOrCreateColorPaletteDefinitionFileFilter());
        fileChooser.setCurrentDirectory(this.getIODir().toFile());
        int result = fileChooser.showSaveDialog(this.getToolViewPaneControl());
        File file = fileChooser.getSelectedFile();
        if (file != null && file.getParentFile() != null) {
            this.setIODir(file.getParentFile());
        }
        if (result == 0 && file != null && Boolean.TRUE.equals(Dialogs.requestOverwriteDecision(this.titlePrefix, file))) {
            file = FileUtils.ensureExtension((File)file, (String)FILE_EXTENSION);
            try {
                ColorPaletteDef colorPaletteDef = imageInfo.getColorPaletteDef();
                ColorPaletteDef.storeColorPaletteDef((ColorPaletteDef)colorPaletteDef, (File)file);
            }
            catch (IOException e) {
                this.showErrorDialog("Failed to export colour palette:\n" + e.getMessage());
            }
        }
    }

    private void showErrorDialog(String message) {
        if (message != null && message.trim().length() > 0) {
            if (SnapApp.getDefault() != null) {
                Dialogs.showError(message);
            } else {
                Dialogs.showError("Error", message);
            }
        }
    }

    private Path getColorPalettesDir() {
        return SystemUtils.getAuxDataPath().resolve("color_palettes");
    }

    private ImageInfo createDefaultImageInfo() {
        try {
            return ProductUtils.createImageInfo((RasterDataNode[])this.getFormModel().getRasters(), (boolean)false, (ProgressMonitor)ProgressMonitor.NULL);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.getContentPanel(), "Failed to create default image settings:\n" + e.getMessage(), "I/O Error", 0);
            return null;
        }
    }

    @Override
    public Stx getStx(RasterDataNode raster) {
        return raster.getStx(false, ProgressMonitor.NULL);
    }

    @Override
    public void selectionChange(ProductSceneView oldValue, ProductSceneView newValue) {
        if (this.getFormModel().getProductSceneView() == oldValue) {
            this.setProductSceneView(null);
        }
        this.setProductSceneView(newValue);
        if (this.brightnessContrastPanel != null) {
            if (oldValue != null) {
                this.brightnessContrastPanel.productSceneViewDeselected(oldValue);
            }
            if (newValue != null) {
                this.brightnessContrastPanel.productSceneViewSelected(newValue);
            }
        }
    }

    private class SceneViewImageInfoChangeListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("imageInfo".equals(evt.getPropertyName())) {
                boolean correctFormForRaster;
                boolean bl = correctFormForRaster = ColorManipulationFormImpl.this.getFormModel().getRaster() == ColorManipulationFormImpl.this.getFormModel().getProductSceneView().getRaster();
                if (correctFormForRaster) {
                    ImageInfo modifiedImageInfo = (ImageInfo)evt.getNewValue();
                    ColorManipulationFormImpl.this.getFormModel().setModifiedImageInfo(modifiedImageInfo);
                    ColorManipulationFormImpl.this.childForm.updateFormModel(ColorManipulationFormImpl.this.getFormModel());
                }
            }
        }
    }

    private class ColorManipulationPNL
    extends ProductNodeListenerAdapter {
        private ColorManipulationPNL() {
        }

        public void nodeChanged(ProductNodeEvent event) {
            RasterDataNode[] rasters = ColorManipulationFormImpl.this.childForm.getRasters();
            RasterDataNode raster = null;
            for (RasterDataNode dataNode : rasters) {
                if (event.getSourceNode() != dataNode) continue;
                raster = (RasterDataNode)event.getSourceNode();
            }
            if (raster != null) {
                String propertyName = event.getPropertyName();
                if ("name".equalsIgnoreCase(propertyName)) {
                    ColorManipulationFormImpl.this.updateTitle();
                    ColorManipulationFormImpl.this.childForm.handleRasterPropertyChange(event, raster);
                } else if ("ancillaryVariables".equalsIgnoreCase(propertyName)) {
                    ColorManipulationFormImpl.this.updateTitle();
                    ColorManipulationFormImpl.this.childForm.handleRasterPropertyChange(event, raster);
                } else if ("unit".equalsIgnoreCase(propertyName)) {
                    ColorManipulationFormImpl.this.childForm.handleRasterPropertyChange(event, raster);
                } else if ("stx".equalsIgnoreCase(propertyName)) {
                    ColorManipulationFormImpl.this.childForm.handleRasterPropertyChange(event, raster);
                } else if (RasterDataNode.isValidMaskProperty((String)propertyName)) {
                    ColorManipulationFormImpl.this.getStx(raster);
                }
            }
        }
    }

    private class InstallDefaultColorPalettes
    implements Runnable {
        private InstallDefaultColorPalettes() {
        }

        @Override
        public void run() {
            try {
                Path sourceBasePath = ResourceInstaller.findModuleCodeBasePath(GridBagUtils.class);
                Path auxdataDir = ColorManipulationFormImpl.this.getColorPalettesDir();
                Path sourceDirPath = sourceBasePath.resolve("auxdata/color_palettes");
                ResourceInstaller resourceInstaller = new ResourceInstaller(sourceDirPath, auxdataDir);
                resourceInstaller.install(".*.cpd", ProgressMonitor.NULL);
                ColorManipulationFormImpl.this.defaultColorPalettesInstalled = true;
            }
            catch (IOException e) {
                SnapApp.getDefault().handleError("Unable to install colour palettes", e);
            }
        }
    }
}

