/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import java.awt.Component;
import javax.swing.JLabel;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.rcp.colormanip.Bundle;
import org.esa.snap.rcp.colormanip.MoreOptionsForm;
import org.esa.snap.ui.product.ProductSceneView;

public class ColorFormModel {
    private ProductSceneView productSceneView;
    private ImageInfo modifiedImageInfo;

    public String getTitlePrefix() {
        return Bundle.CTL_ColorManipulationTopComponent_Name();
    }

    public ProductSceneView getProductSceneView() {
        return this.productSceneView;
    }

    public void setProductSceneView(ProductSceneView productSceneView) {
        this.productSceneView = productSceneView;
    }

    public RasterDataNode getRaster() {
        return this.getProductSceneView().getRaster();
    }

    public RasterDataNode[] getRasters() {
        return this.getProductSceneView().getRasters();
    }

    public void setRasters(RasterDataNode[] rasters) {
        this.getProductSceneView().setRasters(rasters);
    }

    public ImageInfo getOriginalImageInfo() {
        return this.getProductSceneView().getImageInfo();
    }

    public ImageInfo getModifiedImageInfo() {
        return this.modifiedImageInfo;
    }

    public void setModifiedImageInfo(ImageInfo imageInfo) {
        this.modifiedImageInfo = imageInfo.createDeepCopy();
    }

    public void applyModifiedImageInfo() {
        this.getProductSceneView().setImageInfo(this.getModifiedImageInfo());
    }

    public String getModelName() {
        return this.getProductSceneView().getSceneName();
    }

    public Product getProduct() {
        return this.getProductSceneView().getProduct();
    }

    public boolean isValid() {
        return this.getProductSceneView() != null;
    }

    public boolean isContinuous3BandImage() {
        return this.isValid() && this.getProductSceneView().isRGB();
    }

    public boolean isContinuous1BandImage() {
        return this.isValid() && !this.getProductSceneView().isRGB() && this.getRaster() instanceof Band && !((Band)this.getRaster()).isIndexBand();
    }

    public boolean isDiscrete1BandImage() {
        return this.isValid() && !this.getProductSceneView().isRGB() && this.getRaster() instanceof Band && ((Band)this.getRaster()).isIndexBand();
    }

    public boolean canUseHistogramMatching() {
        return true;
    }

    public boolean isMoreOptionsFormCollapsedOnInit() {
        return true;
    }

    void modifyMoreOptionsForm(MoreOptionsForm moreOptionsForm) {
    }

    void updateMoreOptionsFromImageInfo(MoreOptionsForm moreOptionsForm) {
    }

    void updateImageInfoFromMoreOptions(MoreOptionsForm moreOptionsForm) {
    }

    public Component createEmptyContentPanel() {
        return new JLabel("<html>This tool window is used to manipulate the<br><b>colouring of images</b> shown in an image view.<br> Right now, there is no selected image view.", 0);
    }
}

