/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.interactors;

import com.bc.ceres.glayer.swing.LayerCanvas;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import com.bc.ceres.swing.figure.ViewportInteractor;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.dataop.maptransf.Ellipsoid;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.product.ProductSceneView;
import org.openide.util.ImageUtilities;

class RangeFinderInteractor
extends ViewportInteractor {
    public static final String TITLE = "Range Finder Tool";
    private final List<ModelPoint> modelPointList = new ArrayList<ModelPoint>();
    private final ModelPoint currentModelPoint = new ModelPoint();
    private final Cursor cursor;
    private RangeFinderOverlay overlay;

    public RangeFinderInteractor() {
        ImageIcon cursorIcon = ImageUtilities.loadImageIcon((String)"org/esa/snap/rcp/cursors/RangeFinder.gif", (boolean)false);
        this.cursor = RangeFinderInteractor.createRangeFinderCursor(cursorIcon);
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void mouseDragged(MouseEvent e) {
        this.handleDragAndMove(e);
    }

    public void mouseMoved(MouseEvent e) {
        this.handleDragAndMove(e);
    }

    public void mouseClicked(MouseEvent e) {
        ProductSceneView view = this.getProductSceneView(e);
        if (view == null) {
            return;
        }
        if (this.overlay != null && view != this.overlay.view) {
            this.removeOverlay();
        }
        if (this.overlay == null) {
            this.createOverlay(view);
        }
        if (e.getClickCount() == 1) {
            Point viewPoint = e.getPoint();
            ModelPoint modelPoint = ModelPoint.create(view.getViewport(), viewPoint);
            this.modelPointList.add(modelPoint);
            this.currentModelPoint.setLocation(modelPoint);
            this.overlay.repaint();
        }
        if (e.getClickCount() == 2 && this.modelPointList.size() > 0) {
            this.showDetailsDialog(view);
            this.modelPointList.clear();
            this.removeOverlay();
        }
    }

    private void handleDragAndMove(MouseEvent e) {
        ProductSceneView view;
        if (this.modelPointList.size() > 0 && this.overlay != null && (view = this.getProductSceneView(e)) != null) {
            Point viewPoint = e.getPoint();
            ModelPoint modelPoint = ModelPoint.create(view.getViewport(), viewPoint);
            this.currentModelPoint.setLocation(modelPoint);
            this.overlay.repaint();
        }
    }

    private void createOverlay(ProductSceneView view) {
        this.overlay = new RangeFinderOverlay(view);
        view.getLayerCanvas().addOverlay((LayerCanvas.Overlay)this.overlay);
    }

    private void removeOverlay() {
        this.overlay.view.getLayerCanvas().removeOverlay((LayerCanvas.Overlay)this.overlay);
        this.overlay = null;
    }

    private ProductSceneView getProductSceneView(MouseEvent event) {
        Component eventComponent = event.getComponent();
        if (eventComponent instanceof ProductSceneView) {
            return (ProductSceneView)eventComponent;
        }
        Container parentComponent = eventComponent.getParent();
        if (parentComponent instanceof ProductSceneView) {
            return (ProductSceneView)parentComponent;
        }
        if (parentComponent.getParent() instanceof ProductSceneView) {
            return (ProductSceneView)parentComponent.getParent();
        }
        return null;
    }

    private void showDetailsDialog(ProductSceneView view) {
        GeoCoding geoCoding = view.getRaster().getGeoCoding();
        if (geoCoding == null) {
            Dialogs.showInformation(TITLE, String.format("No geo-coding information for %s.", view.getRaster().getName()), null);
            return;
        }
        float distance = 0.0f;
        float distanceError = 0.0f;
        AffineTransform m2i = view.getBaseImageLayer().getModelToImageTransform();
        Point imagePoint1 = new Point();
        Point imagePoint2 = new Point();
        DistanceData[] distanceData = new DistanceData[this.modelPointList.size() - 1];
        for (int i = 0; i < distanceData.length; ++i) {
            m2i.transform(this.modelPointList.get(i), imagePoint1);
            m2i.transform(this.modelPointList.get(i + 1), imagePoint2);
            DistanceData segmentData = new DistanceData(geoCoding, imagePoint1, imagePoint2);
            distance = (float)((double)distance + segmentData.distance);
            distanceError = (float)((double)distanceError + segmentData.distanceError);
            distanceData[i] = segmentData;
        }
        JButton detailsButton = new JButton("Details...");
        detailsButton.addActionListener(e -> {
            Window parentWindow = SwingUtilities.getWindowAncestor(detailsButton);
            RangeFinderInteractor.createDetailsDialog(parentWindow, distanceData).show();
        });
        JPanel buttonPane = new JPanel(new BorderLayout());
        buttonPane.add((Component)detailsButton, "East");
        JPanel messagePane = new JPanel(new BorderLayout(0, 6));
        messagePane.add(new JLabel("Distance: " + distance + " +/- " + distanceError + " km"));
        messagePane.add((Component)buttonPane, "South");
        JOptionPane.showMessageDialog(SnapApp.getDefault().getMainFrame(), messagePane, TITLE, 1);
    }

    private static ModalDialog createDetailsDialog(Window parentWindow, DistanceData[] dds) {
        float distance = 0.0f;
        float distanceError = 0.0f;
        StringBuilder message = new StringBuilder();
        for (int i = 0; i < dds.length; ++i) {
            DistanceData dd = dds[i];
            distance = (float)((double)distance + dd.distance);
            distanceError = (float)((double)distanceError + dd.distanceError);
            message.append("Distance between points " + i + " to " + (i + 1) + " in pixels:\nXH[" + dd.xH + "] to XN[" + dd.xN + "]: " + Math.abs(dd.xH - dd.xN) + "\nYH[" + dd.yH + "] to YN[" + dd.yN + "]: " + Math.abs(dd.yH - dd.yN) + "\n\nLonH: " + dd.lonH + "   LatH: " + dd.latH + "\nLonN: " + dd.lonN + "   LatN: " + dd.latN + "\n\nLamH: " + dd.lamH + "   PhiH: " + dd.phiH + "\nLamN: " + dd.lamN + "   PhiN: " + dd.phiN + "\n\nMean earth radius used: " + 6371.0 + " km\n\nDistance: " + dd.distance + " +/- " + dd.distanceError + " km\n\n\n");
        }
        message.insert(0, "Total distance: " + distance + " +/- " + distanceError + " km\n\ncomputed as described below:\n\n");
        JScrollPane content = new JScrollPane(new JTextArea(message.toString()));
        content.setPreferredSize(new Dimension(300, 150));
        ModalDialog detailsWindow = new ModalDialog(parentWindow, "Range Finder Tool - Details", 1, null);
        detailsWindow.setContent((Component)content);
        return detailsWindow;
    }

    private static Cursor createRangeFinderCursor(ImageIcon cursorIcon) {
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        String cursorName = "rangeFinder";
        Dimension bestCursorSize = defaultToolkit.getBestCursorSize(cursorIcon.getIconWidth(), cursorIcon.getIconHeight());
        Point hotSpot = new Point(7 * bestCursorSize.width / cursorIcon.getIconWidth(), 7 * bestCursorSize.height / cursorIcon.getIconHeight());
        return defaultToolkit.createCustomCursor(cursorIcon.getImage(), hotSpot, "rangeFinder");
    }

    private static class DistanceData {
        static final double MIN_EARTH_RADIUS = Ellipsoid.WGS_84.getSemiMinor();
        static final double MAX_EARTH_RADIUS = Ellipsoid.WGS_84.getSemiMajor();
        static final double MEAN_EARTH_RADIUS_M = 6371000.0;
        static final double MEAN_EARTH_RADIUS_KM = 6371.0;
        static final double MEAN_ERROR_FACTOR = MIN_EARTH_RADIUS / MAX_EARTH_RADIUS;
        final int xH;
        final int yH;
        final int xN;
        final int yN;
        final double lonH;
        final double latH;
        final double lonN;
        final double latN;
        final double lamH;
        final double phiH;
        final double lamN;
        final double phiN;
        final double distance;
        final double distanceError;

        public DistanceData(GeoCoding geoCoding, Point pH, Point pN) {
            this.xH = pH.x;
            this.yH = pH.y;
            this.xN = pN.x;
            this.yN = pN.y;
            GeoPos geoPosH = geoCoding.getGeoPos(new PixelPos((double)this.xH, (double)this.yH), null);
            GeoPos geoPosN = geoCoding.getGeoPos(new PixelPos((double)this.xN, (double)this.yN), null);
            this.lonH = geoPosH.getLon();
            this.latH = geoPosH.getLat();
            this.lonN = geoPosN.getLon();
            this.latN = geoPosN.getLat();
            this.lamH = Math.PI / 180 * this.lonH;
            this.phiH = Math.PI / 180 * this.latH;
            this.lamN = Math.PI / 180 * this.lonN;
            this.phiN = Math.PI / 180 * this.latN;
            this.distance = MathUtils.sphereDistance((double)6371.0, (double)this.lamH, (double)this.phiH, (double)this.lamN, (double)this.phiN);
            this.distanceError = this.distance * (1.0 - MEAN_ERROR_FACTOR);
        }
    }

    private class RangeFinderOverlay
    implements LayerCanvas.Overlay {
        private final ProductSceneView view;

        RangeFinderOverlay(ProductSceneView view) {
            this.view = view;
        }

        void repaint() {
            this.view.getLayerCanvas().repaint();
        }

        public void paintOverlay(LayerCanvas canvas, Rendering rendering) {
            if (RangeFinderInteractor.this.modelPointList.size() == 0) {
                return;
            }
            Graphics2D g2d = rendering.getGraphics();
            Stroke strokeOld = g2d.getStroke();
            g2d.setStroke(new BasicStroke(0.1f));
            Color colorOld = g2d.getColor();
            g2d.setColor(Color.red);
            g2d.translate(0.5, 0.5);
            int r = 3;
            int r2 = 6;
            Point viewPoint1 = null;
            Point viewPoint2 = null;
            Viewport viewport = canvas.getViewport();
            for (ModelPoint modelPoint : RangeFinderInteractor.this.modelPointList) {
                viewPoint1 = modelPoint.toViewPoint(viewport);
                g2d.drawOval(viewPoint1.x - 3, viewPoint1.y - 3, 6, 6);
                g2d.drawLine(viewPoint1.x, viewPoint1.y - 6, viewPoint1.x, viewPoint1.y - 3);
                g2d.drawLine(viewPoint1.x, viewPoint1.y + 6, viewPoint1.x, viewPoint1.y + 3);
                g2d.drawLine(viewPoint1.x - 6, viewPoint1.y, viewPoint1.x - 3, viewPoint1.y);
                g2d.drawLine(viewPoint1.x + 6, viewPoint1.y, viewPoint1.x + 3, viewPoint1.y);
                if (viewPoint2 != null) {
                    g2d.drawLine(viewPoint1.x, viewPoint1.y, viewPoint2.x, viewPoint2.y);
                }
                viewPoint2 = viewPoint1;
            }
            if (viewPoint1 != null) {
                viewPoint2 = RangeFinderInteractor.this.currentModelPoint.toViewPoint(canvas.getViewport());
                g2d.drawLine(viewPoint1.x, viewPoint1.y, viewPoint2.x, viewPoint2.y);
            }
            g2d.translate(-0.5, -0.5);
            g2d.setStroke(strokeOld);
            g2d.setColor(colorOld);
        }
    }

    private static class ModelPoint
    extends Point2D.Double {
        private static ModelPoint create(Viewport viewport, Point point) {
            return new ModelPoint(viewport.getViewToModelTransform().transform(point, new Point2D.Double()));
        }

        private ModelPoint() {
        }

        private ModelPoint(Point2D p) {
            super(p.getX(), p.getY());
        }

        private Point toViewPoint(Viewport viewport) {
            return (Point)viewport.getModelToViewTransform().transform(this, new Point());
        }
    }
}

