/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.interactors;

import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerFilter;
import com.bc.ceres.glayer.support.LayerUtils;
import com.bc.ceres.swing.figure.AbstractInteractorInterceptor;
import com.bc.ceres.swing.figure.Interactor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.rcp.actions.vector.CreateVectorDataNodeAction;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.product.ProductSceneView;
import org.esa.snap.ui.product.VectorDataLayer;
import org.esa.snap.ui.product.VectorDataLayerFilterFactory;

public class InsertFigureInteractorInterceptor
extends AbstractInteractorInterceptor {
    public boolean interactionAboutToStart(Interactor interactor, InputEvent inputEvent) {
        ProductSceneView productSceneView = this.getProductSceneView(inputEvent);
        return InsertFigureInteractorInterceptor.getActiveVectorDataLayer(productSceneView) != null;
    }

    public static VectorDataLayer getActiveVectorDataLayer(ProductSceneView productSceneView) {
        VectorDataLayer vectorDataLayer;
        Layer layer;
        if (productSceneView == null) {
            return null;
        }
        LayerFilter geometryFilter = VectorDataLayerFilterFactory.createGeometryFilter();
        if (geometryFilter.accept(layer = productSceneView.getSelectedLayer())) {
            layer.setVisible(true);
            return (VectorDataLayer)layer;
        }
        List layers = LayerUtils.getChildLayers((Layer)productSceneView.getRootLayer(), (LayerUtils.SearchMode)LayerUtils.SEARCH_DEEP, (LayerFilter)geometryFilter);
        if (layers.isEmpty()) {
            VectorDataNode vectorDataNode = CreateVectorDataNodeAction.createDefaultVectorDataNode(productSceneView.getProduct());
            LayerFilter nodeFilter = VectorDataLayerFilterFactory.createNodeFilter((VectorDataNode)vectorDataNode);
            productSceneView.getVectorDataCollectionLayer(true);
            vectorDataLayer = (VectorDataLayer)LayerUtils.getChildLayer((Layer)productSceneView.getRootLayer(), (LayerUtils.SearchMode)LayerUtils.SEARCH_DEEP, (LayerFilter)nodeFilter);
        } else {
            vectorDataLayer = layers.size() == 1 ? (VectorDataLayer)layers.get(0) : InsertFigureInteractorInterceptor.showSelectLayerDialog(productSceneView, layers);
        }
        if (vectorDataLayer == null) {
            return null;
        }
        productSceneView.setSelectedLayer((Layer)vectorDataLayer);
        if (productSceneView.getSelectedLayer() == vectorDataLayer) {
            vectorDataLayer.setVisible(true);
            return vectorDataLayer;
        }
        return null;
    }

    private static VectorDataLayer showSelectLayerDialog(ProductSceneView productSceneView, List<Layer> layers) {
        int index;
        String[] layerNames = new String[layers.size()];
        for (int i = 0; i < layerNames.length; ++i) {
            layerNames[i] = layers.get(i).getName();
        }
        JList<String> listBox = new JList<String>(layerNames);
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.add((Component)new JLabel("Please select a vector data container:"), "North");
        panel.add((Component)new JScrollPane(listBox), "Center");
        ModalDialog dialog = new ModalDialog(SwingUtilities.getWindowAncestor((Component)productSceneView), "Select Vector Data Container", 161, "");
        dialog.setContent((Component)panel);
        int i = dialog.show();
        if (i == 1 && (index = listBox.getSelectedIndex()) >= 0) {
            return (VectorDataLayer)layers.get(index);
        }
        return null;
    }

    private ProductSceneView getProductSceneView(InputEvent event) {
        ProductSceneView productSceneView = null;
        for (Component component = event.getComponent(); component != null; component = component.getParent()) {
            if (!(component instanceof ProductSceneView)) continue;
            productSceneView = (ProductSceneView)component;
            break;
        }
        return productSceneView;
    }
}

